/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class BuildBase.
 * 
 * @version $Revision$ $Date$
 */
public class BuildBase extends PluginConfiguration 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field defaultGoal
     */
    private String defaultGoal;

    /**
     * Field resources
     */
    private java.util.List resources;

    /**
     * Field testResources
     */
    private java.util.List testResources;

    /**
     * Field directory
     */
    private String directory;

    /**
     * Field finalName
     */
    private String finalName;

    /**
     * Field filters
     */
    private java.util.List filters;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFilter
     * 
     * @param string
     */
    public void addFilter(String string)
    {
        getFilters().add( string );
    } //-- void addFilter(String) 

    /**
     * Method addResource
     * 
     * @param resource
     */
    public void addResource(Resource resource)
    {
        getResources().add( resource );
    } //-- void addResource(Resource) 

    /**
     * Method addTestResource
     * 
     * @param resource
     */
    public void addTestResource(Resource resource)
    {
        getTestResources().add( resource );
    } //-- void addTestResource(Resource) 

    /**
     * Method getDefaultGoal
     */
    public String getDefaultGoal()
    {
        return this.defaultGoal;
    } //-- String getDefaultGoal() 

    /**
     * Method getDirectory
     */
    public String getDirectory()
    {
        return this.directory;
    } //-- String getDirectory() 

    /**
     * Method getFilters
     */
    public java.util.List getFilters()
    {
        if ( this.filters == null )
        {
            this.filters = new java.util.ArrayList();
        }
        
        return this.filters;
    } //-- java.util.List getFilters() 

    /**
     * Method getFinalName
     */
    public String getFinalName()
    {
        return this.finalName;
    } //-- String getFinalName() 

    /**
     * Method getResources
     */
    public java.util.List getResources()
    {
        if ( this.resources == null )
        {
            this.resources = new java.util.ArrayList();
        }
        
        return this.resources;
    } //-- java.util.List getResources() 

    /**
     * Method getTestResources
     */
    public java.util.List getTestResources()
    {
        if ( this.testResources == null )
        {
            this.testResources = new java.util.ArrayList();
        }
        
        return this.testResources;
    } //-- java.util.List getTestResources() 

    /**
     * Method removeFilter
     * 
     * @param string
     */
    public void removeFilter(String string)
    {
        getFilters().remove( string );
    } //-- void removeFilter(String) 

    /**
     * Method removeResource
     * 
     * @param resource
     */
    public void removeResource(Resource resource)
    {
        getResources().remove( resource );
    } //-- void removeResource(Resource) 

    /**
     * Method removeTestResource
     * 
     * @param resource
     */
    public void removeTestResource(Resource resource)
    {
        getTestResources().remove( resource );
    } //-- void removeTestResource(Resource) 

    /**
     * Method setDefaultGoal
     * 
     * @param defaultGoal
     */
    public void setDefaultGoal(String defaultGoal)
    {
        this.defaultGoal = defaultGoal;
    } //-- void setDefaultGoal(String) 

    /**
     * Method setDirectory
     * 
     * @param directory
     */
    public void setDirectory(String directory)
    {
        this.directory = directory;
    } //-- void setDirectory(String) 

    /**
     * Method setFilters
     * 
     * @param filters
     */
    public void setFilters(java.util.List filters)
    {
        this.filters = filters;
    } //-- void setFilters(java.util.List) 

    /**
     * Method setFinalName
     * 
     * @param finalName
     */
    public void setFinalName(String finalName)
    {
        this.finalName = finalName;
    } //-- void setFinalName(String) 

    /**
     * Method setResources
     * 
     * @param resources
     */
    public void setResources(java.util.List resources)
    {
        this.resources = resources;
    } //-- void setResources(java.util.List) 

    /**
     * Method setTestResources
     * 
     * @param testResources
     */
    public void setTestResources(java.util.List testResources)
    {
        this.testResources = testResources;
    } //-- void setTestResources(java.util.List) 

}
