/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         Modifications to the build process which is activated
 * based on environmental
 *         parameters or command line arguments.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Profile extends ModelBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field activation
     */
    private Activation activation;

    /**
     * Field build
     */
    private BuildBase build;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             
     *             The conditional logic which will automatically
     *             trigger the inclusion of this profile.
     *             
     *           
     */
    public Activation getActivation()
    {
        return this.activation;
    } //-- Activation getActivation() 

    /**
     * Get 
     *             
     *             Information required to build the project.
     *             
     *           
     */
    public BuildBase getBuild()
    {
        return this.build;
    } //-- BuildBase getBuild() 

    /**
     * Get 
     *             The identifier of this build profile. This used
     * both for
     *             command line activation, and identifies
     * identical profiles
     *             to merge with during inheritance.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Set 
     *             
     *             The conditional logic which will automatically
     *             trigger the inclusion of this profile.
     *             
     *           
     * 
     * @param activation
     */
    public void setActivation(Activation activation)
    {
        this.activation = activation;
    } //-- void setActivation(Activation) 

    /**
     * Set 
     *             
     *             Information required to build the project.
     *             
     *           
     * 
     * @param build
     */
    public void setBuild(BuildBase build)
    {
        this.build = build;
    } //-- void setBuild(BuildBase) 

    /**
     * Set 
     *             The identifier of this build profile. This used
     * both for
     *             command line activation, and identifies
     * identical profiles
     *             to merge with during inheritance.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 


            
    // We don't want this to be parseable...it's sort of 'hidden'
    // default source for this profile is in the pom itself.
    private String source = "pom";

    public void setSource( String source )
    {
        this.source = source;
    }

    public String getSource()
    {
        return source;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Profile {id: " + getId() + ", source: " + getSource() + "}";
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
