/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         This is the file specification used to activate the
 * profile. The missing value will be the location
 *         of a file that needs to exist, and if it doesn't the
 * profile will be activated.  On the other hand exists will test
 *         for the existence of the file and if it is there the
 * profile will be activated.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ActivationFile implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field missing
     */
    private String missing;

    /**
     * Field exists
     */
    private String exists;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get The name of the file that must exist to activate the
     * profile.
     */
    public String getExists()
    {
        return this.exists;
    } //-- String getExists() 

    /**
     * Get The name of the file that must be missing to activate
     * the profile.
     */
    public String getMissing()
    {
        return this.missing;
    } //-- String getMissing() 

    /**
     * Set The name of the file that must exist to activate the
     * profile.
     * 
     * @param exists
     */
    public void setExists(String exists)
    {
        this.exists = exists;
    } //-- void setExists(String) 

    /**
     * Set The name of the file that must be missing to activate
     * the profile.
     * 
     * @param missing
     */
    public void setMissing(String missing)
    {
        this.missing = missing;
    } //-- void setMissing(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
