/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Section for management of default dependency information for use
 * in a group of
 *         POMs.
 * 
 * @version $Revision$ $Date$
 */
public class DependencyManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field dependencies.
     */
    private java.util.List dependencies;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency.
     * 
     * @param dependency
     */
    public void addDependency( Dependency dependency )
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "DependencyManagement.addDependencies(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencies().add( dependency );
    } //-- void addDependency( Dependency ) 

    /**
     * Method getDependencies.
     * 
     * @return java.util.List
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
    
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Method removeDependency.
     * 
     * @param dependency
     */
    public void removeDependency( Dependency dependency )
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "DependencyManagement.removeDependencies(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencies().remove( dependency );
    } //-- void removeDependency( Dependency ) 

    /**
     * Set the dependencies specified here are not used until they
     * are referenced in a
     *             POM within the group. This allows the
     * specification of a "standard" version for a
     *             particular dependency.
     * 
     * @param dependencies
     */
    public void setDependencies( java.util.List dependencies )
    {
        this.dependencies = dependencies;
    } //-- void setDependencies( java.util.List ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
