/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.maven.jxr.log.Log;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;
import org.codehaus.plexus.util.DirectoryScanner;

public class PackageManager {
    private final Log log;
    private Hashtable directories = new Hashtable();
    private Hashtable packages = new Hashtable();
    private PackageType defaultPackage = new PackageType();
    private FileManager fileManager;

    public PackageManager(Log log, FileManager fileManager) {
        this.log = log;
        this.fileManager = fileManager;
    }

    public PackageType getPackageType(String name) {
        if (name == null) {
            return this.defaultPackage;
        }
        return (PackageType)this.packages.get(name);
    }

    public void addPackageType(PackageType packageType) {
        this.packages.put(packageType.getName(), packageType);
    }

    public Enumeration getPackageTypes() {
        return this.packages.elements();
    }

    private void parse(String directory) {
        this.log.info("Scanning " + directory);
        DirectoryScanner directoryScanner = new DirectoryScanner();
        File baseDir = new File(directory);
        directoryScanner.setBasedir(baseDir);
        String[] includes = new String[]{"**/*.java"};
        directoryScanner.setIncludes(includes);
        directoryScanner.scan();
        String[] files = directoryScanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            this.log.debug("parsing... " + files[j]);
            try {
                String fileName = new File(baseDir, files[j]).getAbsolutePath();
                JavaFile jfi = this.fileManager.getFile(fileName);
                PackageType jp = this.getPackageType(jfi.getPackageType().getName());
                if (jp == null) {
                    this.addPackageType(jfi.getPackageType());
                    jp = jfi.getPackageType();
                }
                if (jfi.getClassType() == null || jfi.getClassType().getName() == null) continue;
                jp.addClassType(jfi.getClassType());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(String directory) {
        if (this.directories.get(directory) == null) {
            this.parse(directory);
            this.directories.put(directory, directory);
        }
    }

    public void process(String[] directories) {
        for (int i = 0; i < directories.length; ++i) {
            this.process(directories[i]);
        }
    }

    public void dump() {
        this.log.debug("Dumping out PackageManager structure");
        Enumeration pts = this.getPackageTypes();
        while (pts.hasMoreElements()) {
            PackageType current = (PackageType)pts.nextElement();
            this.log.debug(current.getName());
            Enumeration classes = current.getClassTypes();
            while (classes.hasMoreElements()) {
                ClassType currentClass = (ClassType)classes.nextElement();
                this.log.debug("\t" + currentClass.getName());
            }
        }
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }
}

