/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.log.Log;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.maven.jxr.pacman.PackageType;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.IOUtil;

public class DirectoryIndexer {
    static final String INDEX = "package-summary.html";
    private String root;
    private PackageManager packageManager;
    private String outputEncoding;
    private String templateDir;
    private String windowTitle;
    private String docTitle;
    private String bottom;
    static /* synthetic */ Class class$org$apache$maven$jxr$log$Log;
    static /* synthetic */ Class class$org$apache$maven$jxr$log$VelocityLogger;

    public DirectoryIndexer(PackageManager packageManager, String root) {
        this.packageManager = packageManager;
        this.root = root;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setBottom(String bottom) {
        this.bottom = bottom;
    }

    public String getBottom() {
        return this.bottom;
    }

    public void process(Log log) throws JxrException {
        Map info = this.getPackageInfo();
        VelocityEngine engine = new VelocityEngine();
        this.setProperties(engine, log);
        try {
            engine.init();
        }
        catch (Exception e) {
            throw new JxrException("Error initialising Velocity", e);
        }
        VelocityContext context = new VelocityContext();
        context.put("outputEncoding", (Object)this.getOutputEncoding());
        context.put("windowTitle", (Object)this.getWindowTitle());
        context.put("docTitle", (Object)this.getDocTitle());
        context.put("bottom", (Object)this.getBottom());
        context.put("info", (Object)info);
        this.doVelocity("index", this.root, context, engine);
        this.doVelocity("overview-frame", this.root, context, engine);
        this.doVelocity("allclasses-frame", this.root, context, engine);
        this.doVelocity("overview-summary", this.root, context, engine);
        Iterator iter = ((Map)info.get("allPackages")).values().iterator();
        while (iter.hasNext()) {
            Map pkgInfo = (Map)iter.next();
            VelocityContext subContext = new VelocityContext((Context)context);
            subContext.put("pkgInfo", (Object)pkgInfo);
            String outDir = this.root + "/" + (String)pkgInfo.get("dir");
            this.doVelocity("package-summary", outDir, subContext, engine);
            this.doVelocity("package-frame", outDir, subContext, engine);
        }
    }

    private void setProperties(VelocityEngine engine, Log log) {
        File templateDirFile = new File(this.getTemplateDir());
        if (templateDirFile.isAbsolute()) {
            engine.setProperty("resource.loader", (Object)"file");
            engine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            engine.setProperty("file.resource.loader.path", (Object)templateDirFile.toString());
        } else {
            engine.setProperty("resource.loader", (Object)"classpath");
            engine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        }
        engine.setProperty((class$org$apache$maven$jxr$log$Log == null ? (class$org$apache$maven$jxr$log$Log = DirectoryIndexer.class$("org.apache.maven.jxr.log.Log")) : class$org$apache$maven$jxr$log$Log).getName(), (Object)log);
        engine.setProperty("runtime.log.logsystem.class", (Object)(class$org$apache$maven$jxr$log$VelocityLogger == null ? (class$org$apache$maven$jxr$log$VelocityLogger = DirectoryIndexer.class$("org.apache.maven.jxr.log.VelocityLogger")) : class$org$apache$maven$jxr$log$VelocityLogger).getName());
    }

    private void doVelocity(String templateName, String outDir, VelocityContext context, VelocityEngine engine) throws JxrException {
        File file = new File(outDir, templateName + ".html");
        file.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            StringBuffer templateFile = new StringBuffer();
            File templateDirFile = new File(this.getTemplateDir());
            if (!templateDirFile.isAbsolute()) {
                templateFile.append(this.getTemplateDir());
                templateFile.append("/");
            }
            templateFile.append(templateName);
            templateFile.append(".vm");
            Template template = engine.getTemplate(templateFile.toString());
            template.merge((Context)context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            try {
                throw new JxrException("Error merging velocity template", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private Map getPackageInfo() {
        TreeMap allPackages = new TreeMap();
        TreeMap allClasses = new TreeMap();
        Perl5Util perl = new Perl5Util();
        Enumeration packages = this.packageManager.getPackageTypes();
        while (packages.hasMoreElements()) {
            PackageType pkg = (PackageType)packages.nextElement();
            String pkgName = pkg.getName();
            String pkgDir = perl.substitute("s/\\./\\//g", pkgName);
            String rootRef = perl.substitute("s/[^\\.]*(\\.|$)/\\.\\.\\//g", pkgName);
            if (pkgName.length() == 0) {
                pkgName = "(default package)";
                pkgDir = ".";
                rootRef = "./";
            }
            TreeMap pkgClasses = new TreeMap();
            Enumeration classes = pkg.getClassTypes();
            while (classes.hasMoreElements()) {
                ClassType clazz = (ClassType)classes.nextElement();
                String className = clazz.getName();
                HashMap<String, String> classInfo = new HashMap<String, String>();
                classInfo.put("name", className);
                classInfo.put("dir", pkgDir);
                pkgClasses.put(className, classInfo);
                allClasses.put(className, classInfo);
            }
            HashMap<String, Object> pkgInfo = new HashMap<String, Object>();
            pkgInfo.put("name", pkgName);
            pkgInfo.put("dir", pkgDir);
            pkgInfo.put("classes", pkgClasses);
            pkgInfo.put("rootRef", rootRef);
            allPackages.put(pkgName, pkgInfo);
        }
        HashMap info = new HashMap();
        info.put("allPackages", allPackages);
        info.put("allClasses", allClasses);
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

