/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoSink;
import org.apache.maven.doxia.module.fo.NumberedListItem;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class FoAggregateSink
extends FoSink {
    public static final int TOC_NONE = 0;
    public static final int TOC_START = 1;
    public static final int TOC_END = 2;
    private static final String COVER_HEADER_HEIGHT = "1.5in";
    private DocumentModel docModel;
    private int chapter = 0;
    private String docName;
    private String docTitle = "";
    private boolean ignoreText;
    private int tocPosition;
    private final Stack<NumberedListItem> tocStack = new Stack();

    public FoAggregateSink(Writer writer) {
        super(writer);
    }

    @Override
    public void head() {
        this.head(null);
    }

    @Override
    public void head(SinkEventAttributes attributes) {
        this.init();
        this.ignoreText = true;
    }

    @Override
    public void head_() {
        this.ignoreText = false;
        this.writeEOL();
    }

    @Override
    public void title() {
        this.title(null);
    }

    @Override
    public void title(SinkEventAttributes attributes) {
    }

    @Override
    public void title_() {
    }

    @Override
    public void author() {
        this.author(null);
    }

    @Override
    public void author(SinkEventAttributes attributes) {
    }

    @Override
    public void author_() {
    }

    @Override
    public void date() {
        this.date(null);
    }

    @Override
    public void date(SinkEventAttributes attributes) {
    }

    @Override
    public void date_() {
    }

    @Override
    public void body() {
        this.body(null);
    }

    @Override
    public void body(SinkEventAttributes attributes) {
        ++this.chapter;
        this.resetSectionCounter();
        this.startPageSequence(this.getHeaderText(), this.getFooterText());
        if (this.docName == null) {
            this.getLog().warn((CharSequence)"No document root specified, local links will not be resolved correctly!");
        } else {
            this.writeStartTag(BLOCK_TAG, "id", this.docName);
        }
    }

    @Override
    public void body_() {
        this.writeEOL();
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.docName = null;
    }

    public void setDocumentTitle(String title) {
        this.docTitle = title;
        if (title == null) {
            this.docTitle = "";
        }
    }

    public void setDocumentName(String name) {
        this.docName = this.getIdName(name);
    }

    public void setDocumentModel(DocumentModel model) {
        this.setDocumentModel(model, 1);
    }

    public void setDocumentModel(DocumentModel model, int tocPos) {
        this.docModel = model;
        if (tocPos != 0 && tocPos != 1 && tocPos != 2) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Unrecognized value for tocPosition: " + tocPos + ", using no toc."));
            }
            tocPos = 0;
        }
        this.tocPosition = tocPos;
        if (this.docModel != null && this.docModel.getToc() != null && this.tocPosition != 0) {
            DocumentTOCItem tocItem = new DocumentTOCItem();
            tocItem.setName(this.docModel.getToc().getName());
            tocItem.setRef("./toc");
            LinkedList<DocumentTOCItem> items = new LinkedList<DocumentTOCItem>();
            if (this.tocPosition == 1) {
                items.add(tocItem);
            }
            items.addAll(this.docModel.getToc().getItems());
            if (this.tocPosition == 2) {
                items.add(tocItem);
            }
            this.docModel.getToc().setItems(items);
        }
    }

    private String getIdName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            this.getLog().warn((CharSequence)"Empty document reference, links will not be resolved correctly!");
            return "";
        }
        String idName = name.replace('\\', '/');
        if (!idName.startsWith("./")) {
            idName = "./" + idName;
        }
        if (idName.substring(2).lastIndexOf(".") != -1) {
            idName = idName.substring(0, idName.lastIndexOf("."));
        }
        while (idName.indexOf("//") != -1) {
            idName = StringUtils.replace((String)idName, (String)"//", (String)"/");
        }
        return idName;
    }

    @Override
    public void figureGraphics(String name) {
        this.figureGraphics(name, null);
    }

    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        String anchor = src;
        while (anchor.startsWith("./")) {
            anchor = anchor.substring(2);
        }
        if (anchor.startsWith("../") && this.docName != null) {
            anchor = this.resolveLinkRelativeToBase(anchor);
        }
        super.figureGraphics(anchor, attributes);
    }

    @Override
    public void anchor(String name) {
        this.anchor(name, null);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        String anchor = name;
        if (!DoxiaUtils.isValidId((String)anchor)) {
            anchor = DoxiaUtils.encodeId((String)name, (boolean)true);
            String msg = "Modified invalid anchor name: '" + name + "' to '" + anchor + "'";
            this.logMessage("modifiedLink", msg);
        }
        anchor = "#" + anchor;
        if (this.docName != null) {
            anchor = this.docName + anchor;
        }
        this.writeStartTag(INLINE_TAG, "id", anchor);
    }

    @Override
    public void link(String name) {
        this.link(name, null);
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.writeStartTag(BASIC_LINK_TAG, "external-destination", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(INLINE_TAG, "href.external");
            return;
        }
        while (name.indexOf("//") != -1) {
            name = StringUtils.replace((String)name, (String)"//", (String)"/");
        }
        if (DoxiaUtils.isInternalLink((String)name)) {
            String anchor = name.substring(1);
            if (!DoxiaUtils.isValidId((String)anchor)) {
                String tmp = anchor;
                anchor = DoxiaUtils.encodeId((String)anchor, (boolean)true);
                String msg = "Modified invalid anchor name: '" + tmp + "' to '" + anchor + "'";
                this.logMessage("modifiedLink", msg);
            }
            if (this.docName != null) {
                anchor = this.docName + "#" + anchor;
            }
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else if (name.startsWith("../")) {
            if (this.docName == null) {
                this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)name));
                this.writeStartTag(INLINE_TAG, "href.internal");
                return;
            }
            String anchor = this.resolveLinkRelativeToBase(this.chopExtension(name));
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else {
            String anchor = name;
            if (anchor.startsWith("./")) {
                this.link(anchor.substring(2));
                return;
            }
            anchor = this.chopExtension(anchor);
            String base = this.docName.substring(0, this.docName.lastIndexOf("/"));
            anchor = base + "/" + anchor;
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        }
    }

    private String resolveLinkRelativeToBase(String name) {
        String anchor = name;
        String base = this.docName.substring(0, this.docName.lastIndexOf("/"));
        if (base.indexOf("/") != -1) {
            while (anchor.startsWith("../")) {
                base = base.substring(0, base.lastIndexOf("/"));
                anchor = anchor.substring(3);
                if (base.lastIndexOf("/") != -1) continue;
                while (anchor.startsWith("../")) {
                    anchor = anchor.substring(3);
                }
                break block0;
            }
        }
        return base + "/" + anchor;
    }

    private String chopExtension(String name) {
        String anchor = name;
        int dot = anchor.lastIndexOf(".");
        if (dot != -1 && dot != anchor.length() && anchor.charAt(dot + 1) != '/') {
            int dot2;
            int hash = anchor.indexOf("#", dot);
            anchor = hash != -1 ? ((dot2 = anchor.indexOf(".", hash)) != -1 ? anchor.substring(0, dot) + "#" + HtmlTools.encodeId((String)anchor.substring(hash + 1, dot2)) : anchor.substring(0, dot) + "#" + HtmlTools.encodeId((String)anchor.substring(hash + 1, anchor.length()))) : anchor.substring(0, dot);
        }
        return anchor;
    }

    @Override
    protected void writeStartTag(HTML.Tag tag, String attributeId) {
        if (!this.ignoreText) {
            super.writeStartTag(tag, attributeId);
        }
    }

    @Override
    protected void writeStartTag(HTML.Tag tag, String id, String name) {
        if (!this.ignoreText) {
            super.writeStartTag(tag, id, name);
        }
    }

    @Override
    protected void writeEndTag(HTML.Tag t) {
        if (!this.ignoreText) {
            super.writeEndTag(t);
        }
    }

    @Override
    protected void writeEmptyTag(HTML.Tag tag, String attributeId) {
        if (!this.ignoreText) {
            super.writeEmptyTag(tag, attributeId);
        }
    }

    @Override
    protected void write(String text) {
        if (!this.ignoreText) {
            super.write(text);
        }
    }

    @Override
    protected void writeln(String text) {
        if (!this.ignoreText) {
            super.writeln(text);
        }
    }

    @Override
    protected void content(String text) {
        if (!this.ignoreText) {
            super.content(text);
        }
    }

    protected void newline() {
        if (!this.ignoreText) {
            this.writeEOL();
        }
    }

    protected void startPageSequence(String headerText, String footerText) {
        if (this.chapter == 1) {
            this.startPageSequence("0", headerText, footerText);
        } else {
            this.startPageSequence("auto", headerText, footerText);
        }
    }

    protected String getHeaderText() {
        return Integer.toString(this.chapter) + "   " + this.docTitle;
    }

    protected String getFooterText() {
        int actualYear;
        String add = " &#8226; " + this.getBundle(Locale.US).getString("footer.rights");
        String companyName = "";
        if (this.docModel != null && this.docModel.getMeta() != null && this.docModel.getMeta().isConfidential()) {
            add = add + " &#8226; " + this.getBundle(Locale.US).getString("footer.confidential");
        }
        if (this.docModel != null && this.docModel.getCover() != null && this.docModel.getCover().getCompanyName() != null) {
            companyName = this.docModel.getCover().getCompanyName();
        }
        if (this.docModel != null && this.docModel.getMeta() != null && this.docModel.getMeta().getDate() != null) {
            Calendar date = Calendar.getInstance();
            date.setTime(this.docModel.getMeta().getDate());
            actualYear = date.get(1);
        } else {
            actualYear = Calendar.getInstance().get(1);
        }
        return "&#169;" + actualYear + ", " + FoAggregateSink.escaped(companyName, false) + add;
    }

    @Override
    protected String getChapterString() {
        return Integer.toString(this.chapter) + ".";
    }

    @Override
    protected void regionBefore(String headerText) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-before");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "5.625in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.625in");
        this.writeStartTag(TABLE_BODY_TAG, "");
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "header.style");
        if (headerText != null) {
            this.write(headerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "page.number");
        this.writeEmptyTag(PAGE_NUMBER_TAG, "");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    @Override
    protected void regionAfter(String footerText) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-after");
        this.writeStartTag(BLOCK_TAG, "footer.style");
        if (footerText != null) {
            this.write(footerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    @Override
    protected void chapterHeading(String headerText, boolean chapterNumber) {
        this.writeStartTag(BLOCK_TAG, "");
        this.writeStartTag(LIST_BLOCK_TAG, "");
        this.writeStartTag(LIST_ITEM_TAG, "");
        this.writeln("<fo:list-item-label end-indent=\"6.375in\" start-indent=\"-1in\">");
        this.writeStartTag(BLOCK_TAG, "outdented.number.style");
        if (chapterNumber) {
            this.writeStartTag(BLOCK_TAG, "chapter.title");
            this.write(Integer.toString(this.chapter));
            this.writeEndTag(BLOCK_TAG);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_LABEL_TAG);
        this.writeln("<fo:list-item-body end-indent=\"1in\" start-indent=\"0in\">");
        this.writeStartTag(BLOCK_TAG, "chapter.title");
        if (headerText == null) {
            this.text(this.docTitle);
        } else {
            this.text(headerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeStartTag(BLOCK_TAG, "space-after.optimum", "0em");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
    }

    public void toc() {
        if (this.docModel == null || this.docModel.getToc() == null || this.docModel.getToc().getItems() == null || this.tocPosition == 0) {
            return;
        }
        DocumentTOC toc = this.docModel.getToc();
        this.writeln("<fo:page-sequence master-reference=\"toc\" initial-page-number=\"1\" format=\"i\">");
        this.regionBefore(toc.getName());
        this.regionAfter(this.getFooterText());
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.writeStartTag(BLOCK_TAG, "id", "./toc");
        this.chapterHeading(toc.getName(), false);
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.45in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.4in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.4in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "5in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeTocItems(toc.getItems(), 1);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
    }

    private void writeTocItems(List<DocumentTOCItem> tocItems, int level) {
        int maxTocLevel = 4;
        if (level < 1 || level > 4) {
            return;
        }
        this.tocStack.push(new NumberedListItem(0));
        for (DocumentTOCItem tocItem : tocItems) {
            String ref = this.getIdName(tocItem.getRef());
            this.writeStartTag(TABLE_ROW_TAG, "keep-with-next", "auto");
            if (level > 2) {
                for (int i = 0; i < level - 2; ++i) {
                    this.writeStartTag(TABLE_CELL_TAG);
                    this.writeSimpleTag(BLOCK_TAG);
                    this.writeEndTag(TABLE_CELL_TAG);
                }
            }
            this.writeStartTag(TABLE_CELL_TAG, "toc.cell");
            this.writeStartTag(BLOCK_TAG, "toc.number.style");
            NumberedListItem current = this.tocStack.peek();
            current.next();
            this.write(this.currentTocNumber());
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            String span = "3";
            if (level > 2) {
                span = Integer.toString(5 - level);
            }
            this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", span, "toc.cell");
            MutableAttributeSet atts = this.getFoConfiguration().getAttributeSet("toc.h" + level + ".style");
            atts.addAttribute("text-align-last", "justify");
            this.writeStartTag(BLOCK_TAG, atts);
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", ref);
            this.text(tocItem.getName());
            this.writeEndTag(BASIC_LINK_TAG);
            this.writeEmptyTag(LEADER_TAG, "toc.leader.style");
            this.writeStartTag(INLINE_TAG, "page.number");
            this.writeEmptyTag(PAGE_NUMBER_CITATION_TAG, "ref-id", ref);
            this.writeEndTag(INLINE_TAG);
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
            if (tocItem.getItems() == null) continue;
            this.writeTocItems(tocItem.getItems(), level + 1);
        }
        this.tocStack.pop();
    }

    private String currentTocNumber() {
        StringBuilder ch = new StringBuilder(((NumberedListItem)this.tocStack.get(0)).getListItemSymbol());
        for (int i = 1; i < this.tocStack.size(); ++i) {
            ch.append("." + ((NumberedListItem)this.tocStack.get(i)).getListItemSymbol());
        }
        return ch.toString();
    }

    @Override
    protected void pdfBookmarks() {
        if (this.docModel == null || this.docModel.getToc() == null) {
            return;
        }
        this.writeStartTag(BOOKMARK_TREE_TAG);
        this.renderBookmarkItems(this.docModel.getToc().getItems());
        this.writeEndTag(BOOKMARK_TREE_TAG);
    }

    private void renderBookmarkItems(List<DocumentTOCItem> items) {
        for (DocumentTOCItem tocItem : items) {
            String ref = this.getIdName(tocItem.getRef());
            this.writeStartTag(BOOKMARK_TAG, "internal-destination", ref);
            this.writeStartTag(BOOKMARK_TITLE_TAG);
            this.text(tocItem.getName());
            this.writeEndTag(BOOKMARK_TITLE_TAG);
            if (tocItem.getItems() != null) {
                this.renderBookmarkItems(tocItem.getItems());
            }
            this.writeEndTag(BOOKMARK_TAG);
        }
    }

    public void coverPage() {
        if (this.docModel == null) {
            return;
        }
        DocumentCover cover = this.docModel.getCover();
        DocumentMeta meta = this.docModel.getMeta();
        if (cover == null && meta == null) {
            return;
        }
        this.writeStartTag(PAGE_SEQUENCE_TAG, "master-reference", "cover-page");
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.writeStartTag(BLOCK_TAG, "text-align", "center");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "3.125in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "3.125in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeCoverHead(cover);
        this.writeCoverBody(cover, meta);
        this.writeCoverFooter(cover, meta);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
    }

    private void writeCoverHead(DocumentCover cover) {
        SinkEventAttributeSet atts;
        if (cover == null) {
            return;
        }
        String compLogo = cover.getCompanyLogo();
        String projLogo = cover.getProjectLogo();
        this.writeStartTag(TABLE_ROW_TAG, "height", COVER_HEADER_HEIGHT);
        this.writeStartTag(TABLE_CELL_TAG);
        if (StringUtils.isNotEmpty((String)compLogo)) {
            atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"text-align", (Object)"left");
            atts.addAttribute((Object)"vertical-align", (Object)"top");
            this.writeStartTag(BLOCK_TAG, (MutableAttributeSet)atts);
            this.figureGraphics(compLogo, (SinkEventAttributes)this.getGraphicsAttributes(compLogo));
            this.writeEndTag(BLOCK_TAG);
        }
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        if (StringUtils.isNotEmpty((String)projLogo)) {
            atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"text-align", (Object)"right");
            atts.addAttribute((Object)"vertical-align", (Object)"top");
            this.writeStartTag(BLOCK_TAG, (MutableAttributeSet)atts);
            this.figureGraphics(projLogo, (SinkEventAttributes)this.getGraphicsAttributes(projLogo));
            this.writeEndTag(BLOCK_TAG);
        }
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
    }

    private void writeCoverBody(DocumentCover cover, DocumentMeta meta) {
        if (cover == null && meta == null) {
            return;
        }
        String subtitle = null;
        String title = null;
        String type = null;
        String version = null;
        if (cover == null) {
            this.getLog().debug((CharSequence)"The DocumentCover is not defined, using the DocumentMeta title as cover title.");
            title = meta.getTitle();
        } else {
            subtitle = cover.getCoverSubTitle();
            title = cover.getCoverTitle();
            type = cover.getCoverType();
            version = cover.getCoverVersion();
        }
        this.writeln("<fo:table-row keep-with-previous=\"always\" height=\"0.014in\">");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeStartTag(BLOCK_TAG, "line-height", "0.014in");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "height", "7.447in");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.083in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.083in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.083in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "3");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEmptyTag(BLOCK_TAG, "space-before", "3.2235in");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeEmptyTag(BLOCK_TAG, "space-after", "0.5in");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2", "cover.border.left");
        this.writeStartTag(BLOCK_TAG, "cover.title");
        this.text(title == null ? "" : title);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2", "cover.border.left.bottom");
        this.writeStartTag(BLOCK_TAG, "cover.subtitle");
        this.text(subtitle == null ? (version == null ? "" : " v. " + version) : subtitle);
        this.writeEndTag(BLOCK_TAG);
        this.writeStartTag(BLOCK_TAG, "cover.subtitle");
        this.text(type == null ? "" : type);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "height", "0.014in");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeln("<fo:block space-after=\"0.2in\" line-height=\"0.014in\">");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEmptyTag(BLOCK_TAG, "space-before", "0.2in");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
    }

    private void writeCoverFooter(DocumentCover cover, DocumentMeta meta) {
        if (cover == null && meta == null) {
            return;
        }
        String date = null;
        String compName = null;
        if (cover == null) {
            this.getLog().debug((CharSequence)"The DocumentCover is not defined, using the DocumentMeta author as company name.");
            compName = meta.getAuthor();
        } else {
            compName = cover.getCompanyName();
            if (cover.getCoverdate() == null) {
                cover.setCoverDate(new Date());
                date = cover.getCoverdate();
                cover.setCoverDate(null);
            } else {
                date = cover.getCoverdate();
            }
        }
        this.writeStartTag(TABLE_ROW_TAG, "height", "0.3in");
        this.writeStartTag(TABLE_CELL_TAG);
        MutableAttributeSet att = this.getFoConfiguration().getAttributeSet("cover.subtitle");
        att.addAttribute("height", "0.3in");
        att.addAttribute("text-align", "left");
        this.writeStartTag(BLOCK_TAG, att);
        this.text(compName == null ? (cover.getAuthor() == null ? "" : cover.getAuthor()) : compName);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        att = this.getFoConfiguration().getAttributeSet("cover.subtitle");
        att.addAttribute("height", "0.3in");
        att.addAttribute("text-align", "right");
        this.writeStartTag(BLOCK_TAG, att);
        this.text(date == null ? "" : date);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("doxia-fo", locale, this.getClass().getClassLoader());
    }

    private SinkEventAttributeSet getGraphicsAttributes(String logo) {
        MutableAttributeSet atts = null;
        try {
            atts = DoxiaUtils.getImageAttributes((String)logo);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
        }
        if (atts == null) {
            return new SinkEventAttributeSet(new String[]{"height", COVER_HEADER_HEIGHT});
        }
        int maxWidth = 225;
        if (Integer.parseInt(atts.getAttribute("width").toString()) > 225) {
            atts.addAttribute("content-width", "3.125in");
        }
        return new SinkEventAttributeSet((AttributeSet)atts);
    }
}

