/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;

public class DocValuesTermsQuery
extends Query {
    private final String field;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    public DocValuesTermsQuery(String field, Collection<BytesRef> terms) {
        this.field = Objects.requireNonNull(field);
        Objects.requireNonNull(terms, "Collection of terms must not be null");
        BytesRef[] sortedTerms = terms.toArray(new BytesRef[terms.size()]);
        ArrayUtil.timSort((Comparable[])sortedTerms);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRef previous = null;
        for (BytesRef term : sortedTerms) {
            if (!term.equals(previous)) {
                builder.add(field, term);
            }
            previous = term;
        }
        this.termData = builder.finish();
        this.termDataHashCode = this.termData.hashCode();
    }

    public DocValuesTermsQuery(String field, BytesRef ... terms) {
        this(field, Arrays.asList(terms));
    }

    public DocValuesTermsQuery(String field, final String ... terms) {
        this(field, (Collection<BytesRef>)new AbstractList<BytesRef>(){

            @Override
            public BytesRef get(int index) {
                return new BytesRef((CharSequence)terms[index]);
            }

            @Override
            public int size() {
                return terms.length;
            }
        });
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DocValuesTermsQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DocValuesTermsQuery other) {
        return this.termDataHashCode == other.termDataHashCode && this.termData.equals((Object)other.termData);
    }

    public int hashCode() {
        return 31 * this.classHash() + this.termDataHashCode;
    }

    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(new Term(iterator.field(), term).toString());
            term = iterator.next();
        }
        return builder.toString();
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedSetDocValues values = DocValues.getSortedSet((LeafReader)context.reader(), (String)DocValuesTermsQuery.this.field);
                final LongBitSet bits = new LongBitSet(values.getValueCount());
                boolean matchesAtLeastOneTerm = false;
                PrefixCodedTerms.TermIterator iterator = DocValuesTermsQuery.this.termData.iterator();
                BytesRef term = iterator.next();
                while (term != null) {
                    long ord = values.lookupTerm(term);
                    if (ord >= 0L) {
                        matchesAtLeastOneTerm = true;
                        bits.set(ord);
                    }
                    term = iterator.next();
                }
                if (!matchesAtLeastOneTerm) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        long ord = values.nextOrd();
                        while (ord != -1L) {
                            if (bits.get(ord)) {
                                return true;
                            }
                            ord = values.nextOrd();
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 3.0f;
                    }
                });
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{DocValuesTermsQuery.this.field});
            }
        };
    }
}

