/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public final class DGapVInt8IntDecoder
extends IntDecoder {
    @Override
    public void decode(BytesRef buf, IntsRef values) {
        values.length = 0;
        values.offset = 0;
        if (values.ints.length < buf.length) {
            values.ints = new int[ArrayUtil.oversize((int)buf.length, (int)4)];
        }
        int upto = buf.offset + buf.length;
        int value = 0;
        int offset = buf.offset;
        int prev = 0;
        while (offset < upto) {
            byte b;
            if ((b = buf.bytes[offset++]) >= 0) {
                values.ints[values.length] = (value << 7 | b) + prev;
                value = 0;
                prev = values.ints[values.length];
                ++values.length;
                continue;
            }
            value = value << 7 | b & 0x7F;
        }
    }

    public String toString() {
        return "DGapVInt8";
    }
}

