/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import org.apache.lucene.facet.associations.CategoryAssociation;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;

public class CategoryIntAssociation
implements CategoryAssociation {
    public static final String ASSOCIATION_LIST_ID = "$assoc_int$";
    private int value;

    public CategoryIntAssociation() {
    }

    public CategoryIntAssociation(int value) {
        this.value = value;
    }

    @Override
    public void serialize(ByteArrayDataOutput output) {
        try {
            output.writeInt(this.value);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception writing to a byte[]", e);
        }
    }

    @Override
    public void deserialize(ByteArrayDataInput input) {
        this.value = input.readInt();
    }

    @Override
    public int maxBytesNeeded() {
        return 4;
    }

    @Override
    public String getCategoryListID() {
        return ASSOCIATION_LIST_ID;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.value + ")";
    }
}

