/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.facet.collections.IntIterator;
import org.apache.lucene.facet.collections.IntToObjectMap;
import org.apache.lucene.facet.partitions.IntermediateFacetResult;
import org.apache.lucene.facet.partitions.PartitionsFacetResultsHandler;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.ParallelTaxonomyArrays;
import org.apache.lucene.util.PriorityQueue;

public class TopKInEachNodeHandler
extends PartitionsFacetResultsHandler {
    public TopKInEachNodeHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest, FacetArrays facetArrays) {
        super(taxonomyReader, facetRequest, facetArrays);
    }

    @Override
    public IntermediateFacetResult fetchPartitionResult(int offset) throws IOException {
        int rootNode = this.taxonomyReader.getOrdinal(this.facetRequest.categoryPath);
        if (rootNode == -1) {
            return null;
        }
        int K = Math.min(this.facetRequest.numResults, this.taxonomyReader.getSize());
        IntToObjectMap<AACO> AACOsOfOnePartition = new IntToObjectMap<AACO>();
        int partitionSize = this.facetArrays.arrayLength;
        int depth = this.facetRequest.getDepth();
        if (depth == 0) {
            IntermediateFacetResultWithHash tempFRWH = new IntermediateFacetResultWithHash(this.facetRequest, AACOsOfOnePartition);
            if (this.isSelfPartition(rootNode, this.facetArrays, offset)) {
                tempFRWH.isRootNodeIncluded = true;
                tempFRWH.rootNodeValue = this.facetRequest.getValueOf(this.facetArrays, rootNode % partitionSize);
            }
            return tempFRWH;
        }
        if (depth > 32764) {
            depth = 32764;
        }
        int endOffset = offset + partitionSize;
        ParallelTaxonomyArrays childrenArray = this.taxonomyReader.getParallelTaxonomyArrays();
        int[] children = childrenArray.children();
        int[] siblings = childrenArray.siblings();
        int totalNumOfDescendantsConsidered = 0;
        AggregatedCategoryHeap pq = new AggregatedCategoryHeap(K, this.getSuitableACComparator());
        AggregatedCategory[] reusables = new AggregatedCategory[2 + K];
        for (int i = 0; i < reusables.length; ++i) {
            reusables[i] = new AggregatedCategory(1, 0.0);
        }
        int[] ordinalStack = new int[depth + 2];
        ordinalStack[0] = rootNode;
        int localDepth = 0;
        int[][] bestSignlingsStack = new int[depth + 2][];
        int[] siblingExplored = new int[depth + 2];
        int[] firstToTheLeftOfPartition = new int[depth + 2];
        ordinalStack[++localDepth] = children[rootNode];
        siblingExplored[localDepth] = Integer.MAX_VALUE;
        siblingExplored[0] = -1;
        while (localDepth > 0) {
            int tosOrdinal = ordinalStack[localDepth];
            if (tosOrdinal == -1) {
                if (siblingExplored[--localDepth] < 0) {
                    ordinalStack[localDepth] = siblings[ordinalStack[localDepth]];
                    continue;
                }
                int n = localDepth;
                siblingExplored[n] = siblingExplored[n] - 1;
                if (siblingExplored[localDepth] == -1) {
                    ordinalStack[localDepth] = firstToTheLeftOfPartition[localDepth];
                    continue;
                }
                ordinalStack[localDepth] = bestSignlingsStack[localDepth][siblingExplored[localDepth]];
                continue;
            }
            if (siblingExplored[localDepth] == Integer.MAX_VALUE) {
                while (tosOrdinal >= endOffset) {
                    tosOrdinal = siblings[tosOrdinal];
                }
                pq.clear();
                int tosReuslables = reusables.length - 1;
                while (tosOrdinal >= offset) {
                    double value = this.facetRequest.getValueOf(this.facetArrays, tosOrdinal % partitionSize);
                    if (value != 0.0) {
                        ++totalNumOfDescendantsConsidered;
                        AggregatedCategory ac = reusables[tosReuslables--];
                        ac.ordinal = tosOrdinal;
                        ac.value = value;
                        if (null != (ac = (AggregatedCategory)pq.insertWithOverflow(ac))) {
                            --totalNumOfDescendantsConsidered;
                            totalNumOfDescendantsConsidered += this.countOnly(ac.ordinal, children, siblings, partitionSize, offset, endOffset, localDepth, depth);
                            reusables[++tosReuslables] = ac;
                        }
                    }
                    tosOrdinal = siblings[tosOrdinal];
                }
                firstToTheLeftOfPartition[localDepth] = tosOrdinal;
                int aaci = pq.size();
                int[] ords = new int[aaci];
                double[] vals = new double[aaci];
                while (aaci > 0) {
                    AggregatedCategory ac = (AggregatedCategory)pq.pop();
                    ords[--aaci] = ac.ordinal;
                    vals[aaci] = ac.value;
                    reusables[++tosReuslables] = ac;
                }
                if (ords.length > 0) {
                    AACOsOfOnePartition.put(ordinalStack[localDepth - 1], new AACO(ords, vals));
                    bestSignlingsStack[localDepth] = ords;
                    siblingExplored[localDepth] = ords.length - 1;
                    ordinalStack[localDepth] = ords[ords.length - 1];
                    continue;
                }
                ordinalStack[localDepth] = tosOrdinal;
                siblingExplored[localDepth] = -1;
                continue;
            }
            if (localDepth >= depth) {
                ordinalStack[++localDepth] = -1;
                continue;
            }
            ordinalStack[++localDepth] = children[tosOrdinal];
            siblingExplored[localDepth] = Integer.MAX_VALUE;
        }
        IntermediateFacetResultWithHash tempFRWH = new IntermediateFacetResultWithHash(this.facetRequest, AACOsOfOnePartition);
        if (this.isSelfPartition(rootNode, this.facetArrays, offset)) {
            tempFRWH.isRootNodeIncluded = true;
            tempFRWH.rootNodeValue = this.facetRequest.getValueOf(this.facetArrays, rootNode % partitionSize);
        }
        tempFRWH.totalNumOfFacetsConsidered = totalNumOfDescendantsConsidered;
        return tempFRWH;
    }

    private int countOnly(int ordinal, int[] youngestChild, int[] olderSibling, int partitionSize, int offset, int endOffset, int currentDepth, int maxDepth) {
        int ret = 0;
        if (offset <= ordinal && 0.0 != this.facetRequest.getValueOf(this.facetArrays, ordinal % partitionSize)) {
            ++ret;
        }
        if (currentDepth >= maxDepth) {
            return ret;
        }
        int yc = youngestChild[ordinal];
        while (yc >= endOffset) {
            yc = olderSibling[yc];
        }
        while (yc > -1) {
            ret += this.countOnly(yc, youngestChild, olderSibling, partitionSize, offset, endOffset, currentDepth + 1, maxDepth);
            yc = olderSibling[yc];
        }
        return ret;
    }

    @Override
    public IntermediateFacetResult mergeResults(IntermediateFacetResult ... tmpResults) {
        int i;
        if (tmpResults.length == 0) {
            return null;
        }
        for (i = 0; i < tmpResults.length && tmpResults[i] == null; ++i) {
        }
        if (i == tmpResults.length) {
            return null;
        }
        int K = this.facetRequest.numResults;
        IntermediateFacetResultWithHash tmpToReturn = (IntermediateFacetResultWithHash)tmpResults[i++];
        while (i < tmpResults.length) {
            IntermediateFacetResultWithHash tfr = (IntermediateFacetResultWithHash)tmpResults[i];
            tmpToReturn.totalNumOfFacetsConsidered += tfr.totalNumOfFacetsConsidered;
            if (tfr.isRootNodeIncluded) {
                tmpToReturn.isRootNodeIncluded = true;
                tmpToReturn.rootNodeValue = tfr.rootNodeValue;
            }
            IntToObjectMap<AACO> tmpToReturnMapToACCOs = tmpToReturn.mapToAACOs;
            IntToObjectMap<AACO> tfrMapToACCOs = tfr.mapToAACOs;
            IntIterator tfrIntIterator = tfrMapToACCOs.keyIterator();
            while (tfrIntIterator.hasNext()) {
                int tfrkey = tfrIntIterator.next();
                AACO tmpToReturnAACO = null;
                tmpToReturnAACO = tmpToReturnMapToACCOs.get(tfrkey);
                if (null == tmpToReturnAACO) {
                    tmpToReturnMapToACCOs.put(tfrkey, tfrMapToACCOs.get(tfrkey));
                    continue;
                }
                AACO tfrAACO = tfrMapToACCOs.get(tfrkey);
                int resLength = tfrAACO.ordinals.length + tmpToReturnAACO.ordinals.length;
                if (K < resLength) {
                    resLength = K;
                }
                int[] resOrds = new int[resLength];
                double[] resVals = new double[resLength];
                int indexIntoTmpToReturn = 0;
                int indexIntoTFR = 0;
                ACComparator merger = this.getSuitableACComparator();
                for (int indexIntoRes = 0; indexIntoRes < resLength; ++indexIntoRes) {
                    if (indexIntoTmpToReturn >= tmpToReturnAACO.ordinals.length) {
                        resOrds[indexIntoRes] = tfrAACO.ordinals[indexIntoTFR];
                        resVals[indexIntoRes] = tfrAACO.values[indexIntoTFR];
                        ++indexIntoTFR;
                        continue;
                    }
                    if (indexIntoTFR >= tfrAACO.ordinals.length) {
                        resOrds[indexIntoRes] = tmpToReturnAACO.ordinals[indexIntoTmpToReturn];
                        resVals[indexIntoRes] = tmpToReturnAACO.values[indexIntoTmpToReturn];
                        ++indexIntoTmpToReturn;
                        continue;
                    }
                    if (merger.leftGoesNow(tmpToReturnAACO.ordinals[indexIntoTmpToReturn], tmpToReturnAACO.values[indexIntoTmpToReturn], tfrAACO.ordinals[indexIntoTFR], tfrAACO.values[indexIntoTFR])) {
                        resOrds[indexIntoRes] = tmpToReturnAACO.ordinals[indexIntoTmpToReturn];
                        resVals[indexIntoRes] = tmpToReturnAACO.values[indexIntoTmpToReturn];
                        ++indexIntoTmpToReturn;
                        continue;
                    }
                    resOrds[indexIntoRes] = tfrAACO.ordinals[indexIntoTFR];
                    resVals[indexIntoRes] = tfrAACO.values[indexIntoTFR];
                    ++indexIntoTFR;
                }
                tmpToReturnMapToACCOs.put(tfrkey, new AACO(resOrds, resVals));
            }
            ++i;
        }
        return tmpToReturn;
    }

    private ACComparator getSuitableACComparator() {
        if (this.facetRequest.getSortOrder() == FacetRequest.SortOrder.ASCENDING) {
            return new AscValueACComparator();
        }
        return new DescValueACComparator();
    }

    @Override
    public void labelResult(FacetResult facetResult) throws IOException {
        if (facetResult == null) {
            return;
        }
        FacetResultNode rootNode = facetResult.getFacetResultNode();
        this.recursivelyLabel(rootNode, this.facetRequest.getNumLabel());
    }

    private void recursivelyLabel(FacetResultNode node, int numToLabel) throws IOException {
        if (node == null) {
            return;
        }
        node.label = this.taxonomyReader.getPath(node.ordinal);
        int numLabeled = 0;
        for (FacetResultNode frn : node.subResults) {
            this.recursivelyLabel(frn, numToLabel);
            if (++numLabeled < numToLabel) continue;
            return;
        }
    }

    @Override
    public FacetResult rearrangeFacetResult(FacetResult facetResult) {
        ResultNodeHeap nodesHeap = new ResultNodeHeap(this.facetRequest.numResults, this.getSuitableACComparator());
        FacetResultNode topFrn = facetResult.getFacetResultNode();
        this.rearrangeChilrenOfNode(topFrn, nodesHeap);
        return facetResult;
    }

    private void rearrangeChilrenOfNode(FacetResultNode node, PriorityQueue<FacetResultNode> nodesHeap) {
        nodesHeap.clear();
        for (FacetResultNode frn : node.subResults) {
            nodesHeap.add((Object)frn);
        }
        int size = nodesHeap.size();
        ArrayList<FacetResultNode> subResults = new ArrayList<FacetResultNode>(size);
        while (nodesHeap.size() > 0) {
            subResults.add(0, (FacetResultNode)nodesHeap.pop());
        }
        node.subResults = subResults;
        for (FacetResultNode frn : node.subResults) {
            this.rearrangeChilrenOfNode(frn, nodesHeap);
        }
    }

    @Override
    public FacetResult renderFacetResult(IntermediateFacetResult tmpResult) throws IOException {
        IntermediateFacetResultWithHash tmp = (IntermediateFacetResultWithHash)tmpResult;
        int ordinal = this.taxonomyReader.getOrdinal(this.facetRequest.categoryPath);
        if (tmp == null || ordinal == -1) {
            return null;
        }
        double value = Double.NaN;
        if (tmp.isRootNodeIncluded) {
            value = tmp.rootNodeValue;
        }
        FacetResultNode root = this.generateNode(ordinal, value, tmp.mapToAACOs);
        return new FacetResult(tmp.facetRequest, root, tmp.totalNumOfFacetsConsidered);
    }

    private FacetResultNode generateNode(int ordinal, double val, IntToObjectMap<AACO> mapToAACOs) {
        FacetResultNode node = new FacetResultNode(ordinal, val);
        AACO aaco = mapToAACOs.get(ordinal);
        if (null == aaco) {
            return node;
        }
        ArrayList<FacetResultNode> list = new ArrayList<FacetResultNode>();
        for (int i = 0; i < aaco.ordinals.length; ++i) {
            list.add(this.generateNode(aaco.ordinals[i], aaco.values[i], mapToAACOs));
        }
        node.subResults = list;
        return node;
    }

    protected static final class AACO {
        int[] ordinals;
        double[] values;

        AACO(int[] ords, double[] vals) {
            this.ordinals = ords;
            this.values = vals;
        }
    }

    private static final class AggregatedCategory {
        int ordinal;
        double value;

        AggregatedCategory(int ord, double val) {
            this.ordinal = ord;
            this.value = val;
        }
    }

    public static class IntermediateFacetResultWithHash
    implements IntermediateFacetResult {
        protected IntToObjectMap<AACO> mapToAACOs;
        FacetRequest facetRequest;
        boolean isRootNodeIncluded;
        double rootNodeValue;
        int totalNumOfFacetsConsidered;

        public IntermediateFacetResultWithHash(FacetRequest facetReq, IntToObjectMap<AACO> mapToAACOs) {
            this.mapToAACOs = mapToAACOs;
            this.facetRequest = facetReq;
            this.isRootNodeIncluded = false;
            this.rootNodeValue = 0.0;
            this.totalNumOfFacetsConsidered = 0;
        }

        @Override
        public FacetRequest getFacetRequest() {
            return this.facetRequest;
        }
    }

    private static final class DescValueACComparator
    extends ACComparator {
        DescValueACComparator() {
        }

        @Override
        protected boolean leftGoesNow(int ord1, double val1, int ord2, double val2) {
            return val1 == val2 ? ord1 > ord2 : val1 > val2;
        }
    }

    private static final class AscValueACComparator
    extends ACComparator {
        AscValueACComparator() {
        }

        @Override
        protected boolean leftGoesNow(int ord1, double val1, int ord2, double val2) {
            return val1 == val2 ? ord1 < ord2 : val1 < val2;
        }
    }

    private static abstract class ACComparator {
        ACComparator() {
        }

        protected abstract boolean leftGoesNow(int var1, double var2, int var4, double var5);
    }

    private static class ResultNodeHeap
    extends PriorityQueue<FacetResultNode> {
        private ACComparator merger;

        public ResultNodeHeap(int size, ACComparator merger) {
            super(size);
            this.merger = merger;
        }

        protected boolean lessThan(FacetResultNode arg1, FacetResultNode arg2) {
            return this.merger.leftGoesNow(arg2.ordinal, arg2.value, arg1.ordinal, arg1.value);
        }
    }

    private static class AggregatedCategoryHeap
    extends PriorityQueue<AggregatedCategory> {
        private ACComparator merger;

        public AggregatedCategoryHeap(int size, ACComparator merger) {
            super(size);
            this.merger = merger;
        }

        protected boolean lessThan(AggregatedCategory arg1, AggregatedCategory arg2) {
            return this.merger.leftGoesNow(arg2.ordinal, arg2.value, arg1.ordinal, arg1.value);
        }
    }
}

