/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

class SimpleTextDocValuesReader
extends DocValuesProducer {
    final int maxDoc;
    final IndexInput data;
    final BytesRef scratch;
    final Map<String, OneField> fields;

    public SimpleTextDocValuesReader(SegmentReadState state, String ext) throws IOException {
        block16: {
            this.scratch = new BytesRef();
            this.fields = new HashMap<String, OneField>();
            this.data = state.directory.openInput(IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)ext), state.context);
            this.maxDoc = state.segmentInfo.getDocCount();
            while (true) {
                this.readLine();
                if (this.scratch.equals((Object)SimpleTextDocValuesWriter.END)) break block16;
                assert (this.startsWith(SimpleTextDocValuesWriter.FIELD)) : this.scratch.utf8ToString();
                String fieldName = this.stripPrefix(SimpleTextDocValuesWriter.FIELD);
                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldName);
                assert (fieldInfo != null);
                OneField field = new OneField();
                this.fields.put(fieldName, field);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.TYPE)) : this.scratch.utf8ToString();
                FieldInfo.DocValuesType dvType = FieldInfo.DocValuesType.valueOf((String)this.stripPrefix(SimpleTextDocValuesWriter.TYPE));
                assert (dvType != null);
                if (dvType == FieldInfo.DocValuesType.NUMERIC) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MINVALUE)) : "got " + this.scratch.utf8ToString() + " field=" + fieldName + " ext=" + ext;
                    field.minValue = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.MINVALUE));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((1 + field.pattern.length()) * this.maxDoc));
                    continue;
                }
                if (dvType == FieldInfo.DocValuesType.BINARY) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                    field.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((9 + field.pattern.length() + field.maxLength) * this.maxDoc));
                    continue;
                }
                if (dvType != FieldInfo.DocValuesType.SORTED && dvType != FieldInfo.DocValuesType.SORTED_SET) break;
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.NUMVALUES));
                field.numValues = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.NUMVALUES));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                field.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.ORDPATTERN));
                field.ordPattern = this.stripPrefix(SimpleTextDocValuesWriter.ORDPATTERN);
                field.dataStartFilePointer = this.data.getFilePointer();
                this.data.seek(this.data.getFilePointer() + (long)(9 + field.pattern.length() + field.maxLength) * field.numValues + (long)((1 + field.ordPattern.length()) * this.maxDoc));
            }
            throw new AssertionError();
        }
        assert (!this.fields.isEmpty());
    }

    public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        assert (field != null) : "field=" + fieldInfo.name + " fields=" + this.fields;
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        decoder.setParseBigDecimal(true);
        return new NumericDocValues(){

            public long get(int docID) {
                try {
                    BigDecimal bd;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field.dataStartFilePointer + (long)((1 + field.pattern.length()) * docID));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    try {
                        bd = (BigDecimal)decoder.parse(scratch.utf8ToString());
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse BigDecimal value (resource=" + in + ")");
                        e.initCause((Throwable)pe);
                        throw e;
                    }
                    return BigInteger.valueOf(field.minValue).add(bd.toBigIntegerExact()).longValue();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new BinaryDocValues(){

            public void get(int docID, BytesRef result) {
                try {
                    int len;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field.dataStartFilePointer + (long)((9 + field.pattern.length() + field.maxLength) * docID));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause((Throwable)pe);
                        throw e;
                    }
                    result.bytes = new byte[len];
                    result.offset = 0;
                    result.length = len;
                    in.readBytes(result.bytes, 0, len);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        final DecimalFormat ordDecoder = new DecimalFormat(field.ordPattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedDocValues(){

            public int getOrd(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)(docID * (1 + field.ordPattern.length())));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    try {
                        return ordDecoder.parse(scratch.utf8ToString()).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse ord (resource=" + in + ")");
                        e.initCause((Throwable)pe);
                        throw e;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            public void lookupOrd(int ord, BytesRef result) {
                try {
                    int len;
                    if (ord < 0 || (long)ord >= field.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field.numValues - 1L) + "; got " + ord);
                    }
                    in.seek(field.dataStartFilePointer + (long)(ord * (9 + field.pattern.length() + field.maxLength)));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.utf8ToString() + " in=" + in;
                    try {
                        len = decoder.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause((Throwable)pe);
                        throw e;
                    }
                    result.bytes = new byte[len];
                    result.offset = 0;
                    result.length = len;
                    in.readBytes(result.bytes, 0, len);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            public int getValueCount() {
                return (int)field.numValues;
            }
        };
    }

    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedSetDocValues(){
            String[] currentOrds = new String[0];
            int currentIndex = 0;

            public long nextOrd() {
                if (this.currentIndex == this.currentOrds.length) {
                    return -1L;
                }
                return Long.parseLong(this.currentOrds[this.currentIndex++]);
            }

            public void setDocument(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)(docID * (1 + field.ordPattern.length())));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    String ordList = scratch.utf8ToString().trim();
                    this.currentOrds = ordList.isEmpty() ? new String[0] : ordList.split(",");
                    this.currentIndex = 0;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            public void lookupOrd(long ord, BytesRef result) {
                try {
                    int len;
                    if (ord < 0L || ord >= field.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field.numValues - 1L) + "; got " + ord);
                    }
                    in.seek(field.dataStartFilePointer + ord * (long)(9 + field.pattern.length() + field.maxLength));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.utf8ToString() + " in=" + in;
                    try {
                        len = decoder.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause((Throwable)pe);
                        throw e;
                    }
                    result.bytes = new byte[len];
                    result.offset = 0;
                    result.length = len;
                    in.readBytes(result.bytes, 0, len);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            public long getValueCount() {
                return field.numValues;
            }
        };
    }

    public void close() throws IOException {
        this.data.close();
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine((DataInput)this.data, this.scratch);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)prefix);
    }

    private String stripPrefix(BytesRef prefix) throws IOException {
        return new String(this.scratch.bytes, this.scratch.offset + prefix.length, this.scratch.length - prefix.length, "UTF-8");
    }

    static class OneField {
        long dataStartFilePointer;
        String pattern;
        String ordPattern;
        int maxLength;
        boolean fixedLength;
        long minValue;
        long numValues;

        OneField() {
        }
    }
}

