/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.coordinator.group.CoordinatorLoaderImpl;
import kafka.coordinator.group.StringKeyValueDeserializer;
import kafka.log.UnifiedLog;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005-4AAC\u0006\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)q\u0007\u0001C\u0001=!)\u0011\b\u0001C\u0001=!)1\b\u0001C\u0005y\tI2i\\8sI&t\u0017\r^8s\u0019>\fG-\u001a:J[BdG+Z:u\u0015\taQ\"A\u0003he>,\bO\u0003\u0002\u000f\u001f\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\f\u0003a!Xm\u001d;O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c\u000b\u0002?A\u0011A\u0003I\u0005\u0003CU\u0011A!\u00168ji\"\u0012!a\t\t\u0003I5j\u0011!\n\u0006\u0003M\u001d\n1!\u00199j\u0015\tA\u0013&A\u0004kkBLG/\u001a:\u000b\u0005)Z\u0013!\u00026v]&$(\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/K\t!A+Z:u\u0003}!Xm\u001d;M_\u0006$\u0017N\\4JgJ+'.Z2uK\u0012<\u0006.\u001a8DY>\u001cX\r\u001a\u0015\u0003\u0007\r\n1\u0002^3ti2{\u0017\rZ5oO\"\u0012AaI\u0001\u001di\u0016\u001cH\u000fT8bI&twm\u0015;paB,Gm\u00165f]\u000ecwn]3eQ\t)1%A\u0010uKN$XK\\6o_^t'+Z2pe\u0012$\u0016\u0010]3Be\u0016LuM\\8sK\u0012D#AB\u0012\u0002OQ,7\u000f\u001e#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8FeJ|'OR1jYN$\u0006.\u001a'pC\u0012Lgn\u001a\u0015\u0003\u000f\r\nq\u0005^3ti2{\u0017\rZ$s_V\u0004\u0018I\u001c3PM\u001a\u001cX\r^:XSRD7i\u001c:skB$X\r\u001a'pO\"\u0012\u0001bI\u0001\u000eY><'+Z1e%\u0016\u001cX\u000f\u001c;\u0015\u0007uRu\n\u0005\u0002?\u00116\tqH\u0003\u0002A\u0003\u0006\u0019An\\4\u000b\u0005\t\u001b\u0015!C5oi\u0016\u0014h.\u00197t\u0015\t!U)A\u0004ti>\u0014\u0018mZ3\u000b\u0005A1%BA$,\u0003\u0019\t\u0007/Y2iK&\u0011\u0011j\u0010\u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\u000b-K\u0001\u0019\u0001'\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0003)5K!AT\u000b\u0003\t1{gn\u001a\u0005\u0006!&\u0001\r!U\u0001\be\u0016\u001cwN\u001d3t!\r\u0011&,\u0018\b\u0003'bs!\u0001V,\u000e\u0003US!AV\t\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012BA-\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\u0007M+\u0017O\u0003\u0002Z+A\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005\t,\u0015AB2p[6|g.\u0003\u0002e?\na1+[7qY\u0016\u0014VmY8sI\"\"\u0001AZ5k!\t!s-\u0003\u0002iK\t9A+[7f_V$\u0018!\u0002<bYV,g$\u0001\u001f")
public class CoordinatorLoaderImplTest {
    @Test
    public void testNonexistentPartition() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorLoader.Deserializer serde = (CoordinatorLoader.Deserializer)Mockito.mock(CoordinatorLoader.Deserializer.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testNonexistentPartition$1(replicaManager, tp, coordinator, resource_resource);
        }
    }

    @Test
    public void testLoadingIsRejectedWhenClosed() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorLoader.Deserializer serde = (CoordinatorLoader.Deserializer)Mockito.mock(CoordinatorLoader.Deserializer.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testLoadingIsRejectedWhenClosed$1(tp, coordinator, resource_resource);
        }
    }

    @Test
    public void testLoading() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, (CoordinatorLoader.Deserializer)serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testLoading$1(this, replicaManager, tp, log, coordinator, resource_resource);
        }
    }

    @Test
    public void testLoadingStoppedWhenClosed() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, (CoordinatorLoader.Deserializer)serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testLoadingStoppedWhenClosed$1(this, replicaManager, tp, log, coordinator, resource_resource);
        }
    }

    @Test
    public void testUnknownRecordTypeAreIgnored() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, (CoordinatorLoader.Deserializer)serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testUnknownRecordTypeAreIgnored$1(this, replicaManager, tp, log, serde, coordinator, resource_resource);
        }
    }

    @Test
    public void testDeserializationErrorFailsTheLoading() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, (CoordinatorLoader.Deserializer)serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testDeserializationErrorFailsTheLoading$1(this, replicaManager, tp, log, serde, coordinator, resource_resource);
        }
    }

    @Test
    public void testLoadGroupAndOffsetsWithCorruptedLog() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        try (CoordinatorLoaderImpl resource_resource = new CoordinatorLoaderImpl(replicaManager, (CoordinatorLoader.Deserializer)serde, 1000);){
            CoordinatorLoaderImplTest.$anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1(this, replicaManager, tp, log, coordinator, resource_resource);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FetchDataInfo logReadResult(long startOffset, Seq<SimpleRecord> records) {
        void withRecords_records;
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var9_6 = null;
        Object var7_5 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecords.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)memoryRecords.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecords.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(memoryRecords.buffer().duplicate());
            return buffer.flip();
        });
        return new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecords);
    }

    public static final /* synthetic */ NotLeaderOrFollowerException $anonfun$testNonexistentPartition$1(ReplicaManager replicaManager$1, TopicPartition tp$1, CoordinatorPlayback coordinator$1, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$1.getLog(tp$1)).thenReturn((Object)None$.MODULE$);
        return (NotLeaderOrFollowerException)TestUtils.assertFutureThrows((Future)loader.load(tp$1, coordinator$1), NotLeaderOrFollowerException.class);
    }

    public static final /* synthetic */ RuntimeException $anonfun$testLoadingIsRejectedWhenClosed$1(TopicPartition tp$2, CoordinatorPlayback coordinator$2, CoordinatorLoaderImpl loader) {
        loader.close();
        return (RuntimeException)TestUtils.assertFutureThrows((Future)loader.load(tp$2, coordinator$2), RuntimeException.class);
    }

    public static final /* synthetic */ void $anonfun$testLoading$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$2, TopicPartition tp$3, UnifiedLog log$1, CoordinatorPlayback coordinator$3, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$2.getLog(tp$3)).thenReturn((Object)new Some((Object)log$1));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$1.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$2.getLogEndOffset(tp$3)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)5L)));
        FetchDataInfo readResult1 = $this.logReadResult(0L, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)));
        Mockito.when((Object)log$1.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        FetchDataInfo readResult2 = $this.logReadResult(2L, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$))));
        Mockito.when((Object)log$1.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        Assertions.assertNull(loader.load(tp$3, coordinator$3).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay((Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay((Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay((Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay((Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay((Object)new Tuple2((Object)"k5", (Object)"v5"));
    }

    public static final /* synthetic */ void $anonfun$testLoadingStoppedWhenClosed$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$3, TopicPartition tp$4, UnifiedLog log$2, CoordinatorPlayback coordinator$4, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$3.getLog(tp$4)).thenReturn((Object)new Some((Object)log$2));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$2.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$3.getLogEndOffset(tp$4)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)100L)));
        FetchDataInfo readResult = $this.logReadResult(0L, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)));
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)log$2.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)1000), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenAnswer(x$1 -> {
            latch.countDown();
            return readResult;
        });
        CompletableFuture result = loader.load(tp$4, coordinator$4);
        latch.await(10L, TimeUnit.SECONDS);
        loader.close();
        RuntimeException ex = (RuntimeException)TestUtils.assertFutureThrows((Future)result, RuntimeException.class);
        Assertions.assertEquals((Object)"Coordinator loader is closed.", (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testUnknownRecordTypeAreIgnored$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$4, TopicPartition tp$5, UnifiedLog log$3, StringKeyValueDeserializer serde$1, CoordinatorPlayback coordinator$5, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$4.getLog(tp$5)).thenReturn((Object)new Some((Object)log$3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$3.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$4.getLogEndOffset(tp$5)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        FetchDataInfo readResult = $this.logReadResult(0L, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)));
        Mockito.when((Object)log$3.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Mockito.when(serde$1.deserialize((ByteBuffer)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new CoordinatorLoader.UnknownRecordTypeException(1)}).thenReturn((Object)new Tuple2((Object)"k2", (Object)"v2"));
        loader.load(tp$5, coordinator$5).get(10L, TimeUnit.SECONDS);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$5)).replay((Object)new Tuple2((Object)"k2", (Object)"v2"));
    }

    public static final /* synthetic */ void $anonfun$testDeserializationErrorFailsTheLoading$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$5, TopicPartition tp$6, UnifiedLog log$4, StringKeyValueDeserializer serde$2, CoordinatorPlayback coordinator$6, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$5.getLog(tp$6)).thenReturn((Object)new Some((Object)log$4));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$4.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$5.getLogEndOffset(tp$6)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        FetchDataInfo readResult = $this.logReadResult(0L, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)));
        Mockito.when((Object)log$4.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Mockito.when(serde$2.deserialize((ByteBuffer)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Error!")});
        RuntimeException ex = (RuntimeException)TestUtils.assertFutureThrows((Future)loader.load(tp$6, coordinator$6), RuntimeException.class);
        Assertions.assertEquals((Object)"Error!", (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$6, TopicPartition tp$7, UnifiedLog log$5, CoordinatorPlayback coordinator$7, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$6.getLog(tp$7)).thenReturn((Object)new Some((Object)log$5));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$5.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$6.getLogEndOffset(tp$7)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)10L)));
        FetchDataInfo readResult = $this.logReadResult(0L, (Seq<SimpleRecord>)Nil$.MODULE$);
        Mockito.when((Object)log$5.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Assertions.assertNull(loader.load(tp$7, coordinator$7).get(10L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ Object $anonfun$testLoading$1$adapted(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$2, TopicPartition tp$3, UnifiedLog log$1, CoordinatorPlayback coordinator$3, CoordinatorLoaderImpl loader) {
        CoordinatorLoaderImplTest.$anonfun$testLoading$1($this, replicaManager$2, tp$3, log$1, coordinator$3, loader);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadingStoppedWhenClosed$1$adapted(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$3, TopicPartition tp$4, UnifiedLog log$2, CoordinatorPlayback coordinator$4, CoordinatorLoaderImpl loader) {
        CoordinatorLoaderImplTest.$anonfun$testLoadingStoppedWhenClosed$1($this, replicaManager$3, tp$4, log$2, coordinator$4, loader);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testUnknownRecordTypeAreIgnored$1$adapted(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$4, TopicPartition tp$5, UnifiedLog log$3, StringKeyValueDeserializer serde$1, CoordinatorPlayback coordinator$5, CoordinatorLoaderImpl loader) {
        CoordinatorLoaderImplTest.$anonfun$testUnknownRecordTypeAreIgnored$1($this, replicaManager$4, tp$5, log$3, serde$1, coordinator$5, loader);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeserializationErrorFailsTheLoading$1$adapted(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$5, TopicPartition tp$6, UnifiedLog log$4, StringKeyValueDeserializer serde$2, CoordinatorPlayback coordinator$6, CoordinatorLoaderImpl loader) {
        CoordinatorLoaderImplTest.$anonfun$testDeserializationErrorFailsTheLoading$1($this, replicaManager$5, tp$6, log$4, serde$2, coordinator$6, loader);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1$adapted(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$6, TopicPartition tp$7, UnifiedLog log$5, CoordinatorPlayback coordinator$7, CoordinatorLoaderImpl loader) {
        CoordinatorLoaderImplTest.$anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1($this, replicaManager$6, tp$7, log$5, coordinator$7, loader);
        return BoxedUnit.UNIT;
    }
}

