/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.coordinator.transaction.ProducerIdManagerTest$MockProducerIdManager$;
import kafka.coordinator.transaction.RPCProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\tUc\u0001\u0002\u00192\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001A\u0002\u0013\u0005A\tC\u0004L\u0001\u0001\u0007I\u0011\u0001'\t\rI\u0003\u0001\u0015)\u0003F\u0011\u001d\u0019\u0006A1A\u0005\u0002QCaa\u0017\u0001!\u0002\u0013)f\u0001\u0002/\u0001\u0001uC\u0001\"Y\u0004\u0003\u0006\u0004%\tA\u0019\u0005\tM\u001e\u0011\t\u0011)A\u0005G\"Aqm\u0002BA\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u000f\t\u0005\r\u0011\"\u0001n\u0011!ywA!A!B\u0013I\u0007\u0002\u00039\b\u0005\u000b\u0007I\u0011\u00012\t\u0011E<!\u0011!Q\u0001\n\rD\u0001B]\u0004\u0003\u0002\u0004%\ta\u001d\u0005\u000b\u0003\u00079!\u00111A\u0005\u0002\u0005\u0015\u0001\"CA\u0005\u000f\t\u0005\t\u0015)\u0003u\u0011)\tYa\u0002BC\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003+9!\u0011!Q\u0001\n\u0005=\u0001BCA\f\u000f\t\u0015\r\u0011\"\u0001\u0002\u001a!Q\u0011qE\u0004\u0003\u0002\u0003\u0006I!a\u0007\t\u0013\u0005%rA!a\u0001\n\u0003\u0011\u0007BCA\u0016\u000f\t\u0005\r\u0011\"\u0001\u0002.!I\u0011\u0011G\u0004\u0003\u0002\u0003\u0006Ka\u0019\u0005\u0007\u007f\u001d!\t!a\r\t\u0013\u0005\u001dsA1A\u0005\n\u0005%\u0003\u0002CA0\u000f\u0001\u0006I!a\u0013\t\u0013\u0005\u0005tA1A\u0005\u0002\u0005\r\u0004\u0002CA9\u000f\u0001\u0006I!!\u001a\t\u0011\u0005Mt\u0001\"\u00112\u0003kB\u0001\"a\u001e\b\t\u0003\n\u0014\u0011\u0010\u0005\t\u0003\u0017;A\u0011I\u0019\u0002v\u001dI\u0011Q\u0012\u0001\u0002\u0002#\u0005\u0011q\u0012\u0004\t9\u0002\t\t\u0011#\u0001\u0002\u0012\"1qH\tC\u0001\u0003'C\u0011\"!&##\u0003%\t!a&\t\u0013\u00055&%%A\u0005\u0002\u0005=\u0006\"CAZEE\u0005I\u0011AA[\u0011%\tILII\u0001\n\u0003\tY\fC\u0004\u0002@\u0002!\t!!\u001e\t\u000f\u0005]\u0007\u0001\"\u0001\u0002v!9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005W\u0001A\u0011AA;\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003kBqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003<\u0001!IA!\u0010\u0003+A\u0013x\u000eZ;dKJLE-T1oC\u001e,'\u000fV3ti*\u0011!gM\u0001\fiJ\fgn]1di&|gN\u0003\u00025k\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00051\u0014!B6bM.\f7\u0001A\n\u0003\u0001e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001B!\t\u0011\u0005!D\u00012\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001S\u001b\u0002\rM,'O^3s\u0013\tQuI\u0001\u0011Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018A\u00062s_.,'\u000fV8D_:$(o\u001c7mKJ|F%Z9\u0015\u00055\u0003\u0006C\u0001\u001eO\u0013\ty5H\u0001\u0003V]&$\bbB)\u0004\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001W\u001b\u0002\u0005i\\\u0017B\u0001.X\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006I!p[\"mS\u0016tG\u000f\t\u0002\u0016\u001b>\u001c7\u000e\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s'\t9a\f\u0005\u0002C?&\u0011\u0001-\r\u0002\u0015%B\u001b\u0005K]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0019\t\u0003u\u0011L!!Z\u001e\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u00059\u0011\u000eZ*uCJ$X#A5\u0011\u0005iR\u0017BA6<\u0005\u0011auN\\4\u0002\u0017%$7\u000b^1si~#S-\u001d\u000b\u0003\u001b:Dq!U\u0006\u0002\u0002\u0003\u0007\u0011.\u0001\u0005jIN#\u0018M\u001d;!\u0003\u0015IG\rT3o\u0003\u0019IG\rT3oA\u0005)QM\u001d:peV\tA\u000f\u0005\u0002v\u007f6\taO\u0003\u0002xq\u0006A\u0001O]8u_\u000e|GN\u0003\u0002zu\u000611m\\7n_:T!AN>\u000b\u0005ql\u0018AB1qC\u000eDWMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u00031(AB#se>\u00148/A\u0005feJ|'o\u0018\u0013fcR\u0019Q*a\u0002\t\u000fE\u0003\u0012\u0011!a\u0001i\u00061QM\u001d:pe\u0002\n\u0001#[:FeJ|g.Z8vg\ncwnY6\u0016\u0005\u0005=\u0001c\u0001\u001e\u0002\u0012%\u0019\u00111C\u001e\u0003\u000f\t{w\u000e\\3b]\u0006\t\u0012n]#se>tWm\\;t\u00052|7m\u001b\u0011\u0002\tQLW.Z\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CA\u0018!B;uS2\u001c\u0018\u0002BA\u0013\u0003?\u0011A\u0001V5nK\u0006)A/[7fA\u0005\u0001\"/Z7bS:Lgn\u001a*fiJLWm]\u0001\u0015e\u0016l\u0017-\u001b8j]\u001e\u0014V\r\u001e:jKN|F%Z9\u0015\u00075\u000by\u0003C\u0004R/\u0005\u0005\t\u0019A2\u0002#I,W.Y5oS:<'+\u001a;sS\u0016\u001c\b\u0005\u0006\t\u00026\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002FA\u0019\u0011qG\u0004\u000e\u0003\u0001AQ!Y\rA\u0002\rDQaZ\rA\u0002%DQ\u0001]\rA\u0002\rDqA]\r\u0011\u0002\u0003\u0007A\u000fC\u0005\u0002\fe\u0001\n\u00111\u0001\u0002\u0010!I\u0011qC\r\u0011\u0002\u0003\u0007\u00111\u0004\u0005\t\u0003SI\u0002\u0013!a\u0001G\u0006\t#M]8lKJ$vnQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u000bb,7-\u001e;peV\u0011\u00111\n\t\u0005\u0003\u001b\nY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003+\n9&\u0001\u0003vi&d'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005u\u0013q\n\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0011#M]8lKJ$vnQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u000bb,7-\u001e;pe\u0002\nqbY1qiV\u0014X\r\u001a$bS2,(/Z\u000b\u0003\u0003K\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ny%\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003_\nIGA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0011G\u0006\u0004H/\u001e:fI\u001a\u000b\u0017\u000e\\;sK\u0002\n1b]3oIJ+\u0017/^3tiR\tQ*A\u0011iC:$G.Z!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z:q_:\u001cX\rF\u0002N\u0003wBq!!  \u0001\u0004\ty(\u0001\u0005sKN\u0004xN\\:f!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAACq\u0006A!/Z9vKN$8/\u0003\u0003\u0002\n\u0006\r%aG!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z:q_:\u001cX-A\u000bnCf\u0014WMU3rk\u0016\u001cHOT3yi\ncwnY6\u0002+5{7m\u001b)s_\u0012,8-\u001a:JI6\u000bg.Y4feB\u0019\u0011q\u0007\u0012\u0014\u0005\tJDCAAH\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0014\u0016\u0004i\u0006m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d6(\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\tL\u000b\u0003\u0002\u0010\u0005m\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u00028*\"\u00111DAN\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011\u0011Q\u0018\u0016\u0004G\u0006m\u0015a\u0005;fgR<U\r\u001e)s_\u0012,8-\u001a:JIj[\u0007f\u0001\u0015\u0002DB!\u0011QYAj\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017aA1qS*!\u0011QZAh\u0003\u001dQW\u000f]5uKJT1!!5~\u0003\u0015QWO\\5u\u0013\u0011\t).a2\u0003\tQ+7\u000f^\u0001\u001ci\u0016\u001cH/\u0012=dK\u0016$\u0007K]8ek\u000e,'/\u00133MS6LGOW6)\u0007%\n\u0019-A\u0011uKN$8i\u001c8dkJ\u0014XM\u001c;HK:,'/\u0019;f!&$'+Z9vKN$8\u000fF\u0002N\u0003?Da!!9+\u0001\u0004\u0019\u0017AC5e\u00052|7m\u001b'f]\":!&!:\u0002v\u0006]\b\u0003BAt\u0003cl!!!;\u000b\t\u0005-\u0018Q^\u0001\taJ|g/\u001b3fe*!\u0011q^Af\u0003\u0019\u0001\u0018M]1ng&!\u00111_Au\u0005-1\u0016\r\\;f'>,(oY3\u0002\t%tGo\u001d\u0017\t\u0003s\fY0!@\u0002\u0000v\t\u0011!H\u0001\u0003;\u0005QQ$\u00013)\u0007)\u0012\u0019\u0001\u0005\u0003\u0003\u0006\t\u001dQBAAw\u0013\u0011\u0011I!!<\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/A\fuKN$XK\u001c:fG>4XM]1cY\u0016,%O]8sgR\u0019QJa\u0004\t\u000bI\\\u0003\u0019\u0001;)\u0017-\u0012\u0019B!\u0007\u0003\u001c\tu!q\u0004\t\u0005\u0003O\u0014)\"\u0003\u0003\u0003\u0018\u0005%(AC#ok6\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\nA/A\u0003oC6,7\u000f\f\u0003\u0003\"\t\u0015\u0012E\u0001B\u0012\u0003Q)fj\u0013(P/:{6+\u0012*W\u000bJ{VI\u0015*P%\u0006\u0012!qE\u0001\u0010\u0013:3\u0016\tT%E?J+\u0015+V#T)\"\u001a1Fa\u0001\u0002#Q,7\u000f^%om\u0006d\u0017\u000e\u001a*b]\u001e,7\u000fK\u0002-\u0003\u0007\f\u0001\u0003^3tiJ+GO]=CC\u000e\\wN\u001a4)\u00075\n\u0019-A\u0007wKJLg-\u001f$bS2,(/\u001a\u000b\u0004\u001b\n]\u0002b\u0002B\u001d]\u0001\u0007\u0011QG\u0001\b[\u0006t\u0017mZ3s\u0003m1XM]5gs:+wO\u00117pG.\fe\u000e\u001a)s_\u0012,8-\u001a:JIR9QJa\u0010\u0003B\tE\u0003b\u0002B\u001d_\u0001\u0007\u0011Q\u0007\u0005\b\u0005\u0007z\u0003\u0019\u0001B#\u00035)\u0007\u0010]3di\u0016$'\t\\8dWB!!q\tB'\u001b\t\u0011IEC\u0002z\u0005\u0017R!\u0001\u0013>\n\t\t=#\u0011\n\u0002\u0011!J|G-^2fe&#7O\u00117pG.DaAa\u00150\u0001\u0004I\u0017aC3ya\u0016\u001cG/\u001a3QS\u0012\u0004")
public class ProducerIdManagerTest {
    private volatile ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager$module;
    private BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);

    public ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager() {
        if (this.MockProducerIdManager$module == null) {
            this.MockProducerIdManager$lzycompute$1();
        }
        return this.MockProducerIdManager$module;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Test
    public void testGetProducerIdZk() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$1 -> (Tuple2)((Option)zkVersion$1.elem).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])data.elem))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2)))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0))));
        ArgumentCaptor capturedVersion = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor capturedData = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.zkClient().conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])capturedData.capture(), BoxesRunTime.unboxToInt((Object)capturedVersion.capture()), (Option)ArgumentMatchers.any())).thenAnswer(x$3 -> {
            int newZkVersion = BoxesRunTime.unboxToInt((Object)capturedVersion.getValue()) + 1;
            zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
            data$1.elem = (byte[])capturedData.getValue();
            return new Tuple2.mcZI.sp(true, newZkVersion);
        });
        ZkProducerIdManager manager1 = new ZkProducerIdManager(0, this.zkClient());
        ZkProducerIdManager manager2 = new ZkProducerIdManager(1, this.zkClient());
        long pid1 = BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get());
        long pid2 = BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get());
        Assertions.assertEquals((long)0L, (long)pid1);
        Assertions.assertEquals((long)1000L, (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid1 + i), (long)BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get())));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid2 + i), (long)BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get())));
        Assertions.assertEquals((long)(pid2 + 1000L), (long)BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get()));
        Assertions.assertEquals((long)(pid2 + 2000L), (long)BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get()));
    }

    @Test
    public void testExceedProducerIdLimitZk() {
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$4 -> {
            byte[] json = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(0, 9223372036854774807L, 1000));
            return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
        });
        Assertions.assertThrows(KafkaException.class, () -> new ZkProducerIdManager(0, this.zkClient()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 10, 100})
    public void testConcurrentGeneratePidRequests(int idBlockLen) {
        int numThreads = 5;
        CountDownLatch latch = new CountDownLatch(idBlockLen * 3);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, idBlockLen, Errors.NONE, false, Time.SYSTEM, 1);
        Map pidMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ExecutorService requestHandlerThreadPool = Executors.newFixedThreadPool(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach((Function1 & Serializable)x$5 -> requestHandlerThreadPool.submit(() -> {
            while (latch$1.getCount() > 0L) {
                Try result = manager$1.generateProducerId();
                if (result instanceof Success) {
                    long pid = BoxesRunTime.unboxToLong((Object)((Success)result).value());
                    synchronized (pidMap$1) {
                        if (latch$1.getCount() != 0L) {
                            int counter = BoxesRunTime.unboxToInt((Object)pidMap$1.getOrElse((Object)BoxesRunTime.boxToLong((long)pid), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                            pidMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)pid)), (Object)BoxesRunTime.boxToInteger((int)(counter + 1))));
                            latch$1.countDown();
                        }
                    }
                } else if (result instanceof Failure) {
                    Throwable exception = ((Failure)result).exception();
                    Assertions.assertEquals(CoordinatorLoadInProgressException.class, exception.getClass());
                } else {
                    throw new MatchError((Object)result);
                }
                Thread.sleep(100L);
            }
        }, BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertTrue((boolean)latch.await(12000L, TimeUnit.MILLISECONDS));
        requestHandlerThreadPool.shutdown();
        Assertions.assertEquals((int)(idBlockLen * 3), (int)pidMap.size());
        pidMap.foreach((Function1 & Serializable)x0$1 -> {
            ProducerIdManagerTest.$anonfun$testConcurrentGeneratePidRequests$4(idBlockLen, numThreads, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"UNKNOWN_SERVER_ERROR", "INVALID_REQUEST"})
    public void testUnrecoverableErrors(Errors error) {
        MockTime time = new MockTime();
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$5 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        boolean x$6 = false;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$7 = 1;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, x$5, x$6, (Time)time, x$7);
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 0L, 1), 0L);
        manager.error_$eq(error);
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyFailure(manager);
        manager.error_$eq(Errors.NONE);
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 1L, 1), 1L);
    }

    @Test
    public void testInvalidRanges() {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$5 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Time x$6 = Time.SYSTEM;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$7 = 1;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, -1L, 10, x$5, true, x$6, x$7);
        this.verifyFailure(manager);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$12 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Time x$13 = Time.SYSTEM;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$14 = 1;
        manager = new MockProducerIdManager(this, 0, 0L, -1, x$12, true, x$13, x$14);
        this.verifyFailure(manager);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$19 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Time x$20 = Time.SYSTEM;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$21 = 1;
        manager = new MockProducerIdManager(this, 0, 0x7FFFFFFFFFFFFFFEL, 10, x$19, true, x$20, x$21);
        this.verifyFailure(manager);
    }

    @Test
    public void testRetryBackoff() {
        MockTime time = new MockTime();
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        boolean x$7 = false;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, Errors.UNKNOWN_SERVER_ERROR, x$7, (Time)time, 2);
        this.verifyFailure(manager);
        manager.error_$eq(Errors.NONE);
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, manager.generateProducerId().failed().get().getClass());
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 0L, 1), 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFailure(MockProducerIdManager manager) {
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, manager.generateProducerId().failed().get().getClass());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyFailure$1(manager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected failure");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        manager.capturedFailure().set(false);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNewBlockAndProducerId(MockProducerIdManager manager, ProducerIdsBlock expectedBlock, long expectedPid) {
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, manager.generateProducerId().failed().get().getClass());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyNewBlockAndProducerId$1(manager, expectedBlock)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to generate block");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)expectedPid, (long)BoxesRunTime.unboxToLong((Object)manager.generateProducerId().get()));
    }

    private final void MockProducerIdManager$lzycompute$1() {
        synchronized (this) {
            if (this.MockProducerIdManager$module == null) {
                this.MockProducerIdManager$module = new ProducerIdManagerTest$MockProducerIdManager$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testConcurrentGeneratePidRequests$4(int idBlockLen$1, int numThreads$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long pid = x0$1._1$mcJ$sp();
            int count = x0$1._2$mcI$sp();
            Assertions.assertEquals((int)1, (int)count);
            Assertions.assertTrue((pid < (long)(3 * idBlockLen$1 + numThreads$1) ? 1 : 0) != 0, (String)new StringBuilder(81).append("Unexpected pid ").append(pid).append("; ").append("non-contiguous blocks generated or did not fully exhaust blocks.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFailure$1(MockProducerIdManager manager$2) {
        synchronized (manager$2) {
            boolean bl = manager$2.capturedFailure().get();
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyFailure$2() {
        return "Expected failure";
    }

    public static final /* synthetic */ boolean $anonfun$verifyNewBlockAndProducerId$1(MockProducerIdManager manager$3, ProducerIdsBlock expectedBlock$1) {
        ProducerIdsBlock nextBlock = (ProducerIdsBlock)manager$3.nextProducerIdBlock().get();
        return nextBlock != null && nextBlock.equals((Object)expectedBlock$1);
    }

    public static final /* synthetic */ String $anonfun$verifyNewBlockAndProducerId$2() {
        return "failed to generate block";
    }

    public class MockProducerIdManager
    extends RPCProducerIdManager {
        private final int brokerId;
        private long idStart;
        private final int idLen;
        private Errors error;
        private final boolean isErroneousBlock;
        private final Time time;
        private int remainingRetries;
        private final ExecutorService brokerToControllerRequestExecutor;
        private final AtomicBoolean capturedFailure;
        public final /* synthetic */ ProducerIdManagerTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public long idStart() {
            return this.idStart;
        }

        public void idStart_$eq(long x$1) {
            this.idStart = x$1;
        }

        public int idLen() {
            return this.idLen;
        }

        public Errors error() {
            return this.error;
        }

        public void error_$eq(Errors x$1) {
            this.error = x$1;
        }

        public boolean isErroneousBlock() {
            return this.isErroneousBlock;
        }

        public Time time() {
            return this.time;
        }

        public int remainingRetries() {
            return this.remainingRetries;
        }

        public void remainingRetries_$eq(int x$1) {
            this.remainingRetries = x$1;
        }

        private ExecutorService brokerToControllerRequestExecutor() {
            return this.brokerToControllerRequestExecutor;
        }

        public AtomicBoolean capturedFailure() {
            return this.capturedFailure;
        }

        public void sendRequest() {
            this.brokerToControllerRequestExecutor().submit(() -> {
                Errors errors = this.error();
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setProducerIdStart(this.idStart()).setProducerIdLen(this.idLen())));
                    if (!this.isErroneousBlock()) {
                        this.idStart_$eq(this.idStart() + (long)this.idLen());
                        return;
                    }
                    return;
                }
                this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setErrorCode(this.error().code())));
            }, BoxesRunTime.boxToInteger((int)0));
        }

        public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
            super.handleAllocateProducerIdsResponse(response);
            this.capturedFailure().set(this.nextProducerIdBlock().get() == null);
        }

        public void maybeRequestNextBlock() {
            Errors errors = this.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null) && !this.isErroneousBlock()) {
                super.maybeRequestNextBlock();
                return;
            }
            if (this.remainingRetries() > 0) {
                super.maybeRequestNextBlock();
                this.remainingRetries_$eq(this.remainingRetries() - 1);
                return;
            }
        }

        public /* synthetic */ ProducerIdManagerTest kafka$coordinator$transaction$ProducerIdManagerTest$MockProducerIdManager$$$outer() {
            return this.$outer;
        }

        public MockProducerIdManager(ProducerIdManagerTest $outer, int brokerId, long idStart, int idLen, Errors error, boolean isErroneousBlock, Time time, int remainingRetries) {
            this.brokerId = brokerId;
            this.idStart = idStart;
            this.idLen = idLen;
            this.error = error;
            this.isErroneousBlock = isErroneousBlock;
            this.time = time;
            this.remainingRetries = remainingRetries;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(brokerId, time, (Function0)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final long apply() {
                    return 1L;
                }

                public final long apply$mcJ$sp() {
                    return 1L;
                }
            }, $outer.brokerToController());
            this.brokerToControllerRequestExecutor = Executors.newSingleThreadExecutor();
            this.capturedFailure = new AtomicBoolean(false);
        }
    }
}

