/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.KafkaScheduler;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.SystemTimer;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005r!\u0002\u001f>\u0011\u0003\u0011e!\u0002#>\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003ie\u0001\u0002(\u0002\u0001=C\u0001BV\u0002\u0003\u0002\u0003\u0006Ia\u0016\u0005\t[\u000e\u0011\t\u0011)A\u0005]\")Aj\u0001C\u0001s\"9\u0011QA\u0002\u0005B\u0005\u001d\u0001bBA\b\u0007\u0011\u0005\u0013\u0011\u0003\u0005\b\u00033\u0019A\u0011IA\u000e\u0011\u001d\ti\"\u0001C\u0005\u0003?Aq!!\u000f\u0002\t\u0013\tYDB\u0003E{\u0001\t9\u0005\u0003\u0006\u0002^1\u0011\t\u0011)A\u0005\u0003?B!\"a\u001b\r\u0005\u0003\u0005\u000b\u0011BA7\u0011)\t\u0019\b\u0004B\u0001B\u0003%\u0011Q\u000f\u0005\u000b\u0003\u000fc!\u0011!Q\u0001\n\u0005%\u0005BCAJ\u0019\t\u0005\t\u0015!\u0003\u0002\u0016\"Q\u00111\u0014\u0007\u0003\u0002\u0003\u0006I!!(\t\u0015\u0005\u001dFB!A!\u0002\u0013\tI\u000b\u0003\u0006\u000242\u0011\t\u0011)A\u0005\u0003kC!\"a/\r\u0005\u000b\u0007I\u0011AA_\u0011)\u0011\t\u0001\u0004B\u0001B\u0003%\u0011q\u0018\u0005\u0007\u00192!\tAa\u0001\t\u0013\teAB1A\u0005\u0002\tm\u0001\u0002\u0003B\u0015\u0019\u0001\u0006IA!\b\t\u0013\t-BB1A\u0005\n\t5\u0002\u0002\u0003B\u001b\u0019\u0001\u0006IAa\f\t\u00115d!\u0019!C\u0005\u0005oAqA!\u000f\rA\u0003%a\u000eC\u0005\u0003<1\u0011\r\u0011\"\u0003\u0003>!A!Q\t\u0007!\u0002\u0013\u0011y\u0004C\u0005\u0003H1\u0011\r\u0011\"\u0003\u0003J!A!\u0011\u000b\u0007!\u0002\u0013\u0011Y\u0005C\u0005\u0002F1\u0011\r\u0011\"\u0003\u0003T!A!Q\u000b\u0007!\u0002\u0013\t\t\u0003C\u0005\u0003X1\u0011\r\u0011\"\u0003\u0003Z!A!Q\f\u0007!\u0002\u0013\u0011Y\u0006C\u0005\u0003`1\u0011\r\u0011\"\u0011\u0003b!A!\u0011\u000e\u0007!\u0002\u0013\u0011\u0019\u0007C\u0005\u0003l1\u0011\r\u0011\"\u0003\u0003n!A!Q\u000f\u0007!\u0002\u0013\u0011y\u0007C\u0005\u0003x1\u0011\r\u0011\"\u0003\u0003z!A!q\u0011\u0007!\u0002\u0013\u0011Y\bC\u0005\u0003\n2\u0011\r\u0011\"\u0003\u0003\f\"A!1\u0013\u0007!\u0002\u0013\u0011i\t\u0003\u0005W\u0019\t\u0007I\u0011\tBK\u0011!\u0011I\n\u0004Q\u0001\n\t]\u0005\"\u0003BN\u0019\t\u0007I\u0011\u0002BO\u0011!\u0011Y\u000b\u0004Q\u0001\n\t}\u0005b\u0002BW\u0019\u0011\u0005\u0011q\u0001\u0005\b\u0005_cA\u0011AA\u0004\u0011\u001d\u0011\t\f\u0004C!\u0005gCqAa2\r\t\u0003\u0012I\rC\u0004\u0003x2!IA!?\t\u000f\tmH\u0002\"\u0003\u0003~\"9!q \u0007\u0005\n\r\u0005\u0001bBB\u0002\u0019\u0011%1Q\u0001\u0005\b\u0007\u001baA\u0011BB\b\u0011\u001d\u00199\u0002\u0004C!\u00073\t\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u000b\u0005yz\u0014\u0001\u0002:bMRT\u0011\u0001Q\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0019\u0015!D\u0001>\u0005AY\u0015MZ6b%\u00064G/T1oC\u001e,'o\u0005\u0002\u0002\rB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\"\u0003\u0019I\u000bg\r^%p)\"\u0014X-\u00193\u0014\u0005\r\u0001\u0006CA)U\u001b\u0005\u0011&BA*@\u0003\u0015)H/\u001b7t\u0013\t)&K\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017AB2mS\u0016tG\u000f\r\u0002YIB\u0019\u0011\f\u00192\u000e\u0003iS!AP.\u000b\u0005\u0001c&BA/_\u0003\u0019\t\u0007/Y2iK*\tq,A\u0002pe\u001eL!!\u0019.\u0003\u001f-\u000bgm[1SC\u001a$8\t\\5f]R\u0004\"a\u00193\r\u0001\u0011IQ\rBA\u0001\u0002\u0003\u0015\tA\u001a\u0002\u0004?\u0012\n\u0014CA4k!\t9\u0005.\u0003\u0002j\u0011\n9aj\u001c;iS:<\u0007CA$l\u0013\ta\u0007JA\u0002B]f\f\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005=4hB\u00019u!\t\t\b*D\u0001s\u0015\t\u0019\u0018)\u0001\u0004=e>|GOP\u0005\u0003k\"\u000ba\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011Q\u000f\u0013\u000b\u0005ur\f\u0019\u0001\u0005\u0002|\u00075\t\u0011\u0001C\u0003W\r\u0001\u0007Q\u0010M\u0002\u007f\u0003\u0003\u00012!\u00171\u0000!\r\u0019\u0017\u0011\u0001\u0003\nKr\f\t\u0011!A\u0003\u0002\u0019DQ!\u001c\u0004A\u00029\fa\u0001Z8X_J\\GCAA\u0005!\r9\u00151B\u0005\u0004\u0003\u001bA%\u0001B+oSR\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005M\u0001cA$\u0002\u0016%\u0019\u0011q\u0003%\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011n\u001d*v]:LgnZ\u000b\u0003\u0003'\t!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR1\u0011\u0011EA\u0019\u0003k\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0002j_*\u0011\u00111F\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0005\u0015\"\u0001\u0002$jY\u0016Dq!a\r\u000b\u0001\u0004\t\t#\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007\u0003oQ\u0001\u0019\u00018\u0002\u00151|w\rR5s\u001d\u0006lW-A\u0006m_\u000e\\G)\u0019;b\t&\u0014H\u0003BA\u001f\u0003\u0007\u00022!UA \u0013\r\t\tE\u0015\u0002\t\r&dW\rT8dW\"9\u0011QI\u0006A\u0002\u0005\u0005\u0012a\u00023bi\u0006$\u0015N]\u000b\u0005\u0003\u0013\n\u0019f\u0005\u0004\r\r\u0006-\u0013q\u000b\t\u0006\u0007\u00065\u0013\u0011K\u0005\u0004\u0003\u001fj$a\u0003*bMRl\u0015M\\1hKJ\u00042aYA*\t\u0019\t)\u0006\u0004b\u0001M\n\tA\u000bE\u0002R\u00033J1!a\u0017S\u0005\u001daunZ4j]\u001e\fa\"\\3uCB\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)gP\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005%\u00141\r\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u0003\u0019\u0019wN\u001c4jOB!\u0011\u0011MA8\u0013\u0011\t\t(a\u0019\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001d3TKJ$W\r\u0005\u0004\u0002x\u0005\r\u0015\u0011K\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005i1/\u001a:jC2L'0\u0019;j_:TA!a \u0002\u0002\u000611m\\7n_:T1!!\u001a\\\u0013\u0011\t))!\u001f\u0003\u0017I+7m\u001c:e'\u0016\u0014H-Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tY)a$\u000e\u0005\u00055%bAA@7&!\u0011\u0011SAG\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0001^8qS\u000eLE\r\u0005\u0003\u0002\f\u0006]\u0015\u0002BAM\u0003\u001b\u0013A!V;jI\u0006!A/[7f!\u0011\ty*a)\u000e\u0005\u0005\u0005&bA*\u0002\u000e&!\u0011QUAQ\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u00111VAX\u001b\t\tiK\u0003\u0003\u0002(\u00065\u0015\u0002BAY\u0003[\u0013q!T3ue&\u001c7/A\nuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq>\u0003H\u000f\u0005\u0003H\u0003os\u0017bAA]\u0011\n1q\n\u001d;j_:\fAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002@B1\u0011\u0011YAf\u0003\u001fl!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u000bG>t7-\u001e:sK:$(\u0002BAe\u0003S\tA!\u001e;jY&!\u0011QZAb\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003#\f\u0019.a6\u0002d6\u0011\u0011qY\u0005\u0005\u0003+\f9MA\u0002NCB\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0005\u0003;\fI#\u0001\u0003mC:<\u0017\u0002BAq\u00037\u0014q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002f\u0006mh\u0002BAt\u0003otA!!;\u0002v:!\u00111^Az\u001d\u0011\ti/!=\u000f\u0007E\fy/C\u0001`\u0013\tif,\u0003\u0002A9&\u0011ahW\u0005\u0004\u0003sT\u0016A\u0003*bMR\u001cuN\u001c4jO&!\u0011Q`A\u0000\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\u0007\u0005e(,A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!)Q\u0011)Aa\u0002\u0003\n\t-!Q\u0002B\b\u0005#\u0011\u0019B!\u0006\u0003\u0018A!1\tDA)\u0011\u001d\tif\u0006a\u0001\u0003?Bq!a\u001b\u0018\u0001\u0004\ti\u0007C\u0004\u0002t]\u0001\r!!\u001e\t\u000f\u0005\u001du\u00031\u0001\u0002\n\"9\u00111S\fA\u0002\u0005U\u0005bBAN/\u0001\u0007\u0011Q\u0014\u0005\b\u0003O;\u0002\u0019AAU\u0011\u001d\t\u0019l\u0006a\u0001\u0003kCq!a/\u0018\u0001\u0004\ty,A\u0006ba&4VM]:j_:\u001cXC\u0001B\u000f!\u0011\u0011yB!\n\u000e\u0005\t\u0005\"b\u0001B\u00127\u000691\r\\5f]R\u001c\u0018\u0002\u0002B\u0014\u0005C\u00111\"\u00119j-\u0016\u00148/[8og\u0006a\u0011\r]5WKJ\u001c\u0018n\u001c8tA\u0005Q!/\u00194u\u0007>tg-[4\u0016\u0005\t=\u0002cA-\u00032%\u0019!1\u0007.\u0003\u0015I\u000bg\r^\"p]\u001aLw-A\u0006sC\u001a$8i\u001c8gS\u001e\u0004S#\u00018\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"Aa\u0010\u0011\t\u0005}%\u0011I\u0005\u0005\u0005\u0007\n\tK\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0005\u0017\u00022!\u0015B'\u0013\r\u0011yE\u0015\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u000b\u0003\u0003C\t\u0001\u0002Z1uC\u0012K'\u000fI\u0001\fI\u0006$\u0018\rR5s\u0019>\u001c7.\u0006\u0002\u0003\\A)q)a.\u0002>\u0005aA-\u0019;b\t&\u0014Hj\\2lA\u0005i!/\u001a9mS\u000e\fG/\u001a3M_\u001e,\"Aa\u0019\u0011\u0007e\u0013)'C\u0002\u0003hi\u0013QBU3qY&\u001c\u0017\r^3e\u0019><\u0017A\u0004:fa2L7-\u0019;fI2{w\rI\u0001\u000b]\u0016$8\t[1o]\u0016dWC\u0001B8!\r\u0019%\u0011O\u0005\u0004\u0005gj$aE&bM.\fg*\u001a;x_J\\7\t[1o]\u0016d\u0017a\u00038fi\u000eC\u0017M\u001c8fY\u0002\nq\"\u001a=qSJ\fG/[8o)&lWM]\u000b\u0003\u0005w\u0002BA! \u0003\u00046\u0011!q\u0010\u0006\u0004\u0005\u0003\u0013\u0016!\u0002;j[\u0016\u0014\u0018\u0002\u0002BC\u0005\u007f\u00121bU=ti\u0016lG+[7fe\u0006\u0001R\r\u001f9je\u0006$\u0018n\u001c8US6,'\u000fI\u0001\u0012Kb\u0004\u0018N]1uS>t7+\u001a:wS\u000e,WC\u0001BG!\r\u0019%qR\u0005\u0004\u0005#k$\u0001\b+j[&twm\u00165fK2,\u0005\u0010]5sCRLwN\\*feZL7-Z\u0001\u0013Kb\u0004\u0018N]1uS>t7+\u001a:wS\u000e,\u0007%\u0006\u0002\u0003\u0018B!\u0011\fYA)\u0003\u001d\u0019G.[3oi\u0002\nAB]1gi&{G\u000b\u001b:fC\u0012,\"Aa(\u0011\u0007\t\u00056AD\u0002\u0003$\u0002qAA!*\u0003*:\u0019\u0011Oa*\n\u0003\u0001K!AP \u0002\u001bI\fg\r^%p)\"\u0014X-\u00193!\u0003\u001d\u0019H/\u0019:ukB\f\u0001b\u001d5vi\u0012|wO\\\u0001\te\u0016<\u0017n\u001d;feR!\u0011\u0011\u0002B[\u0011\u001d\u00119\f\u000ea\u0001\u0005s\u000b\u0001\u0002\\5ti\u0016tWM\u001d\t\u0007\u0005w\u0013\t-!\u0015\u000f\u0007e\u0013i,C\u0002\u0003@j\u000b!BU1gi\u000ec\u0017.\u001a8u\u0013\u0011\u0011\u0019M!2\u0003\u00111K7\u000f^3oKJT1Aa0[\u00035A\u0017M\u001c3mKJ+\u0017/^3tiRA!1\u001aBm\u0005S\u0014i\u000f\u0005\u0004\u0002B\u0006-'Q\u001a\t\u0005\u0005\u001f\u0014).\u0004\u0002\u0003R*!!1[AG\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002Bl\u0005#\u0014!\"\u00119j\u001b\u0016\u001c8/Y4f\u0011\u001d\u0011Y.\u000ea\u0001\u0005;\fa\u0001[3bI\u0016\u0014\b\u0003\u0002Bp\u0005Kl!A!9\u000b\t\t\r\u0018QR\u0001\te\u0016\fX/Z:ug&!!q\u001dBq\u00055\u0011V-];fgRDU-\u00193fe\"9!1^\u001bA\u0002\t5\u0017a\u0002:fcV,7\u000f\u001e\u0005\b\u0005_,\u0004\u0019\u0001By\u00035\u0019'/Z1uK\u0012$\u0016.\\3NgB\u0019qIa=\n\u0007\tU\bJ\u0001\u0003M_:<\u0017a\u00042vS2$'+\u00194u\u00072LWM\u001c;\u0015\u0005\t]\u0015a\u00052vS2$g*\u001a;x_J\\7\t[1o]\u0016dGC\u0001B8\u00035\u0019'/Z1uK\u0012\u000bG/\u0019#jeR\u0011\u0011\u0011E\u0001\u0011EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$\"aa\u0002\u0011\u0007\r\u001bI!C\u0002\u0004\fu\u0012\u0001cS1gW\u0006lU\r^1eCR\fGj\\4\u0002%\t,\u0018\u000e\u001c3OKR<xN]6DY&,g\u000e\u001e\u000b\u0003\u0007#\u0001BAa\b\u0004\u0014%!1Q\u0003B\u0011\u00055qU\r^<pe.\u001cE.[3oi\u0006qA.Z1eKJ\fe\u000eZ#q_\u000eDWCAB\u000e!\rI6QD\u0005\u0004\u0007?Q&A\u0004'fC\u0012,'/\u00118e\u000bB|7\r\u001b")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        CollectionConverters$.MODULE$.SetHasAsScala(voterAddresses.entrySet()).asScala().foreach((Function1 & Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftIoThread().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
            x$3.destroy();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private KafkaRaftClient<T> buildRaftClient() {
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties.clusterId(), nodeId, this.raftConfig());
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(22).append("[RaftManager nodeId=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), true);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = !((SeqOps)config.logDirs().map((Function1 & Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor", 1L, 20, Time.SYSTEM.hiResClockMs());
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix());
    }

    public static class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient<?> client;

        @Override
        public void doWork() {
            this.client.poll();
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix) {
            this.client = client;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
        }
    }
}

