/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import kafka.tools.NoOpMessageFormatter;
import kafka.utils.MockTime;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.MockDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BQA\r\u0001\u0005\u0002MBQ\u0001\u0012\u0001\u0005\u0002MBQ!\u0013\u0001\u0005\u0002MBQa\u0013\u0001\u0005\u0002MBQ!\u0014\u0001\u0005\u0002MBQa\u0014\u0001\u0005\u0002MBQ!\u0015\u0001\u0005\u0002MBQa\u0015\u0001\u0005\u0002MBQ!\u0016\u0001\u0005\u0002MBQa\u0016\u0001\u0005\u0002MBQ!\u0017\u0001\u0005\u0002MBQa\u0017\u0001\u0005\u0002MBQ!\u0018\u0001\u0005\u0002MBQa\u0018\u0001\u0005\u0002MBQ!\u0019\u0001\u0005\u0002MBQa\u0019\u0001\u0005\u0002MBQ!\u001a\u0001\u0005\u0002MBQa\u001a\u0001\u0005\u0002MBQ!\u001b\u0001\u0005\u0002MBQa\u001b\u0001\u0005\u0002MBQ!\u001c\u0001\u0005\u0002MBQa\u001c\u0001\u0005\u0002MBQ!\u001d\u0001\u0005\u0002MBQa\u001d\u0001\u0005\u0002MBQ!\u001e\u0001\u0005\u0002MBQa\u001e\u0001\u0005\u0002MBQ!\u001f\u0001\u0005\u0002MBQa\u001f\u0001\u0005\u0002MBQ! \u0001\u0005\u0002MBQa \u0001\u0005\u0002MBa!a\u0001\u0001\t\u0003\u0019$aE\"p]N|G.Z\"p]N,X.\u001a:UKN$(BA\u0012%\u0003\u0015!xn\u001c7t\u0015\u0005)\u0013!B6bM.\f7\u0001A\n\u0003\u0001!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00011!\t\t\u0004!D\u0001#\u0003\u0015\u0019X\r^;q)\u0005!\u0004CA\u00156\u0013\t1$F\u0001\u0003V]&$\bF\u0001\u00029!\tI$)D\u0001;\u0015\tYD(A\u0002ba&T!!\u0010 \u0002\u000f),\b/\u001b;fe*\u0011q\bQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rS$A\u0003\"fM>\u0014X-R1dQ\u0006y3\u000f[8vY\u0012$\u0006N]8x)&lWm\\;u\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8US6,w.\u001e;JgJ+\u0017m\u00195fI\"\u00121A\u0012\t\u0003s\u001dK!\u0001\u0013\u001e\u0003\tQ+7\u000f^\u0001'g\"|W\u000f\u001c3SKN,G/\u00168D_:\u001cX/\\3e\u001f\u001a47/\u001a;t\u0005\u00164wN]3Fq&$\bF\u0001\u0003G\u0003\u0005\u001a\bn\\;mI2KW.\u001b;SK\u0006$7\u000fV8NCblUm]:bO\u0016d\u0015.\\5uQ\t)a)A\u0012tQ>,H\u000eZ*u_B<\u0006.\u001a8PkR\u0004X\u000f^\"iK\u000e\\WI\u001d:pe\u001a\u000b\u0017\u000e\\:)\u0005\u00191\u0015aI:i_VdG\rU1sg\u00164\u0016\r\\5e\u0007>t7/^7feZ\u000bG.\u001b3D_:4\u0017n\u001a\u0015\u0003\u000f\u0019\u000b!d\u001d5pk2$\u0007+\u0019:tK&s7\r\\;eK\u0006\u0013x-^7f]RD#\u0001\u0003$\u00029MDw.\u001e7e!\u0006\u00148/Z,iSR,G.[:u\u0003J<W/\\3oi\"\u0012\u0011BR\u00010g\"|W\u000f\u001c3JO:|'/Z,iSR,G.[:u\u0003J<W/\\3oi&3\u0017J\\2mk\u0012,7\u000b]3dS\u001aLW\r\u001a\u0015\u0003\u0015\u0019\u000b!h\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3TS6\u0004H.Z\"p]N,X.\u001a:WC2LGmQ8oM&<w+\u001b;i\u001dVlWM]5d\u001f\u001a47/\u001a;)\u0005-1\u0015!K:i_VdG-\u0012=ji>sWK\u001c:fG><g.\u001b>fI:+woQ8ogVlWM](qi&|g\u000e\u000b\u0002\r\r\u0006I4\u000f[8vY\u0012\u0004\u0016M]:f-\u0006d\u0017\u000eZ*j[BdWmQ8ogVlWM\u001d,bY&$7i\u001c8gS\u001e<\u0016\u000e\u001e5TiJLgnZ(gMN,G\u000f\u000b\u0002\u000e\r\u000694\u000f[8vY\u0012\u0004\u0016M]:f-\u0006d\u0017\u000eZ\"p]N,X.\u001a:D_:4\u0017nZ,ji\"\fU\u000f^8PM\u001a\u001cX\r\u001e*fg\u0016$H*\u0019;fgRD#A\u0004$\u0002sMDw.\u001e7e!\u0006\u00148/\u001a,bY&$7i\u001c8tk6,'oQ8oM&<w+\u001b;i\u0003V$xn\u00144gg\u0016$(+Z:fi\u0016\u000b'\u000f\\5fgRD#a\u0004$\u0002\u0013NDw.\u001e7e!\u0006\u00148/\u001a,bY&$7i\u001c8tk6,'oQ8oM&<w+\u001b;i\u0003V$xn\u00144gg\u0016$(+Z:fi\u0006sG-T1uG\"Lgn\u001a$s_6\u0014UmZ5o]&tw\r\u000b\u0002\u0011\r\u0006y3\u000f[8vY\u0012\u0004\u0016M]:f-\u0006d\u0017\u000eZ\"p]N,X.\u001a:D_:4\u0017nZ,ji\"tun\u00144gg\u0016$(+Z:fi\"\u0012\u0011CR\u0001Hg\"|W\u000f\u001c3Fq&$xJ\\%om\u0006d\u0017\u000eZ\"p]\u001aLwmV5uQ\u0006+Ho\\(gMN,GOU3tKR\fe\u000eZ\"p]\u001ad\u0017n\u0019;j]\u001e4%o\\7CK\u001eLgN\\5oO\"\u0012!CR\u0001\u001bg\"|W\u000f\u001c3QCJ\u001cXmQ8oM&<7O\u0012:p[\u001aKG.\u001a\u0015\u0003'\u0019\u000b!f\u001a:pkBLEm\u001d)s_ZLG-\u001a3J]\u0012KgMZ3sK:$\b\u000b\\1dKNlUo\u001d;NCR\u001c\u0007\u000e\u000b\u0002\u0015\r\u0006\tD/Z:u\u0007V\u001cHo\\7Qe>\u0004XM\u001d;z'\"|W\u000f\u001c3CKB\u000b7o]3e)>\u001cuN\u001c4jOV\u0014X-T3uQ>$\u0007FA\u000bG\u0003=\"Xm\u001d;DkN$x.\\\"p]\u001aLwm\u00155pk2$')\u001a)bgN,G\rV8D_:4\u0017nZ;sK6+G\u000f[8eQ\t1b)\u0001\u0017tQ>,H\u000e\u001a)beN,wI]8va&#gI]8n\u0005\u0016<\u0017N\u001c8j]\u001e<\u0015N^3o)><W\r\u001e5fe\"\u0012qCR\u0001-g\"|W\u000f\u001c3Fq&$xJ\\$s_V\u0004\u0018\nZ!oIB\u000b'\u000f^5uS>tw)\u001b<f]R{w-\u001a;iKJD#\u0001\u0007$\u0002EMDw.\u001e7e\u000bbLGo\u00148PM\u001a\u001cX\r^,ji\"|W\u000f\u001e)beRLG/[8oQ\tIb)A\u000euKN$H)\u001a4bk2$X*Z:tC\u001e,gi\u001c:nCR$XM\u001d\u0015\u00035\u0019\u000b\u0001\u0004^3ti:{w\n]'fgN\fw-\u001a$pe6\fG\u000f^3sQ\tYb)\u0001\u0013tQ>,H\u000eZ#ySRLeMT8U_BL7m\u0014:GS2$XM]*qK\u000eLg-[3eQ\tab)\u0001\u0013tQ>,H\u000eZ#ySRLe\rV8qS\u000e\fe\u000eZ%oG2,H-Z*qK\u000eLg-[3eQ\tib)\u0001\u0014tQ>,H\u000eZ#ySRLe\rV8qS\u000e\fe\u000eZ,iSR,G.[:u'B,7-\u001b4jK\u0012D#A\b$\u0002)Q,7\u000f^\"mS\u0016tG/\u00133Pm\u0016\u0014(/\u001b3fQ\tyb)A\nuKN$H)\u001a4bk2$8\t\\5f]RLE\r\u000b\u0002!\r\u0002")
public class ConsoleConsumerTest {
    @BeforeEach
    public void setup() {
        ConsoleConsumer$.MODULE$.messageCount_$eq(0);
    }

    @Test
    public void shouldThrowTimeoutExceptionWhenTimeoutIsReached() {
        String topic = "test";
        MockTime time = new MockTime();
        int timeoutMs = 1000;
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)mockConsumer.poll(Duration.ofMillis(timeoutMs))).thenAnswer(x$1 -> {
            time.sleep(timeoutMs / 2 + 1);
            return ConsumerRecords.EMPTY;
        });
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, mockConsumer, (long)timeoutMs, (Time)time);
        Assertions.assertThrows(TimeoutException.class, () -> consumer.receive());
    }

    @Test
    public void shouldResetUnConsumedOffsetsBeforeExit() {
        String topic = "test";
        int maxMessages = 123;
        int totalMessages = 700;
        Long startOffset = Predef$.MODULE$.long2Long(0L);
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Consumer)mockConsumer, Long.MAX_VALUE, Time.SYSTEM);
        mockConsumer.rebalance((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        mockConsumer.updateBeginningOffsets(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)startOffset), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)startOffset)}))).asJava());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> mockConsumer.addRecord(new ConsumerRecord(topic, i % 2, (long)(i / 2), (Object)"key".getBytes(), (Object)"value".getBytes())));
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(maxMessages), formatter, consumer, System.out, false);
        Assertions.assertEquals((long)totalMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        consumer.resetUnconsumedOffsets();
        Assertions.assertEquals((long)maxMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)maxMessages))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
    }

    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)messageLimit))).receive();
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)messageLimit))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        consumer.cleanup();
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()));
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((PrintStream)Mockito.verify((Object)printStream)).checkError();
        consumer.cleanup();
    }

    @Test
    public void shouldParseValidConsumerValidConfig() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseIncludeArgument() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--include", "includeTest*", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"includeTest*", (Object)config.includedTopicsArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseWhitelistArgument() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--whitelist", "whitelistTest*", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"whitelistTest*", (Object)config.includedTopicsArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldIgnoreWhitelistArgumentIfIncludeSpecified() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--include", "includeTest*", "--whitelist", "whitelistTest*", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"includeTest*", (Object)config.includedTopicsArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assertions.assertEquals((long)3L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$2, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(BoxesRunTime.unboxToInt((Object)x$2), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithStringOffset() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--property", "print.value=false"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((DefaultMessageFormatter)config.formatter()).printValue()));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetLatest() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetEarliest() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithNoOffsetReset() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$3, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(BoxesRunTime.unboxToInt((Object)x$3), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"};
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            Assertions.assertThrows(IllegalArgumentException.class, () -> ConsoleConsumer$.MODULE$.consumerProps(config));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("request.timeout.ms=1000\n".getBytes());
        propsStream.write("group.id=group1".getBytes());
        propsStream.close();
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
        Assertions.assertEquals((Object)"group1", (Object)config.consumerProps().getProperty("group.id"));
    }

    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$4, message) -> ConsoleConsumerTest.$anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(BoxesRunTime.unboxToInt((Object)x$4), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var6_1 = null;
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        ObjectRef args = ObjectRef.create((Object)new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=test-group".getBytes());
        propsStream.close();
        args.elem = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig((String[])args.elem);
        Properties props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args.elem = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        args.elem = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args.elem = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        args.elem = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"};
        config = new ConsoleConsumer.ConsumerConfig((String[])args.elem);
        props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit.resetExitProcedure();
    }

    @Test
    public void testCustomPropertyShouldBePassedToConfigureMethod() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--property", "key.deserializer.my-props=abc"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertTrue((boolean)(config.formatter() instanceof DefaultMessageFormatter));
        Assertions.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assertions.assertTrue((boolean)(formatter.keyDeserializer().get() instanceof MockDeserializer));
        MockDeserializer keyDeserializer = (MockDeserializer)formatter.keyDeserializer().get();
        Assertions.assertEquals((int)1, (int)keyDeserializer.configs.size());
        Assertions.assertEquals((Object)"abc", keyDeserializer.configs.get("my-props"));
        Assertions.assertTrue((boolean)keyDeserializer.isKey);
    }

    @Test
    public void testCustomConfigShouldBePassedToConfigureMethod() {
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("key.deserializer.my-props=abc\n".getBytes());
        propsStream.write("print.key=false".getBytes());
        propsStream.close();
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--formatter-config", propsFile.getAbsolutePath()};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertTrue((boolean)(config.formatter() instanceof DefaultMessageFormatter));
        Assertions.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assertions.assertTrue((boolean)(formatter.keyDeserializer().get() instanceof MockDeserializer));
        MockDeserializer keyDeserializer = (MockDeserializer)formatter.keyDeserializer().get();
        Assertions.assertEquals((int)1, (int)keyDeserializer.configs.size());
        Assertions.assertEquals((Object)"abc", keyDeserializer.configs.get("my-props"));
        Assertions.assertTrue((boolean)keyDeserializer.isKey);
    }

    @Test
    public void shouldParseGroupIdFromBeginningGivenTogether() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((long)-2L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group"};
        config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldExitOnGroupIdAndPartitionGivenTogether() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$5, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(BoxesRunTime.unboxToInt((Object)x$5), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--partition", "0"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitOnOffsetWithoutPartition() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$6, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnOffsetWithoutPartition$1(BoxesRunTime.unboxToInt((Object)x$6), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--offset", "10"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testDefaultMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        DefaultMessageFormatter formatter = new DefaultMessageFormatter();
        HashMap<String, String> configs = new HashMap<String, String>();
        formatter.configure(configs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"value\n", (Object)out.toString());
        configs.put("print.key", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"key\tvalue\n", (Object)out.toString());
        configs.put("print.partition", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"Partition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.timestamp", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.offset", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        out = new ByteArrayOutputStream();
        ConsumerRecord record2 = new ConsumerRecord("topic", 0, 123L, 123L, TimestampType.CREATE_TIME, -1, -1, (Object)"key".getBytes(), (Object)"value".getBytes(), (Headers)new RecordHeaders(), Optional.empty());
        formatter.writeTo(record2, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        formatter.close();
    }

    @Test
    public void testNoOpMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        NoOpMessageFormatter formatter = new NoOpMessageFormatter();
        formatter.configure(new HashMap());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"", (Object)out.toString());
    }

    @Test
    public void shouldExitIfNoTopicOrFilterSpecified() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$7, message) -> ConsoleConsumerTest.$anonfun$shouldExitIfNoTopicOrFilterSpecified$1(BoxesRunTime.unboxToInt((Object)x$7), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitIfTopicAndIncludeSpecified() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$8, message) -> ConsoleConsumerTest.$anonfun$shouldExitIfTopicAndIncludeSpecified$1(BoxesRunTime.unboxToInt((Object)x$8), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--include", "includeTest*"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitIfTopicAndWhitelistSpecified() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$9, message) -> ConsoleConsumerTest.$anonfun$shouldExitIfTopicAndWhitelistSpecified$1(BoxesRunTime.unboxToInt((Object)x$9), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--whitelist", "whitelistTest*"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testClientIdOverride() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--consumer-property", "client.id=consumer-1"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"consumer-1", (Object)consumerProperties.getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"console-consumer", (Object)consumerProperties.getProperty("client.id"));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(int x$2, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(int x$3, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(int x$4, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(int x$5, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnOffsetWithoutPartition$1(int x$6, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitIfNoTopicOrFilterSpecified$1(int x$7, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitIfTopicAndIncludeSpecified$1(int x$8, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitIfTopicAndWhitelistSpecified$1(int x$9, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }
}

