/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011B\u0011b\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002\u0017\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0013\u0001\u0005\"\u0003$\u0001\u0001\u0004\u0005\t\u0015)\u0003.\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0015\u0001!\u0002\u0013I\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u00075\u0002\u0001\u000b\u0011\u0002+\t\u000fm\u0003!\u0019!C\u00059\"1Q\r\u0001Q\u0001\nuCQA\u001a\u0001\u0005\n\u001dDQA\u001b\u0001\u0005\n-DQA\u001c\u0001\u0005B=Dq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u000e\u0001!\t&a\u0004\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002\u0004!9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0002bBA!\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0017\u0002A\u0011BA'\u0005a1U\r^2i%\u0016\fX/Z:u\u001b\u0006D()\u001f;fgR+7\u000f\u001e\u0006\u0003/a\taa]3sm\u0016\u0014(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;yi\u0011AF\u0005\u0003?Y\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"!\b\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t\u0019\u0011J\u001c;\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012!\f\t\u0005]]J\u0014(D\u00010\u0015\tY\u0003G\u0003\u00022e\u000591\r\\5f]R\u001c(BA\r4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005az#!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0002'uqJ!aO\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019j\u0014B\u0001 (\u0005\u0011\u0011\u0015\u0010^3\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005\u0005#\u0005C\u0001\u0014C\u0013\t\u0019uE\u0001\u0003V]&$\bbB#\u0005\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0014!\u00039s_\u0012,8-\u001a:!\u0003%!Xm\u001d;U_BL7-F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013aa\u0015;sS:<\u0017A\u0003;fgR$v\u000e]5dA\u0005\u0011B/Z:u)>\u0004\u0018n\u0019)beRLG/[8o+\u0005!\u0006CA+Y\u001b\u00051&BA,3\u0003\u0019\u0019w.\\7p]&\u0011\u0011L\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003M!Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8!\u0003!iWm]:bO\u0016\u001cX#A/\u0011\u0007y\u001b\u0017(D\u0001`\u0015\t\u0001\u0017-A\u0005j[6,H/\u00192mK*\u0011!mJ\u0001\u000bG>dG.Z2uS>t\u0017B\u00013`\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\n[\u0016\u001c8/Y4fg\u0002\na\"\\;mi&\u0014\u0015\u0010^3BeJ\f\u0017\u0010\u0006\u0002:Q\")\u0011\u000e\u0004a\u0001K\u00051A.\u001a8hi\"\fAb\u001c8f\u0005f$X-\u0011:sCf$\"!\u000f7\t\u000b5l\u0001\u0019\u0001\u001f\u0002\u000bY\fG.^3\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u0003\b\"B9\u000f\u0001\u0004\u0011\u0018\u0001\u0003;fgRLeNZ8\u0011\u0005MTX\"\u0001;\u000b\u0005U4\u0018aA1qS*\u0011q\u000f_\u0001\bUV\u0004\u0018\u000e^3s\u0015\tIX'A\u0003kk:LG/\u0003\u0002|i\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u000f{B\u00111O`\u0005\u0003\u007fR\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A!)\u0007=\t9\u0001E\u0002t\u0003\u0013I1!a\u0003u\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0019\u0011)!\u0005\t\u000f\u0005M\u0001\u00031\u0001\u0002\u0016\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007N\u0003\u0011)H/\u001b7\n\t\u0005}\u0011\u0011\u0004\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001D2sK\u0006$X\rV8qS\u000e\u001c\u0018\u0001E:f]\u00124U\r^2i%\u0016\fX/Z:u)\u0019\t9#a\r\u00028A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.Y\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003c\tYCA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0007\u0003k\u0011\u0002\u0019A\u0013\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!!\u000f\u0013\u0001\u0004\tY$A\u0004sKF,Xm\u001d;\u0011\t\u0005%\u0012QH\u0005\u0005\u0003\u007f\tYC\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\u000euKN$8i\u001c8tk6,W*\u001e7uSBdWMU3d_J$7\u000fK\u0002\u0014\u0003\u000b\u00022a]A$\u0013\r\tI\u0005\u001e\u0002\u0005)\u0016\u001cH/A\tfqB,7\r\u001e(fqR\u0014VmY8sIN$R!QA(\u0003SBq!!\u0015\u0015\u0001\u0004\t\u0019&\u0001\u0005fqB,7\r^3e!\u0015\t)&!\u001a:\u001d\u0011\t9&!\u0019\u000f\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\u001b\u0003\u0019a$o\\8u}%\t\u0001&C\u0002\u0002d\u001d\nq\u0001]1dW\u0006<W-C\u0002e\u0003OR1!a\u0019(\u0011\u001d\tY\u0007\u0006a\u0001\u0003[\n1BZ3uG\"|eMZ:fiB\u0019a%a\u001c\n\u0007\u0005EtE\u0001\u0003M_:<\u0007")
public class FetchRequestMaxBytesTest
extends BaseRequestTest {
    private KafkaProducer<byte[], byte[]> producer;
    private final String testTopic;
    private final TopicPartition testTopicPartition = new TopicPartition(this.testTopic(), 0);
    private final IndexedSeq<byte[]> messages = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{this.multiByteArray(1), this.multiByteArray(500), this.multiByteArray(1040), this.multiByteArray(500), this.multiByteArray(50)}));

    @Override
    public int brokerCount() {
        return 1;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    private String testTopic() {
        return this.testTopic;
    }

    private TopicPartition testTopicPartition() {
        return this.testTopicPartition;
    }

    private IndexedSeq<byte[]> messages() {
        return this.messages;
    }

    private byte[] multiByteArray(int length) {
        byte[] array = new byte[length];
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.byteArrayOps(array)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            array$1[i] = (byte)(i % 5);
        });
        return array;
    }

    private byte[] oneByteArray(byte value) {
        byte[] array = new byte[]{value};
        return array;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.producer_$eq(TestUtils$.MODULE$.createProducer(this.bootstrapServers(this.bootstrapServers$default$1()), -1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
    }

    private void createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(1));
        this.createTopic(this.testTopic(), 1, 1, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        this.messages().indices().foreach((Function1 & Serializable)i -> FetchRequestMaxBytesTest.$anonfun$createTopics$1(this, BoxesRunTime.unboxToInt((Object)i)));
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testConsumeMultipleRecords() {
        this.createTopics();
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(0), (byte[])this.messages().apply(1)}))), 0L);
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(2)}))), 2L);
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(3), (byte[])this.messages().apply(4)}))), 3L);
    }

    private void expectNextRecords(IndexedSeq<byte[]> expected, long fetchOffset) {
        Iterable records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(0, FetchRequest.Builder.forConsumer((short)3, (int)Integer.MAX_VALUE, (int)0, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testTopicPartition()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty()))}))).asJava()).build((short)3)).responseData(CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicNames()).asJava(), (short)3).get(this.testTopicPartition()))).records();
        Assertions.assertNotNull((Object)records);
        List recordsList = CollectionConverters$.MODULE$.IterableHasAsScala(records).asScala().toList();
        Assertions.assertEquals((int)expected.size(), (int)recordsList.size());
        ((List)recordsList.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            FetchRequestMaxBytesTest.$anonfun$expectNextRecords$1(expected, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ RecordMetadata $anonfun$createTopics$1(FetchRequestMaxBytesTest $this, int i) {
        byte oneByteArray_value = (byte)i;
        byte[] oneByteArray_array = new byte[]{oneByteArray_value};
        Object var5_3 = null;
        ProducerRecord record = new ProducerRecord($this.testTopic(), Predef$.MODULE$.int2Integer(0), (Object)oneByteArray_array, $this.messages().apply(i));
        Future future = $this.producer().send(record);
        $this.producer().flush();
        return (RecordMetadata)future.get();
    }

    public static final /* synthetic */ void $anonfun$expectNextRecords$1(IndexedSeq expected$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Record record = (Record)x0$1._1();
            int i = x0$1._2$mcI$sp();
            ByteBuffer buffer = record.value().duplicate();
            byte[] array = new byte[buffer.remaining()];
            buffer.get(array);
            Assertions.assertArrayEquals((byte[])((byte[])expected$1.apply(i)), (byte[])array, (String)new StringBuilder(37).append("expectNextRecords unexpected element ").append(i).toString());
            return;
        }
        throw new MatchError(null);
    }

    public FetchRequestMaxBytesTest() {
        this.testTopic = "testTopic";
    }
}

