/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005i3A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\t\r)\u0002\u0001\u0015!\u0003(\u0011\u001dY\u0003A1A\u0005\u00021Baa\u0011\u0001!\u0002\u0013i\u0003\"\u0002#\u0001\t\u0003)\u0005\"\u0002+\u0001\t\u0003)\u0005\"\u0002,\u0001\t\u0003)\u0005\"\u0002-\u0001\t\u0003)%A\u0005+sC:\u001c\u0018m\u0019;j_:dun\u001a+fgRT!AD\b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003!E\t1bY8pe\u0012Lg.\u0019;pe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u001b\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012!\t\t\u0003-\tJ!aI\f\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012a\n\t\u0003-!J!!K\f\u0003\u0007%sG/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\f\t\u0004]UBdBA\u00184!\t\u0001t#D\u00012\u0015\t\u00114#\u0001\u0004=e>|GOP\u0005\u0003i]\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\r\u0019V\r\u001e\u0006\u0003i]\u0001\"!O!\u000e\u0003iR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t\u0011RH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\";\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002GMDw.\u001e7e)\"\u0014xn^#yG\u0016\u0004H/[8o/JLG/Z%om\u0006d\u0017\u000e\u001a+y]R\ta\t\u0005\u0002\u0017\u000f&\u0011\u0001j\u0006\u0002\u0005+:LG\u000f\u000b\u0002\t\u0015B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u0004CBL'BA(Q\u0003\u001dQW\u000f]5uKJT!!U \u0002\u000b),h.\u001b;\n\u0005Mc%\u0001\u0002+fgR\fqc\u001d5pk2$'+Z1e/JLG/Z'fgN\fw-Z:)\u0005%Q\u0015A\b;fgR$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\u0006\u00148/\u001b8hQ\tQ!*A\u0014uKN$HK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR{WNY:u_:,\u0007+\u0019:tS:<\u0007FA\u0006K\u0001")
public class TransactionLogTest {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final scala.collection.immutable.Set<TopicPartition> topicPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        Assertions.assertThrows(IllegalStateException.class, () -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReadWriteMessages() {
        void withRecords_records;
        void withRecords_compressionType;
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Empty$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Ongoing$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)PrepareCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)CompleteCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)PrepareAbort$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)CompleteAbort$.MODULE$)}));
        Seq txnRecords = ((IterableOnceOps)pidMappings.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long producerId;
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = x0$1._2$mcJ$sp(), this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
                byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
                byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
                return new SimpleRecord(keyBytes, valueBytes);
            }
            throw new MatchError(null);
        })).toSeq();
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var10_7 = null;
        compressionType = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        IntRef count = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().foreach((Function1 & Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)pidMappings.size(), (int)count.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionMetadataParsing() {
        void var11_10;
        void var10_9;
        String transactionalId = "id";
        long producerId = 1334L;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)Ongoing$.MODULE$, 0L);
        txnMetadata.addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
        Record transactionMetadataRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, valueBytes), (List)Nil$.MODULE$), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(38).append("transaction_metadata::transactionalId=").append(transactionalId).toString()), (Object)var10_9);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(93).append("producerId:").append(producerId).append(",producerEpoch:").append(this.producerEpoch()).append(",state=Ongoing,").append("partitions=[").append(topicPartition).append("],txnLastUpdateTimestamp=0,txnTimeoutMs=").append(this.transactionTimeoutMs()).toString()), (Object)var11_10);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionMetadataTombstoneParsing() {
        void var5_5;
        void var4_4;
        String transactionalId = "id";
        Record transactionMetadataRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(TransactionLog$.MODULE$.keyToBytes(transactionalId), null), (List)Nil$.MODULE$), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(38).append("transaction_metadata::transactionalId=").append(transactionalId).toString()), (Object)var4_4);
        Assertions.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)var5_5);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value()).get();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)$this.producerEpoch(), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((int)$this.transactionTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
        if (txnMetadata.state().equals(Empty$.MODULE$)) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
        } else {
            Assertions.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
        }
        ++count$1.elem;
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

