/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.SetLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMs!B\u0001\u0003\u0011\u0003I\u0011aE*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014(BA\u0002\u0005\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QBA\nTS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'o\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00013\u0005I!l[+sYB\u0013x\u000e]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB*ue&tw\r\u0003\u0004$\u0017\u0001\u0006IAG\u0001\u000b5.,&\u000f\u001c)s_B\u0004\u0003bB\u0013\f\u0005\u0004%\t!G\u0001\u00185.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|U\u000f\u001e)s_BDaaJ\u0006!\u0002\u0013Q\u0012\u0001\u0007.l\u0007>tg.Z2uS>tG+[7f\u001fV$\bK]8qA!9\u0011f\u0003b\u0001\n\u0003I\u0012\u0001\u0006.l'\u0016\u001c8/[8o)&lWmT;u!J|\u0007\u000f\u0003\u0004,\u0017\u0001\u0006IAG\u0001\u00165.\u001cVm]:j_:$\u0016.\\3PkR\u0004&o\u001c9!\u0011\u001di3B1A\u0005\u0002e\tQCW6NCbLeN\u00127jO\"$(+Z9vKN$8\u000f\u0003\u00040\u0017\u0001\u0006IAG\u0001\u00175.l\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;tA!9\u0011g\u0003b\u0001\n\u0003I\u0012AD*va\u0016\u0014Xk]3sgB\u0013x\u000e\u001d\u0005\u0007g-\u0001\u000b\u0011\u0002\u000e\u0002\u001fM+\b/\u001a:Vg\u0016\u00148\u000f\u0015:pa\u0002Bq!N\u0006C\u0002\u0013\u0005\u0011$A\u0010BY2|w/\u0012<fef|g.Z%g\u001d>\f5\r\\%t\r>,h\u000e\u001a)s_BDaaN\u0006!\u0002\u0013Q\u0012\u0001I!mY><XI^3ss>tW-\u00134O_\u0006\u001bG.S:G_VtG\r\u0015:pa\u00022A!O\u0006Au\tia+\u001a:tS>tW\rZ!dYN\u001cB\u0001\u000f\b<}A\u0011q\u0002P\u0005\u0003{A\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0010\u007f%\u0011\u0001\t\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0005b\u0012)\u001a!C\u0001\u0007\u0006!\u0011m\u00197t+\u0005!\u0005cA#I\u0017:\u0011qBR\u0005\u0003\u000fB\ta\u0001\u0015:fI\u00164\u0017BA%K\u0005\r\u0019V\r\u001e\u0006\u0003\u000fB\u0001\"A\u0003'\n\u00055\u0013!aA!dY\"Aq\n\u000fB\tB\u0003%A)A\u0003bG2\u001c\b\u0005\u0003\u0005Rq\tU\r\u0011\"\u0001S\u0003%Q8NV3sg&|g.F\u0001T!\tyA+\u0003\u0002V!\t\u0019\u0011J\u001c;\t\u0011]C$\u0011#Q\u0001\nM\u000b!B_6WKJ\u001c\u0018n\u001c8!\u0011\u0015)\u0002\b\"\u0001Z)\rQF,\u0018\t\u00037bj\u0011a\u0003\u0005\u0006\u0005b\u0003\r\u0001\u0012\u0005\u0006#b\u0003\ra\u0015\u0005\u0006?b\"\t\u0001Y\u0001\u0007KbL7\u000f^:\u0016\u0003\u0005\u0004\"a\u00042\n\u0005\r\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\bKb\n\t\u0011\"\u0001g\u0003\u0011\u0019w\u000e]=\u0015\u0007i;\u0007\u000eC\u0004CIB\u0005\t\u0019\u0001#\t\u000fE#\u0007\u0013!a\u0001'\"9!\u000eOI\u0001\n\u0003Y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002Y*\u0012A)\\\u0016\u0002]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001d\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002va\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f]D\u0014\u0013!C\u0001q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#A=+\u0005Mk\u0007bB>9\u0003\u0003%\t%G\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u000fuD\u0014\u0011!C\u0001%\u0006a\u0001O]8ek\u000e$\u0018I]5us\"Aq\u0010OA\u0001\n\u0003\t\t!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004\u001f\u0005\u0015\u0011bAA\u0004!\t\u0019\u0011I\\=\t\u0011\u0005-a0!AA\u0002M\u000b1\u0001\u001f\u00132\u0011%\ty\u0001OA\u0001\n\u0003\n\t\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005m\u00111A\u0007\u0003\u0003/Q1!!\u0007\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\t9B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\t\u0003OA\u0001\n\u0003\t\u0019#\u0001\u0005dC:,\u0015/^1m)\r\t\u0017Q\u0005\u0005\u000b\u0003\u0017\ty\"!AA\u0002\u0005\r\u0001\"CA\u0015q\u0005\u0005I\u0011IA\u0016\u0003!A\u0017m\u001d5D_\u0012,G#A*\t\u0013\u0005=\u0002(!A\u0005B\u0005E\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003iA\u0011\"!\u000e9\u0003\u0003%\t%a\u000e\u0002\r\u0015\fX/\u00197t)\r\t\u0017\u0011\b\u0005\u000b\u0003\u0017\t\u0019$!AA\u0002\u0005\rq!CA\u001f\u0017\u0005\u0005\t\u0012AA \u000351VM]:j_:,G-Q2mgB\u00191,!\u0011\u0007\u0011eZ\u0011\u0011!E\u0001\u0003\u0007\u001aR!!\u0011\u0002Fy\u0002r!a\u0012\u0002N\u0011\u001b&,\u0004\u0002\u0002J)\u0019\u00111\n\t\u0002\u000fI,h\u000e^5nK&!\u0011qJA%\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b+\u0005\u0005C\u0011AA*)\t\ty\u0004\u0003\u0006\u00020\u0005\u0005\u0013\u0011!C#\u0003cA!\"!\u0017\u0002B\u0005\u0005I\u0011QA.\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Q\u0016QLA0\u0011\u0019\u0011\u0015q\u000ba\u0001\t\"1\u0011+a\u0016A\u0002MC!\"a\u0019\u0002B\u0005\u0005I\u0011QA3\u0003\u001d)h.\u00199qYf$B!a\u001a\u0002tA)q\"!\u001b\u0002n%\u0019\u00111\u000e\t\u0003\r=\u0003H/[8o!\u0015y\u0011q\u000e#T\u0013\r\t\t\b\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005U\u0014\u0011MA\u0001\u0002\u0004Q\u0016a\u0001=%a!Q\u0011\u0011PA!\u0003\u0003%I!a\u001f\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003{\u00022aGA@\u0013\r\t\t\t\b\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005\u00155B1A\u0005\u0002\u0005\u001d\u0015A\u0002(p\u0003\u000ed7/F\u0001[\u0011\u001d\tYi\u0003Q\u0001\ni\u000bqAT8BG2\u001c\bEB\u0004\u0002\u0010.\u0001!!!%\u0003\u001d\t\u000b7/Z!vi\"|'/\u001b>feN!\u0011QRAJ!\u0011\t)*a'\u000e\u0005\u0005]%bAAM\t\u0005Q\u0011-\u001e;i_JL'0\u001a:\n\t\u0005u\u0015q\u0013\u0002\u000e\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\t\u000fU\ti\t\"\u0001\u0002\"R\u0011\u00111\u0015\t\u00047\u00065\u0005\u0002CAT\u0003\u001b#\t%!+\u0002\u001f1|w-Q;eSRlUm]:bO\u0016$\u0002\"a+\u00022\u00065\u0017q\u001b\t\u0004\u001f\u00055\u0016bAAX!\t!QK\\5u\u0011!\t\u0019,!*A\u0002\u0005U\u0016A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0003o\u000bI-\u0004\u0002\u0002:*!\u0011\u0011TA^\u0015\u0011\ti,a0\u0002\rM,'O^3s\u0015\r9\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\f1a\u001c:h\u0013\u0011\tY-!/\u00035\u0005+H\u000f[8sSj\f'\r\\3SKF,Xm\u001d;D_:$X\r\u001f;\t\u0011\u0005=\u0017Q\u0015a\u0001\u0003#\fa!Y2uS>t\u0007\u0003BA\\\u0003'LA!!6\u0002:\n1\u0011i\u0019;j_:Dq!!7\u0002&\u0002\u0007\u0011-\u0001\u0006bkRDwN]5{K\u0012DsaCAo\u0003G\f9\u000fE\u0002\u0010\u0003?L1!!9\u0011\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003K\f1&V:fA-\fgm[1/g\u0016\u001cWO]5us:\nW\u000f\u001e5pe&TXM\u001d\u0018BG2\fU\u000f\u001e5pe&TXM]\u0011\u0003\u0003S\f\u0011bU5oG\u0016\u0004#G\f\u001b)\u000f-\ti.a9\u0002h\":\u0001!!8\u0002d\u0006\u001dh!\u0002\u0007\u0003\u0001\u0005E8\u0003CAx\u0003{\n\u00190!?\u0011\u0007)\t)0C\u0002\u0002x\n\u0011!\"Q;uQ>\u0014\u0018N_3s!\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u0000\r\u0005)Q\u000f^5mg&!!1AA\u007f\u0005\u001daunZ4j]\u001eDq!FAx\t\u0003\u00119\u0001\u0006\u0002\u0003\nA\u0019!\"a<\t\u0015\t5\u0011q\u001eb\u0001\n\u0013\u0011y!A\u0007bG2\fU\u000f\u001e5pe&TXM]\u000b\u0003\u0005#\u0001BAa\u0005\u0002\u000e:\u0019!Q\u0003\u0001\u000f\t\t]!Q\u0005\b\u0005\u00053\u0011\u0019C\u0004\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\r\u0011y\u0002C\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!!\u0002\u0004\n\u0005\r!\u0001\"\u0003B\u0015\u0003_\u0004\u000b\u0011\u0002B\t\u00039\t7\r\\!vi\"|'/\u001b>fe\u0002B!B!\f\u0002p\u0002\u0007I\u0011\u0003\u0002S\u0003Ai\u0017\r_+qI\u0006$XMU3ue&,7\u000fC\u0006\u00032\u0005=\b\u0019!C\t\u0005\tM\u0012\u0001F7bqV\u0003H-\u0019;f%\u0016$(/[3t?\u0012*\u0017\u000f\u0006\u0003\u0002,\nU\u0002\"CA\u0006\u0005_\t\t\u00111\u0001T\u0011!\u0011I$a<!B\u0013\u0019\u0016!E7bqV\u0003H-\u0019;f%\u0016$(/[3tA!A!QHAx\t\u0003\u0012y$A\u0005d_:4\u0017nZ;sKR!\u00111\u0016B!\u0011!\u0011\u0019Ea\u000fA\u0002\t\u0015\u0013a\u00036bm\u0006\u001cuN\u001c4jON\u0004DAa\u0012\u0003\\AA!\u0011\nB(\u0005'\u00129&\u0004\u0002\u0003L)\u0019!Q\n\u0010\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005#\u0012YEA\u0002NCB\u00042!\u0012B+\u0013\t\t#\n\u0005\u0003\u0003Z\tmC\u0002\u0001\u0003\r\u0005;\u0012\t%!A\u0001\u0002\u000b\u0005!q\f\u0002\u0004?\u0012\n\u0014\u0003\u0002B1\u0003\u0007\u00012a\u0004B2\u0013\r\u0011)\u0007\u0005\u0002\b\u001d>$\b.\u001b8h\u0011!\u0011I'a<\u0005B\t-\u0014!C1vi\"|'/\u001b>f)\u001d\t'Q\u000eBD\u0005#C\u0001Ba\u001c\u0003h\u0001\u0007!\u0011O\u0001\bg\u0016\u001c8/[8o!\u0011\u0011\u0019H!!\u000f\t\tU$1\u0010\b\u0005\u00053\u00119(C\u0002\u0003z\u0019\tqA\\3uo>\u00148.\u0003\u0003\u0003~\t}\u0014A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0004\u0005s2\u0011\u0002\u0002BB\u0005\u000b\u0013qaU3tg&|gN\u0003\u0003\u0003~\t}\u0004\u0002\u0003BE\u0005O\u0002\rAa#\u0002\u0013=\u0004XM]1uS>t\u0007c\u0001\u0006\u0003\u000e&\u0019!q\u0012\u0002\u0003\u0013=\u0003XM]1uS>t\u0007\u0002\u0003BJ\u0005O\u0002\rA!&\u0002\u0011I,7o\\;sG\u0016\u00042A\u0003BL\u0013\r\u0011IJ\u0001\u0002\t%\u0016\u001cx.\u001e:dK\"A!QTAx\t\u0003\u0011y*A\u0006jgN+\b/\u001a:Vg\u0016\u0014H#C1\u0003\"\n\r&Q\u0015B]\u0011!\u0011IIa'A\u0002\t-\u0005\u0002\u0003BJ\u00057\u0003\rA!&\t\u0011\t\u001d&1\u0014a\u0001\u0005S\u000b\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\t\t-&QW\u0007\u0003\u0005[S1a\u0001BX\u0015\r)!\u0011\u0017\u0006\u0005\u0005g\u000by,\u0001\u0004d_6lwN\\\u0005\u0005\u0005o\u0013iK\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u0011\tm&1\u0014a\u0001\u0005'\nA\u0001[8ti\"A!qXAx\t\u0003\u0012\t-A\u0004bI\u0012\f5\r\\:\u0015\r\u0005-&1\u0019Bc\u0011\u0019\u0011%Q\u0018a\u0001\t\"A!1\u0013B_\u0001\u0004\u0011)\n\u0003\u0005\u0003J\u0006=H\u0011\tBf\u0003)\u0011X-\\8wK\u0006\u001bGn\u001d\u000b\u0006C\n5'\u0011\u001b\u0005\b\u0005\u001f\u00149\r1\u0001E\u0003=\t7\r\\:U_\n,'+Z7pm\u0016$\u0007\u0002\u0003BJ\u0005\u000f\u0004\rA!&\t\u0011\t%\u0017q\u001eC!\u0005+$2!\u0019Bl\u0011!\u0011\u0019Ja5A\u0002\tU\u0005\u0002\u0003Bn\u0003_$\tE!8\u0002\u000f\u001d,G/Q2mgR\u0019AIa8\t\u0011\tM%\u0011\u001ca\u0001\u0005+C\u0001Ba7\u0002p\u0012\u0005#1\u001d\u000b\u0005\u0005K\u0014I\u000f\u0005\u0004F\u0005O\u0014)\nR\u0005\u0004\u0005#R\u0005\u0002\u0003BT\u0005C\u0004\rA!+\t\u0011\t5\u0018q\u001eC\u0001\u0005_\fqbZ3u\u001b\u0006$8\r[5oO\u0006\u001bGn\u001d\u000b\u0006\t\nE(1 \u0005\t\u0005g\u0014Y\u000f1\u0001\u0003v\u0006a!/Z:pkJ\u001cW\rV=qKB\u0019!Ba>\n\u0007\te(A\u0001\u0007SKN|WO]2f)f\u0004X\r\u0003\u0005\u0003~\n-\b\u0019\u0001B*\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011!\u0011Y.a<\u0005B\r\u0005AC\u0001Bs\u0011!\u0019)!a<\u0005\u0002\r\u001d\u0011!B2m_N,GCAAV\u0011!\u0019Y!a<\u0005\n\r5\u0011AC2sK\u0006$X-Q2mgR!\u00111VB\b\u0011!\u0019\tb!\u0003A\u0002\rM\u0011\u0001\u00032j]\u0012LgnZ:\u0011\t\u0015C5Q\u0003\t\u0005\u0007/\u0019i\"\u0004\u0002\u0004\u001a)!11\u0004BY\u0003\r\t7\r\\\u0005\u0005\u0007?\u0019IB\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eD\u0001ba\t\u0002p\u0012%1QE\u0001\u000bI\u0016dW\r^3BG2\u001cHcA1\u0004(!A1\u0011FB\u0011\u0001\u0004\u0019Y#A\u0004gS2$XM]:\u0011\t\u0015C5Q\u0006\t\u0005\u0007/\u0019y#\u0003\u0003\u00042\re!\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0011\u001d\u0011\u0015q\u001eC\u0005\u0007k!BA!:\u00048!A1\u0011HB\u001a\u0001\u0004\u0019i#\u0001\u0004gS2$XM\u001d\u0005\t\u0007{\ty\u000f\"\u0003\u0004@\u0005qA\u000f\u001b:po\u0016C8-\u001a9uS>tG\u0003BAV\u0007\u0003B\u0001ba\u0011\u0004<\u0001\u00071QI\u0001\u0002KB!1qIB'\u001b\t\u0019IE\u0003\u0003\u0004L\tE\u0016AB3se>\u00148/\u0003\u0003\u0004P\r%#\u0001D!qS\u0016C8-\u001a9uS>t\u0007\u0006CAx\u0003;\f\u0019/a:")
public class SimpleAclAuthorizer
implements Authorizer,
Logging {
    private final BaseAuthorizer aclAuthorizer;
    private int maxUpdateRetries;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static VersionedAcls NoAcls() {
        return SimpleAclAuthorizer$.MODULE$.NoAcls();
    }

    public static String AllowEveryoneIfNoAclIsFoundProp() {
        return SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp();
    }

    public static String SuperUsersProp() {
        return SimpleAclAuthorizer$.MODULE$.SuperUsersProp();
    }

    public static String ZkMaxInFlightRequests() {
        return SimpleAclAuthorizer$.MODULE$.ZkMaxInFlightRequests();
    }

    public static String ZkSessionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp();
    }

    public static String ZkConnectionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp();
    }

    public static String ZkUrlProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkUrlProp();
    }

    private Logger logger$lzycompute() {
        SimpleAclAuthorizer simpleAclAuthorizer = this;
        synchronized (simpleAclAuthorizer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private BaseAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    public int maxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    public void maxUpdateRetries_$eq(int x$1) {
        this.maxUpdateRetries = x$1;
    }

    public void configure(Map<String, ?> javaConfigs) {
        this.aclAuthorizer().configure(javaConfigs);
    }

    @Override
    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        AuthorizableRequestContext requestContext = AuthorizerUtils$.MODULE$.sessionToRequestContext(session);
        Action action = new Action(operation.toJava(), resource.toPattern(), 1, true, true);
        Object object = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().authorize(requestContext, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    public boolean isSuperUser(Operation operation, Resource resource, KafkaPrincipal principal, String host) {
        return this.aclAuthorizer().isSuperUser(principal);
    }

    @Override
    public void addAcls(scala.collection.immutable.Set<Acl> acls2, Resource resource) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        if (acls2 != null && acls2.nonEmpty()) {
            scala.collection.immutable.Set bindings = (scala.collection.immutable.Set)acls2.map((Function1)new Serializable(this, resource){
                public static final long serialVersionUID = 0L;
                private final Resource resource$2;

                public final AclBinding apply(Acl acl) {
                    return AuthorizerUtils$.MODULE$.convertToAclBinding(this.resource$2, acl);
                }
                {
                    this.resource$2 = resource$2;
                }
            }, Set$.MODULE$.canBuildFrom());
            this.createAcls((scala.collection.immutable.Set<AclBinding>)bindings);
        }
    }

    @Override
    public boolean removeAcls(scala.collection.immutable.Set<Acl> aclsTobeRemoved, Resource resource) {
        scala.collection.immutable.Set filters = (scala.collection.immutable.Set)aclsTobeRemoved.map((Function1)new Serializable(this, resource){
            public static final long serialVersionUID = 0L;
            private final Resource resource$3;

            public final AclBindingFilter apply(Acl acl) {
                return new AclBindingFilter(this.resource$3.toPattern().toFilter(), AuthorizerUtils$.MODULE$.convertToAccessControlEntry(acl).toFilter());
            }
            {
                this.resource$3 = resource$3;
            }
        }, Set$.MODULE$.canBuildFrom());
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)filters);
    }

    @Override
    public boolean removeAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filter}))));
    }

    @Override
    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return (scala.collection.immutable.Set)this.acls(filter).getOrElse((Object)resource, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Acl> apply() {
                return Predef$.MODULE$.Set().empty();
            }
        });
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return this.acls(filter);
    }

    public scala.collection.immutable.Set<Acl> getMatchingAcls(ResourceType resourceType, String resourceName) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resourceType.toJava(), resourceName, PatternType.MATCH), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)this.acls(filter).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Acl> apply(Tuple2<Resource, scala.collection.immutable.Set<Acl>> x$1) {
                return (scala.collection.immutable.Set)x$1._2();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        return this.acls(AclBindingFilter.ANY);
    }

    @Override
    public void close() {
        this.aclAuthorizer().close();
    }

    private void createAcls(scala.collection.immutable.Set<AclBinding> bindings) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().createAcls(null, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclCreateResult apply(CompletionStage x$2) {
                return (AclCreateResult)x$2.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizer $outer;

            public final void apply(AclCreateResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createAcls$1 $outer;

                    public final void apply(ApiException e) {
                        this.$outer.kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizer$$throwException(e);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private boolean deleteAcls(scala.collection.immutable.Set<AclBindingFilter> filters) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls(null, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters.toList()).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclDeleteResult apply(CompletionStage x$3) {
                return (AclDeleteResult)x$3.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizer $outer;

            public final void apply(AclDeleteResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteAcls$1 $outer;

                    public final void apply(ApiException e) {
                        this.$outer.kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizer$$throwException(e);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((IterableLike)results.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<AclDeleteResult.AclBindingDeleteResult> apply(AclDeleteResult x$4) {
                return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$4.aclBindingDeleteResults()).asScala();
            }
        }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AclDeleteResult.AclBindingDeleteResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply(ApiException e) {
                        throw e;
                    }
                });
            }
        });
        return results.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AclDeleteResult r) {
                return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(r.aclBindingDeleteResults()).asScala()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AclDeleteResult.AclBindingDeleteResult d) {
                        return !d.exception().isPresent();
                    }
                });
            }
        });
    }

    private scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> acls(AclBindingFilter filter) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(filter)).asScala()).foreach((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map result$1;

            public final boolean apply(AclBinding binding) {
                Resource resource = AuthorizerUtils$.MODULE$.convertToResource(binding.pattern());
                Acl acl = AuthorizerUtils$.MODULE$.convertToAcl(binding.entry());
                return ((SetLike)this.result$1.getOrElseUpdate((Object)resource, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Acl> apply() {
                        return (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                })).add((Object)acl);
            }
            {
                this.result$1 = result$1;
            }
        });
        return result.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Acl> apply(Set<Acl> x$5) {
                return x$5.toSet();
            }
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public void kafka$security$auth$SimpleAclAuthorizer$$throwException(ApiException e) {
        if (e.getCause() == null) {
            throw e;
        }
        throw e.getCause();
    }

    public SimpleAclAuthorizer() {
        Logging$class.$init$(this);
        this.aclAuthorizer = new BaseAuthorizer();
        this.maxUpdateRetries = 10;
    }

    public static class VersionedAcls
    implements Product,
    Serializable {
        private final scala.collection.immutable.Set<Acl> acls;
        private final int zkVersion;

        public scala.collection.immutable.Set<Acl> acls() {
            return this.acls;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public boolean exists() {
            return this.zkVersion() != ZkVersion$.MODULE$.UnknownVersion();
        }

        public VersionedAcls copy(scala.collection.immutable.Set<Acl> acls2, int zkVersion) {
            return new VersionedAcls(acls2, zkVersion);
        }

        public scala.collection.immutable.Set<Acl> copy$default$1() {
            return this.acls();
        }

        public int copy$default$2() {
            return this.zkVersion();
        }

        public String productPrefix() {
            return "VersionedAcls";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.zkVersion());
                    break;
                }
                case 0: {
                    object = this.acls();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof VersionedAcls;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.acls()));
            n = Statics.mix((int)n, (int)this.zkVersion());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof VersionedAcls)) return false;
            boolean bl = true;
            if (!bl) return false;
            VersionedAcls versionedAcls = (VersionedAcls)x$1;
            scala.collection.immutable.Set<Acl> set = this.acls();
            scala.collection.immutable.Set<Acl> set2 = versionedAcls.acls();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (this.zkVersion() != versionedAcls.zkVersion()) return false;
            if (!versionedAcls.canEqual(this)) return false;
            return true;
        }

        public VersionedAcls(scala.collection.immutable.Set<Acl> acls2, int zkVersion) {
            this.acls = acls2;
            this.zkVersion = zkVersion;
            Product.class.$init$((Product)this);
        }
    }

    public static class BaseAuthorizer
    extends AclAuthorizer {
        @Override
        public void logAuditMessage(AuthorizableRequestContext requestContext, Action action, boolean authorized) {
            BoxedUnit boxedUnit;
            KafkaPrincipal principal = requestContext.principal();
            String host = requestContext.clientAddress().getHostAddress();
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            Resource resource = AuthorizerUtils$.MODULE$.convertToResource(action.resourcePattern());
            if (authorized) {
                BoxedUnit boxedUnit2;
                if (this.authorizerLogger().underlying().isDebugEnabled()) {
                    this.authorizerLogger().underlying().debug(this.logMessage$1(authorized, principal, host, operation, resource));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else if (this.authorizerLogger().underlying().isInfoEnabled()) {
                this.authorizerLogger().underlying().info(this.logMessage$1(authorized, principal, host, operation, resource));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        private final String logMessage$1(boolean authorized$1, KafkaPrincipal principal$1, String host$1, Operation operation$1, Resource resource$1) {
            String authResult = authorized$1 ? "Allowed" : "Denied";
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Principal = ", " is ", " Operation = ", " from host = ", " on resource = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal$1, authResult, operation$1, host$1, resource$1}));
        }
    }
}

