/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012aB2p]\u001aLwm]\u000b\u0002-A\u0019qC\u0007\u000f\u000e\u0003aQ!!\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001c1\t\u00191+Z9\u0011\u0005Ii\u0012B\u0001\u0010\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0001\u0002\u0001\u0015!\u0003\u0017\u0003!\u0019wN\u001c4jON\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%\taI\u0001\u0006i>\u0004\u0018nY\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw\r\u0003\u0004.\u0001\u0001\u0006I\u0001J\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f=\u0002!\u0019!C\u0001a\u00059!p[+uS2\u001cX#A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\"\u0011!B;uS2\u001c\u0018B\u0001\u001c4\u0005\u001dQ6.\u0016;jYNDa\u0001\u000f\u0001!\u0002\u0013\t\u0014\u0001\u0003>l+RLGn\u001d\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005YAn\\4NC:\fw-\u001a:t+\u0005a\u0004cA\f\u001b{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0004Y><\u0017B\u0001\"@\u0005)aunZ'b]\u0006<WM\u001d\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u00191|w-T1oC\u001e,'o\u001d\u0011\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u001cX#\u0001%\u0011\u0007]Q\u0012\n\u0005\u0002\u0013\u0015&\u00111J\u0001\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\r5\u0003\u0001\u0015!\u0003I\u0003Yawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYN\u0004\u0003\"B(\u0001\t\u0003\u0001\u0016\u0001\u0003;fCJ$wn\u001e8\u0015\u0003E\u0003\"!\u0003*\n\u0005MS!\u0001B+oSRD#AT+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016!\u00026v]&$(\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]/\n)\u0011I\u001a;fe\")a\f\u0001C\u0001!\u0006YC/Z:u\u0011&<\u0007nV1uKJl\u0017M]6QKJ\u001c\u0018n\u001d;f]\u000e,7+\u001b8hY\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002^AB\u0011a+Y\u0005\u0003E^\u0013A\u0001V3ti\")A\r\u0001C\u0001!\u0006qC/Z:u\u0011&<\u0007nV1uKJl\u0017M]6QKJ\u001c\u0018n\u001d;f]\u000e,W*\u001e7uSBdW\rU1si&$\u0018n\u001c8tQ\t\u0019\u0007\rC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0004io64uN\u001d\u000b\u0005S2\f\b\u0010\u0005\u0002\nU&\u00111N\u0003\u0002\u0005\u0019>tw\rC\u0003nM\u0002\u0007a.\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005Iy\u0017B\u00019\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQA\t4A\u0002I\u0004\"a\u001d<\u000f\u0005%!\u0018BA;\u000b\u0003\u0019\u0001&/\u001a3fM&\u00111f\u001e\u0006\u0003k*AQ!\u001f4A\u0002i\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0005%Y\u0018B\u0001?\u000b\u0005\rIe\u000e\u001e")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties props) {
            return KafkaConfig$.MODULE$.fromProps(props);
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final ZkUtils zkUtils = (ZkUtils)EasyMock.createMock(ZkUtils.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LogManager apply(KafkaConfig config) {
            Seq x$2 = (Seq)config.logDirs().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final File apply(String x$1) {
                    return new File(x$1);
                }
            }, Seq$.MODULE$.canBuildFrom());
            CleanerConfig x$3 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
            LogConfig x$4 = TestUtils$.MODULE$.createLogManager$default$2();
            MockTime x$5 = TestUtils$.MODULE$.createLogManager$default$4();
            return TestUtils$.MODULE$.createLogManager((Seq<File>)x$2, x$4, x$3, x$5);
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LogDirFailureChannel apply(KafkaConfig config) {
            return new LogDirFailureChannel(config.logDirs().size());
        }
    }, Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogManager manager) {
                manager.liveLogDirs().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File dir) {
                        Utils.delete((File)dir);
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkUtils(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "").follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.getOrCreatePartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$6 = new TopicPartition(this.topic(), 0);
            LogConfig x$7 = LogConfig$.MODULE$.apply();
            boolean x$8 = qual$1.getOrCreateLog$default$3();
            Log log0 = qual$1.getOrCreateLog(x$6, x$7, x$8);
            Replica leaderReplicaPartition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), tp0, (Time)time, 0L, (Option)new Some((Object)log0));
            partition0.addReplicaIfNotExists(leaderReplicaPartition0);
            Replica followerReplicaPartition0 = new Replica(((KafkaConfig)this.configs().last()).brokerId(), tp0, (Time)time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            partition0.addReplicaIfNotExists(followerReplicaPartition0);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            ((Replica)partition0.getReplica(partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkUtils()});
        }
        catch (Throwable throwable) {
            void var1_1;
            void var2_2;
            void var4_4;
            var4_4.shutdown(false);
            var2_2.close();
            var1_1.shutdown();
            throw throwable;
        }
        replicaManager.shutdown(false);
        metrics.close();
        scheduler.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkUtils(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "").follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.getOrCreatePartition(t1p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            TopicPartition x$9 = t1p0;
            LogConfig x$10 = LogConfig$.MODULE$.apply();
            boolean x$11 = qual$2.getOrCreateLog$default$3();
            Log topic1Log0 = qual$2.getOrCreateLog(x$9, x$10, x$11);
            Replica leaderReplicaTopic1Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t1p0, (Time)time, 0L, (Option)new Some((Object)topic1Log0));
            topic1Partition0.addReplicaIfNotExists(leaderReplicaTopic1Partition0);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset(), (long)topic1Partition0Hw);
            ((Replica)topic1Partition0.getReplica(topic1Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.getOrCreatePartition(t2p0);
            LogManager qual$3 = (LogManager)this.logManagers().head();
            TopicPartition x$12 = t2p0;
            LogConfig x$13 = LogConfig$.MODULE$.apply();
            boolean x$14 = qual$3.getOrCreateLog$default$3();
            Log topic2Log0 = qual$3.getOrCreateLog(x$12, x$13, x$14);
            Replica leaderReplicaTopic2Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t2p0, (Time)time, 0L, (Option)new Some((Object)topic2Log0));
            topic2Partition0.addReplicaIfNotExists(leaderReplicaTopic2Partition0);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset(), (long)topic2Partition0Hw);
            ((Replica)topic2Partition0.getReplica(topic2Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)15L, (long)leaderReplicaTopic2Partition0.highWatermark().messageOffset());
            ((Replica)topic1Partition0.getReplica(topic1Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)10L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkUtils()});
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            void var6_6;
            var6_6.shutdown(false);
            var4_4.close();
            var3_3.shutdown();
            throw throwable;
        }
        replicaManager.shutdown(false);
        metrics.close();
        scheduler.shutdown();
    }

    public long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

