/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.log.BrokerCompressionTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001\u001d\u0011QC\u0011:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016D\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0013[\u0016\u001c8/Y4f\u0007>l\u0007O]3tg&|g\u000e\u0005\u0002\u001679\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\u00051\u0001K]3eK\u001aL!\u0001H\u000f\u0003\rM#(/\u001b8h\u0015\tQr\u0003\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003\u0015\u0003E\u0011'o\\6fe\u000e{W\u000e\u001d:fgNLwN\u001c\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r*c\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u0014A\u0001\u0007A\u0003C\u0003 A\u0001\u0007A\u0003C\u0004)\u0001\t\u0007I\u0011A\u0015\u0002\rQl\u0007\u000fR5s+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\tIwNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#\u0001\u0002$jY\u0016Daa\r\u0001!\u0002\u0013Q\u0013a\u0002;na\u0012K'\u000f\t\u0005\bk\u0001\u0011\r\u0011\"\u0001*\u0003\u0019awn\u001a#je\"1q\u0007\u0001Q\u0001\n)\nq\u0001\\8h\t&\u0014\b\u0005C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\u0002\tQLW.Z\u000b\u0002wA\u0011AhP\u0007\u0002{)\u0011a\bB\u0001\u0006kRLGn]\u0005\u0003\u0001v\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001e\u0002\u000bQLW.\u001a\u0011\t\u000f\u0011\u0003!\u0019!C\u0001\u000b\u0006IAn\\4D_:4\u0017nZ\u000b\u0002\rB\u0011AeR\u0005\u0003\u0011\n\u0011\u0011\u0002T8h\u0007>tg-[4\t\r)\u0003\u0001\u0015!\u0003G\u0003)awnZ\"p]\u001aLw\r\t\u0005\u0006\u0019\u0002!\t!T\u0001\ti\u0016\f'\u000fR8x]R\ta\n\u0005\u0002\u0017\u001f&\u0011\u0001k\u0006\u0002\u0005+:LG\u000f\u000b\u0002L%B\u00111+V\u0007\u0002)*\u00111BD\u0005\u0003-R\u0013Q!\u00114uKJDQ\u0001\u0017\u0001\u0005\u00025\u000b\u0011\u0004^3ti\n\u0013xn[3s'&$WmQ8naJ,7o]5p]\"\u0012qK\u0017\t\u0003'nK!\u0001\u0018+\u0003\tQ+7\u000f\u001e\u0015\u0005\u0001y#W\r\u0005\u0002`E6\t\u0001M\u0003\u0002b)\u00061!/\u001e8oKJL!a\u00191\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\na\r\u0005\u0002hU6\t\u0001N\u0003\u0002j)\u00069!/\u001e8oKJ\u001c\u0018BA6i\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e)QN\u0001E\u0001]\u0006)\"I]8lKJ\u001cu.\u001c9sKN\u001c\u0018n\u001c8UKN$\bC\u0001\u0013p\r\u0015\t!\u0001#\u0001q'\ry\u0017\u000f\u001e\t\u0003-IL!a]\f\u0003\r\u0005s\u0017PU3g!\t1R/\u0003\u0002w/\ta1+\u001a:jC2L'0\u00192mK\")\u0011e\u001cC\u0001qR\ta\u000eC\u0003{_\u0012\u000510\u0001\u0006qCJ\fW.\u001a;feN,\u0012\u0001 \t\u0006{\u0006\u0005\u0011QA\u0007\u0002}*\u0011qPL\u0001\u0005kRLG.C\u0002\u0002\u0004y\u0014!bQ8mY\u0016\u001cG/[8o!\u00111\u0012q\u0001\u000b\n\u0007\u0005%qCA\u0003BeJ\f\u0017\u0010K\u0002z\u0003\u001b\u0001B!a\u0004\u0002(9!\u0011\u0011CA\u0012\u001d\u0011\t\u0019\"!\t\u000f\t\u0005U\u0011q\u0004\b\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0006\u000f\u0013\tIG+C\u0002\u0002&!\fQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BA\u0015\u0003W\u0011!\u0002U1sC6,G/\u001a:t\u0015\r\t)\u0003\u001b\u0005\n\u0003_y\u0017\u0011!C\u0005\u0003c\t1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0007\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0018\u0002\t1\fgnZ\u0005\u0005\u0003{\t9D\u0001\u0004PE*,7\r\u001e")
public class BrokerCompressionTest
extends JUnitSuite {
    private final String messageCompression;
    private final String brokerCompression;
    private final File tmpDir;
    private final File logDir;
    private final MockTime time;
    private final LogConfig logConfig;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBrokerSideCompression() {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(this.messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), this.brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps);
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log2 = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.forId((int)messageCompressionCode.codec()), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log2.appendAsLeader$default$3());
        if (this.brokerCompression.equals("producer")) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Compression at offset 0 should produce ").append((Object)messageCompressionCode.name()).toString(), (long)messageCompressionCode.codec(), (long)this.readBatch$1((int)0, (Log)log2).compressionType().id);
        } else {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(this.brokerCompression);
            Assert.assertEquals((String)new StringBuilder().append((Object)"Compression at offset 0 should produce ").append((Object)brokerCompressionCode.name()).toString(), (long)brokerCompressionCode.codec(), (long)this.readBatch$1((int)0, (Log)log2).compressionType().id);
        }
    }

    private final RecordBatch readBatch$1(int offset, Log log$1) {
        return (RecordBatch)log$1.readUncommitted((long)offset, 4096, log$1.readUncommitted$default$3(), log$1.readUncommitted$default$4()).records().batches().iterator().next();
    }

    public BrokerCompressionTest(String messageCompression, String brokerCompression) {
        this.messageCompression = messageCompression;
        this.brokerCompression = brokerCompression;
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.time = new MockTime(0L, 0L);
        this.logConfig = LogConfig$.MODULE$.apply();
    }
}

