/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaId;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=c!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0007\u0002I\tQ\"^:feB\u0013\u0018N\\2ja\u0006dW#A\n\u0011\u0005QQbBA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001c9\t11\u000b\u001e:j]\u001eT!!\u0007\f\t\u000by\u0001a\u0011A\u0010\u0002\u001fA\u0014x\u000eZ;dKJ\fVo\u001c;b\u0013\u0012,\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0011\taa]3sm\u0016\u0014\u0018BA\u0013#\u0005\u001d\tVo\u001c;b\u0013\u0012DQa\n\u0001\u0007\u0002}\tqbY8ogVlWM])v_R\f\u0017\n\u001a\u0005\u0006S\u00011\tAK\u0001\u000f_Z,'O]5eKF+x\u000e^1t)\u0011YcfM\u001b\u0011\u0005Ua\u0013BA\u0017\u0017\u0005\u0011)f.\u001b;\t\u000b=B\u0003\u0019\u0001\u0019\u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b!\t)\u0012'\u0003\u00023-\t!Aj\u001c8h\u0011\u0015!\u0004\u00061\u00011\u00035\u0019wN\\:v[\u0016\u0014\u0018+^8uC\")a\u0007\u000ba\u0001o\u0005a!/Z9vKN$\u0018+^8uCB\u0011Q\u0003O\u0005\u0003sY\u0011a\u0001R8vE2,\u0007\"B\u001e\u0001\r\u0003a\u0014\u0001\u0006:f[>4X-U;pi\u0006|e/\u001a:sS\u0012,7\u000fF\u0001,\u0011\u001dq\u0004A1A\u0005B}\n1b]3sm\u0016\u00148i\\;oiV\t\u0001\t\u0005\u0002\u0016\u0003&\u0011!I\u0006\u0002\u0004\u0013:$\bB\u0002#\u0001A\u0003%\u0001)\u0001\u0007tKJ4XM]\"pk:$\b\u0005C\u0004G\u0001\t\u0007I\u0011A \u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u\u0011\u0019A\u0005\u0001)A\u0005\u0001\u0006q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0003b\u0002&\u0001\u0005\u0004%\taP\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r1\u0003\u0001\u0015!\u0003A\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002BqA\u0014\u0001C\u0002\u0013%q(\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,\u0007B\u0002)\u0001A\u0003%\u0001)A\nqe>$WoY3s\u0005V4g-\u001a:TSj,\u0007\u0005C\u0003S\u0001\u0011E1+\u0001\tqe>$WoY3s\u00072LWM\u001c;JIV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006!A.\u00198h\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0007,\t\u000bq\u0003A\u0011C*\u0002!\r|gn];nKJ\u001cE.[3oi&#\u0007b\u00020\u0001\u0005\u0004%\taP\u0001\u0015I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1\t\r\u0001\u0004\u0001\u0015!\u0003A\u0003U!WMZ1vYR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\u0002BqA\u0019\u0001C\u0002\u0013\u0005q(\u0001\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3s#V|G/\u0019\u0005\u0007I\u0002\u0001\u000b\u0011\u0002!\u0002+\u0011,g-Y;mi\u000e{gn];nKJ\fVo\u001c;bA!9a\r\u0001b\u0001\n\u0003y\u0014a\u00053fM\u0006,H\u000e\u001e*fcV,7\u000f^)v_R\f\u0007B\u00025\u0001A\u0003%\u0001)\u0001\u000beK\u001a\fW\u000f\u001c;SKF,Xm\u001d;Rk>$\u0018\r\t\u0005\bU\u0002\u0001\r\u0011\"\u0001l\u0003)aW-\u00193fe:{G-Z\u000b\u0002YB\u0011\u0011%\\\u0005\u0003]\n\u00121bS1gW\u0006\u001cVM\u001d<fe\"9\u0001\u000f\u0001a\u0001\n\u0003\t\u0018A\u00047fC\u0012,'OT8eK~#S-\u001d\u000b\u0003WIDqa]8\u0002\u0002\u0003\u0007A.A\u0002yIEBa!\u001e\u0001!B\u0013a\u0017a\u00037fC\u0012,'OT8eK\u0002Bqa\u001e\u0001A\u0002\u0013\u00051.\u0001\u0007g_2dwn^3s\u001d>$W\rC\u0004z\u0001\u0001\u0007I\u0011\u0001>\u0002!\u0019|G\u000e\\8xKJtu\u000eZ3`I\u0015\fHCA\u0016|\u0011\u001d\u0019\b0!AA\u00021Da! \u0001!B\u0013a\u0017!\u00044pY2|w/\u001a:O_\u0012,\u0007\u0005C\u0004\u0000\u0001\t\u0007I\u0011B*\u0002\rQ|\u0007/[22\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nQ\u000bq\u0001^8qS\u000e\f\u0004\u0005\u0003\u0004\u0002\b\u0001!\t\u0005P\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0005\u0003\u000b\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u000b),h.\u001b;\u000b\u0005\u0005U\u0011aA8sO&!\u0011\u0011DA\b\u0005\u0019\u0011UMZ8sK\"1\u0011Q\u0004\u0001\u0005\u0002q\nQ\u0004^3tiRC'o\u001c;uY\u0016$\u0007K]8ek\u000e,'oQ8ogVlWM\u001d\u0015\u0005\u00037\t\t\u0003\u0005\u0003\u0002\u000e\u0005\r\u0012\u0002BA\u0013\u0003\u001f\u0011A\u0001V3ti\"1\u0011\u0011\u0006\u0001\u0005\u0002q\nq\u0005^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u0014xJ^3se&$W-\u00168uQJ|G\u000f\u001e7fI\"\"\u0011qEA\u0011\u0011\u0019\ty\u0003\u0001C\u0001y\u00059B/Z:u#V|G/Y(wKJ\u0014\u0018\u000eZ3EK2,G/\u001a\u0015\u0005\u0003[\t\t\u0003\u0003\u0004\u00026\u0001!\t\u0001P\u0001\u0015i\u0016\u001cH\u000f\u00165s_R$H.\u001a3SKF,Xm\u001d;)\t\u0005M\u0012\u0011\u0005\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003U\u0001(o\u001c3vG\u0016,f\u000e^5m)\"\u0014x\u000e\u001e;mK\u0012$R\u0001QA \u0003KB\u0001\"!\u0011\u0002:\u0001\u0007\u00111I\u0001\u0002aBA\u0011QIA+\u00033\nI&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003!\u0001(o\u001c3vG\u0016\u0014(\u0002BA'\u0003\u001f\nqa\u00197jK:$8OC\u0002\u0006\u0003#RA!a\u0015\u0002\u0014\u00051\u0011\r]1dQ\u0016LA!a\u0016\u0002H\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004R!FA.\u0003?J1!!\u0018\u0017\u0005\u0015\t%O]1z!\r)\u0012\u0011M\u0005\u0004\u0003G2\"\u0001\u0002\"zi\u0016Dq!a\u001a\u0002:\u0001\u0007\u0001)\u0001\u0006nCb\u0014VmY8sINDq!a\u001b\u0001\t\u0003\ti'A\u000bd_:\u001cX/\\3V]RLG\u000e\u00165s_R$H.\u001a3\u0015\u000b\u0001\u000by'! \t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003g\n\u0001bY8ogVlWM\u001d\t\t\u0003k\nI(!\u0017\u0002Z5\u0011\u0011q\u000f\u0006\u0005\u0003c\nY%\u0003\u0003\u0002|\u0005]$!D&bM.\f7i\u001c8tk6,'\u000fC\u0004\u0002h\u0005%\u0004\u0019\u0001!\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u0006\u0011r/Y5u\r>\u0014\u0018+^8uCV\u0003H-\u0019;f)\u001dY\u0013QQAD\u0003\u0013CaaLA@\u0001\u0004\u0001\u0004B\u0002\u001b\u0002\u0000\u0001\u0007\u0001\u0007\u0003\u00047\u0003\u007f\u0002\ra\u000e\u0005\b\u0003\u001b\u0003A\u0011BAH\u0003\u00012XM]5gsB\u0013x\u000eZ;dKJ$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\u0007-\n\t\n\u0003\u0005\u0002J\u0005-\u0005\u0019AAJa\u0019\t)*a'\u00020BA\u0011QIA+\u0003/\u000bi\u000b\u0005\u0003\u0002\u001a\u0006mE\u0002\u0001\u0003\r\u0003;\u000b\t*!A\u0001\u0002\u000b\u0005\u0011q\u0014\u0002\u0004?\u0012\n\u0014\u0003BAQ\u0003O\u00032!FAR\u0013\r\t)K\u0006\u0002\b\u001d>$\b.\u001b8h!\r)\u0012\u0011V\u0005\u0004\u0003W3\"aA!osB!\u0011\u0011TAX\t1\t\t,!%\u0002\u0002\u0003\u0005)\u0011AAP\u0005\ryFE\r\u0005\b\u0003k\u0003A\u0011BA\\\u0003\u00012XM]5gs\u000e{gn];nKJ$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\u000b-\nI,a3\t\u0011\u0005E\u00141\u0017a\u0001\u0003w\u0003d!!0\u0002B\u0006\u001d\u0007\u0003CA;\u0003s\ny,!2\u0011\t\u0005e\u0015\u0011\u0019\u0003\r\u0003\u0007\fI,!A\u0001\u0002\u000b\u0005\u0011q\u0014\u0002\u0004?\u0012\u001a\u0004\u0003BAM\u0003\u000f$A\"!3\u0002:\u0006\u0005\t\u0011!B\u0001\u0003?\u00131a\u0018\u00135\u0011)\ti-a-\u0011\u0002\u0003\u0007\u0011qZ\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nKB!Q#!58\u0013\r\t\u0019N\u0006\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\u0006\u0011B\u000f\u001b:piRdW-T3ue&\u001cg*Y7f)\u0019\tY.a:\u0002rB!\u0011Q\\Ar\u001b\t\tyN\u0003\u0003\u0002b\u0006=\u0013AB2p[6|g.\u0003\u0003\u0002f\u0006}'AC'fiJL7MT1nK\"A\u0011\u0011^Ak\u0001\u0004\tY/A\u0005rk>$\u0018\rV=qKB\u0019\u0011%!<\n\u0007\u0005=(EA\u0005Rk>$\u0018\rV=qK\"9\u00111_Ak\u0001\u0004\u0001\u0013aB9v_R\f\u0017\n\u001a\u0005\b\u0003o\u0004A\u0011AA}\u00039!\bN]8ui2,W*\u001a;sS\u000e$b!a?\u0003\b\t%\u0001\u0003BA\u007f\u0005\u0007i!!a@\u000b\t\t\u0005\u0011q\\\u0001\b[\u0016$(/[2t\u0013\u0011\u0011)!a@\u0003\u0017-\u000bgm[1NKR\u0014\u0018n\u0019\u0005\t\u0003S\f)\u00101\u0001\u0002l\"9\u00111_A{\u0001\u0004\u0001\u0003b\u0002B\u0007\u0001\u0011%!qB\u0001\u0017aJ|G-^2feRC'o\u001c;uY\u0016lU\r\u001e:jGV\u0011\u00111 \u0005\b\u0005'\u0001A\u0011\u0002B\b\u0003Y\u0019wN\\:v[\u0016\u0014H\u000b\u001b:piRdW-T3ue&\u001c\u0007b\u0002B\f\u0001\u0011%!qB\u0001\u001eG>t7/^7feJ+\u0017/^3tiRC'o\u001c;uY\u0016lU\r\u001e:jG\"9!1\u0004\u0001\u0005\n\t=\u0011aE3yK6\u0004HOU3rk\u0016\u001cH/T3ue&\u001c\u0007b\u0002B\u0010\u0001\u0011\u0005!\u0011E\u0001\u0010cV|G/\u0019)s_B,'\u000f^5fgRA!1\u0005B\u0018\u0005c\u0011\u0019\u0004\u0005\u0003\u0003&\t-RB\u0001B\u0014\u0015\r\u0011I\u0003W\u0001\u0005kRLG.\u0003\u0003\u0003.\t\u001d\"A\u0003)s_B,'\u000f^5fg\"1qF!\bA\u0002ABa\u0001\u000eB\u000f\u0001\u0004\u0001\u0004B\u0002\u001c\u0003\u001e\u0001\u0007q\u0007C\u0005\u00038\u0001\t\n\u0011\"\u0003\u0003:\u0005Qc/\u001a:jMf\u001cuN\\:v[\u0016\u0014H\u000b\u001b:piRdW\rV5nK6+GO]5dI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u001eU\u0011\tyM!\u0010,\u0005\t}\u0002\u0003\u0002B!\u0005\u0017j!Aa\u0011\u000b\t\t\u0015#qI\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0013\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0012\u0019EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int serverCount;
    private final int producerCount;
    private final int consumerCount;
    private final int producerBufferSize;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private final String topic1;

    public abstract String userPrincipal();

    public abstract QuotaId producerQuotaId();

    public abstract QuotaId consumerQuotaId();

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)producer, numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyProducerThrottleTimeMetric(producer);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)consumer, produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyConsumerThrottleTimeMetric(consumer, this.verifyConsumerThrottleTimeMetric$default$2());
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
        this.removeQuotaOverrides();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        ((KafkaConsumer)this.consumers().head()).seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords + produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testThrottledRequest() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(100L);
            KafkaMetric throttleMetric = this.consumerRequestThrottleMetric();
            throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.verifyConsumerThrottleTimeMetric(consumer, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)this.exemptRequestMetric());
        Assert.assertTrue((String)"Exempt requests not recorded", (this.exemptRequestMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(KafkaProducer<byte[], byte[]> p, int maxRecords) {
        void var3_3;
        int numProduced = 0;
        boolean throttled = false;
        do {
            byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)numProduced)).toString().getBytes();
            p.send(new ProducerRecord(this.topic1(), null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic1(), null, null, true)).get();
            KafkaMetric throttleMetric = this.producerThrottleMetric();
            boolean bl = throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        } while (++numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int consumeUntilThrottled(KafkaConsumer<byte[], byte[]> consumer, int maxRecords) {
        void var3_3;
        consumer.subscribe(Collections.singleton(this.topic1()));
        int numConsumed = 0;
        boolean throttled = false;
        do {
            KafkaMetric throttleMetric;
            boolean bl = throttled = (throttleMetric = this.consumerThrottleMetric()) != null && throttleMetric.value() > 0.0;
        } while ((numConsumed += consumer.poll(100L).count()) < maxRecords && !throttled);
        if (throttled && numConsumed < maxRecords) {
            int minRecords = numConsumed + 1;
            while (numConsumed < minRecords) {
                numConsumed += consumer.poll(100L).count();
            }
        }
        return (int)var3_3;
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, producerQuota, consumerQuota, requestQuota){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQuotaTest $outer;
            private final long producerQuota$1;
            private final long consumerQuota$1;
            private final double requestQuota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QuotaFactory.QuotaManagers quotaManagers = this.$outer.leaderNode().apis().quotas();
                Quota overrideProducerQuota = quotaManagers.produce().quota(this.$outer.userPrincipal(), this.$outer.producerClientId());
                Quota overrideConsumerQuota = quotaManagers.fetch().quota(this.$outer.userPrincipal(), this.$outer.consumerClientId());
                Quota overrideProducerRequestQuota = quotaManagers.request().quota(this.$outer.userPrincipal(), this.$outer.producerClientId());
                Quota overrideConsumerRequestQuota = quotaManagers.request().quota(this.$outer.userPrincipal(), this.$outer.consumerClientId());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have producer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.producerQuota$1), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have consumer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.consumerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.consumerQuota$1), (Object)overrideConsumerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.requestQuota$1), (Object)overrideProducerRequestQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.consumerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.requestQuota$1), (Object)overrideConsumerRequestQuota);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerQuota$1 = producerQuota$1;
                this.consumerQuota$1 = consumerQuota$1;
                this.requestQuota$1 = requestQuota$1;
            }
        });
    }

    private void verifyProducerThrottleTimeMetric(KafkaProducer<?, ?> producer) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId());
        Metric avgMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        Metric maxMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$1;
            private final Metric maxMetric$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.avgMetric$1.value() > 0.0 && this.maxMetric$1.value() > 0.0;
            }
            {
                this.avgMetric$1 = avgMetric$1;
                this.maxMetric$1 = maxMetric$1;
            }
        }, (Function0<String>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$1;
            private final Metric maxMetric$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.avgMetric$1.value()), BoxesRunTime.boxToDouble((double)this.maxMetric$1.value())}));
            }
            {
                this.avgMetric$1 = avgMetric$1;
                this.maxMetric$1 = maxMetric$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void verifyConsumerThrottleTimeMetric(KafkaConsumer<?, ?> consumer, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId());
        Metric avgMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        Metric maxMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$2;
            private final Metric maxMetric$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.avgMetric$2.value() > 0.0 && this.maxMetric$2.value() > 0.0;
            }
            {
                this.avgMetric$2 = avgMetric$2;
                this.maxMetric$2 = maxMetric$2;
            }
        }, (Function0<String>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$2;
            private final Metric maxMetric$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.avgMetric$2.value()), BoxesRunTime.boxToDouble((double)this.maxMetric$2.value())}));
            }
            {
                this.avgMetric$2 = avgMetric$2;
                this.maxMetric$2 = maxMetric$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        maxThrottleTime.foreach((Function1)new Serializable(this, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric maxMetric$2;

            public final void apply(double max) {
                this.apply$mcVD$sp(max);
            }

            public void apply$mcVD$sp(double max) {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum consumer throttle too high: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.maxMetric$2.value())})), (this.maxMetric$2.value() <= max ? 1 : 0) != 0);
            }
            {
                this.maxMetric$2 = maxMetric$2;
            }
        });
    }

    private Option<Object> verifyConsumerThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    private MetricName throttleMetricName(QuotaType quotaType, QuotaId quotaId) {
        return this.leaderNode().metrics().metricName("throttle-time", quotaType.toString(), "Tracking throttle-time per user/client-id", new String[]{"user", (String)quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), "client-id", (String)quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })});
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, QuotaId quotaId) {
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(this.throttleMetricName(quotaType, quotaId));
    }

    private KafkaMetric producerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerQuotaId());
    }

    private KafkaMetric consumerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric consumerRequestThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode().metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(metricName);
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        return props;
    }

    public BaseQuotaTest() {
        this.serverCount = 2;
        this.producerCount = 1;
        this.consumerCount = 1;
        this.producerBufferSize = 300000;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "0");
        this.producerConfig().setProperty("buffer.memory", ((Object)BoxesRunTime.boxToInteger((int)this.producerBufferSize())).toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.leaderNode = null;
        this.followerNode = null;
        this.topic1 = "topic-1";
    }
}

