/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentStatus;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u00055\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005\u0011)f.\u001b;\t\u000fIR\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/F\u00019!\u0011Id\bQ\"\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u00121!T1q!\tq\u0013)\u0003\u0002CA\t\u0019\u0011J\u001c;\u0011\u0007e\"\u0005)\u0003\u0002Fu\t!A*[:u\u0011\u00199\u0005\u0001)A\u0005q\u0005QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA!)\u0011\n\u0001C!\u0015\u0006AA/Z1s\t><h\u000eF\u0001.Q\tAE\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\u000b\u00053G/\u001a:\t\u000bU\u0003A\u0011\u0001&\u0002GQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5BY2\fE.\u001b<f%\u0016\u0004H.[2bg\"\u0012Ak\u0016\t\u0003\u001bbK!!\u0017(\u0003\tQ+7\u000f\u001e\u0005\u00067\u0002!\tAS\u0001+i\u0016\u001cHOU3tk6,G)\u001a7fi\u0016$v\u000e]5d/&$\bNU3d_Z,'/\u001a3G_2dwn^3sQ\tQv\u000bC\u0003_\u0001\u0011\u0005!*A\u0015uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2P]\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0003;^CQ!\u0019\u0001\u0005\u0002)\u000b!\u0006^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u0002a/\")A\r\u0001C\u0001\u0015\u0006\tC/Z:u\t\u0016dW\r^3U_BL7\rR;sS:<\u0017\t\u001a3QCJ$\u0018\u000e^5p]\"\u00121m\u0016\u0005\u0006O\u0002!\tAS\u0001\"i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0003M^CQA\u001b\u0001\u0005\u0002)\u000ba\u0004^3tiJ+7M]3bi\u0016$v\u000e]5d\u0003\u001a$XM\u001d#fY\u0016$\u0018n\u001c8)\u0005%<\u0006\"B7\u0001\t\u0003Q\u0015A\u0007;fgR$U\r\\3uK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007F\u00017X\u0011\u0015\u0001\b\u0001\"\u0001K\u0003i!Xm\u001d;EK2,G/\u001a+pa&\u001cw+\u001b;i\u00072,\u0017M\\3sQ\tyw\u000bC\u0003t\u0001\u0011\u0005!*A\u0013uKN$H)\u001a7fi\u0016$v\u000e]5d\u00032\u0014X-\u00193z\u001b\u0006\u00148.\u001a3Bg\u0012+G.\u001a;fI\"\u0012!o\u0016\u0005\u0006m\u0002!Ia^\u0001\u001aGJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\u0006\u0003\u0017q\u0006\r\u0001\"B=v\u0001\u0004Q\u0018!\u0002;pa&\u001c\u0007CA>\u007f\u001d\tqC0\u0003\u0002~A\u00051\u0001K]3eK\u001aL1a`A\u0001\u0005\u0019\u0019FO]5oO*\u0011Q\u0010\t\u0005\n\u0003\u000b)\b\u0013!a\u0001\u0003\u000f\t!\u0003Z3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIB\u0019a&!\u0003\n\u0007\u0005-\u0001EA\u0004C_>dW-\u00198\t\rY\u0004A\u0011BA\b)\u00151\u0012\u0011CA\n\u0011\u0019I\u0018Q\u0002a\u0001u\"A\u0011QCA\u0007\u0001\u0004\t9\"A\u0007ce>\\WM]\"p]\u001aLwm\u001d\t\u0005/\u0005\nI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u000f\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003%9(/\u001b;f\tV\u00048\u000f\u0006\u0005\u00020\u0005]\u00121HA !\u00119\u0012%!\r\u0011\u000b9\n\u0019\u0004\u0011!\n\u0007\u0005U\u0002E\u0001\u0004UkBdWM\r\u0005\b\u0003s\tI\u00031\u0001A\u0003\u001dqW/\\&fsNDq!!\u0010\u0002*\u0001\u0007\u0001)A\u0004ok6$U\u000f]:\t\u0011\u0005\u0005\u0013\u0011\u0006a\u0001\u0003\u0007\n1\u0001\\8h!\u0011\t)%!\u0013\u000e\u0005\u0005\u001d#bAA!\t%!\u00111JA$\u0005\raun\u001a\u0005\u0007\u0003\u001f\u0002A\u0011\u0001&\u0002-Q,7\u000f\u001e#jg\u0006\u0014G.\u001a#fY\u0016$X\rV8qS\u000eD3!!\u0014X\u0011%\t)\u0006AI\u0001\n\u0013\t9&A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e#\u0006BA\u0004\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\u0002\u0013AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower2.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$1;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((IterableLike)this.$outer.servers().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer x$1) {
                        return x$1.getLogManager().getLog(this.$outer.topicPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.follower$1 = follower$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas 0,1 have not deleted log.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().isTopicMarkedForDeletion(this.topic$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topic/test path deleted even when a follower replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        int controllerId = this.zkUtils().getController();
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, controllerId, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;
            private final Option leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$2.get()) && s.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower2.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().isTopicMarkedForDeletion(this.topic$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topic/test path deleted even when a replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        controller.startup();
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$2;
            private final Seq servers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$2) {
                        return x$2.getLogManager().getLog(this.$outer.topicPartition$2).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.servers$1 = servers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$3.get());
            }
            {
                this.leaderIdOpt$3 = leaderIdOpt$3;
            }
        })).last();
        follower2.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        Seq oldAssignedReplicas = this.zkUtils().getReplicasForPartition(topic, 0);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topicPartition)), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final TopicPartition topicPartition$2;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$3) {
                        return x$3.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), new TopicAndPartition(this.topicPartition$2), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(this.topicPartition$2)), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.newReplicas$1 = newReplicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment shouldn't complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int controllerId = this.zkUtils().getController();
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)new TopicAndPartition(topicPartition)));
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, 0);
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)servers);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$4;

            public final boolean apply(KafkaServer x$4) {
                return x$4.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$4.get());
            }
            {
                this.leaderIdOpt$4 = leaderIdOpt$4;
            }
        })).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        Seq brokers = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), AdminUtils$.MODULE$.getBrokerMetadatas$default$2(), AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        follower2.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final KafkaServer follower$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().getBrokerInfo(this.follower$2.config().brokerId()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.follower$2 = follower$2;
            }
        }, (Function0<String>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " was not removed from ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.follower$2.config().brokerId())}));
            }
            {
                this.follower$2 = follower$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, this.expectedReplicaAssignment(), brokers, 2, (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), AdminUtils$.MODULE$.addPartitions$default$7());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$2 $outer;

                    public final boolean apply(KafkaServer x$5) {
                        return x$5.getLogManager().getLog(this.$outer.newPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newPartition$1 = newPartition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, this.expectedReplicaAssignment(), AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), AdminUtils$.MODULE$.getBrokerMetadatas$default$2(), AdminUtils$.MODULE$.getBrokerMetadatas$default$3()), 2, (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), AdminUtils$.MODULE$.addPartitions$default$7());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition newPartition$2;

            public final boolean apply(KafkaServer x$6) {
                return x$6.getLogManager().getLog(this.newPartition$2).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        }));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(KafkaServer x$7) {
                        return x$7.getLogManager().getLog(this.$outer.topicPartition$3).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$3 = topicPartition$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        try {
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                public final TopicPartition topicPartition$4;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.servers().forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                        public final boolean apply(KafkaServer x$8) {
                            return x$8.getLogManager().getLog(this.$outer.topicPartition$4).isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$4 = topicPartition$4;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Replicas for topic test not created";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs));
        KafkaServer server = (KafkaServer)this.servers().head();
        Log log2 = (Log)server.logManager().getLog(topicPartition).get();
        this.writeDups(100, 3, log2);
        LogCleaner qual$1 = server.logManager().cleaner();
        TopicPartition x$12 = new TopicPartition(topicName, 0);
        long x$13 = 0L;
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, x$13, x$14);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        try {
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        brokerConfigs.foreach((Function1)new Serializable(this, deleteTopicEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean deleteTopicEnabled$1;

            public final Object apply(Properties x$9) {
                return x$9.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.deleteTopicEnabled$1)).toString());
            }
            {
                this.deleteTopicEnabled$1 = deleteTopicEnabled$1;
            }
        });
        return this.createTestTopicAndCluster(topic, brokerConfigs);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, this.expectedReplicaAssignment(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$5;
            private final Seq servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer x$10) {
                        return x$10.getLogManager().getLog(this.$outer.topicPartition$5).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$5 = topicPartition$5;
                this.servers$2 = servers$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log2) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, counter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final IntRef counter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.counter$1.elem;
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.$outer.log$1.appendAsLeader$default$3());
                        ++this.$outer.counter$1.elem;
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.counter$1 = counter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().isTopicMarkedForDeletion(this.topic$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, (Function0<String>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3}));
            }
            {
                this.topic$3 = topic$3;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$6;

            public final boolean apply(KafkaServer x$11) {
                return x$11.getLogManager().getLog(this.topicPartition$6).isDefined();
            }
            {
                this.topicPartition$6 = topicPartition$6;
            }
        }));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }
}

