/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import org.apache.kafka.common.internals.FatalExitError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000b\tI1*\u00194lCR+7\u000f\u001e\u0006\u0002\u0007\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0007!\t9!\"D\u0001\t\u0015\u0005I\u0011!B:dC2\f\u0017BA\u0006\t\u0005\u0019\te.\u001f*fM\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003!\u0001i\u0011A\u0001\u0005\u0006%\u0001!\taE\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002)A\u0011q!F\u0005\u0003-!\u0011A!\u00168ji\"\u0012\u0011\u0003\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tQA[;oSRT\u0011!H\u0001\u0004_J<\u0017BA\u0010\u001b\u0005\u0019\u0011UMZ8sK\")\u0011\u0005\u0001C\u0001'\u0005AA/Z1s\t><h\u000e\u000b\u0002!GA\u0011\u0011\u0004J\u0005\u0003Ki\u0011Q!\u00114uKJDQa\n\u0001\u0005\u0002M\t!\u0004^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sOND#AJ\u0015\u0011\u0005eQ\u0013BA\u0016\u001b\u0005\u0011!Vm\u001d;\t\u000b5\u0002A\u0011A\n\u0002OQ,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:Xe>twmU3u-\u0006dW/\u001a\u0015\u0005Y%z\u0003'\u0001\u0005fqB,7\r^3eG\u0005\t\u0004C\u0001\u001a;\u001b\u0005\u0019$B\u0001\u001b6\u0003%Ig\u000e^3s]\u0006d7O\u0003\u00027o\u000511m\\7n_:T!a\u0001\u001d\u000b\u0005eb\u0012AB1qC\u000eDW-\u0003\u0002<g\tqa)\u0019;bY\u0016C\u0018\u000e^#se>\u0014\b\"B\u001f\u0001\t\u0003\u0019\u0012!\u000b;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001c\u0018\t\u001e+iK\u0016sG\r\u000b\u0003=S=\u0002\u0004\"\u0002!\u0001\t\u0003\u0019\u0012!\n;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001cxJ\u001c7zQ\u0011y\u0014f\f\u0019\t\u000b\r\u0003A\u0011A\n\u0002[Q,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:O_:\f%oZ:BiRCWMQ3hO&tw\r\u000b\u0003CS=\u0002\u0004\"\u0002$\u0001\t\u0003\u0019\u0012!\u0006;fgR\\\u0015MZ6b'Nd\u0007+Y:to>\u0014Hm\u001d\u0015\u0003\u000b&BQ!\u0013\u0001\u0005\u0002)\u000bA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<G#A&\u0011\u00051{eBA\u0004N\u0013\tq\u0005\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\t\u0011\u0015\u0019\u0006\u0001\"\u0001U\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR\u00111*\u0016\u0005\u0006-J\u0003\raV\u0001\u0006Y&tWm\u001d\t\u0004\u000fa[\u0015BA-\t\u0005\u0015\t%O]1z\u0001")
public class KafkaTest {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int status, Option<String> x$1) {
                throw new FatalExitError(status);
            }
        });
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)1L, (long)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assert.assertEquals((long)1L, (long)config3.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config4.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsWrongSetValue() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "a=b=c"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password"})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.sslKeyPassword().toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.sslKeystorePassword().toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.sslTruststorePassword().toString());
        Assert.assertEquals((Object)"key_password", (Object)config.sslKeyPassword().value());
        Assert.assertEquals((Object)"keystore_password", (Object)config.sslKeystorePassword().value());
        Assert.assertEquals((Object)"truststore_password", (Object)config.sslTruststorePassword().value());
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    public String prepareConfig(String[] lines) {
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        FileOutputStream writer = new FileOutputStream(file);
        Predef$.MODULE$.refArrayOps((Object[])lines).foreach((Function1)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream writer$1;

            public final void apply(String l) {
                this.writer$1.write(l.getBytes());
                this.writer$1.write("\n".getBytes());
            }
            {
                this.writer$1 = writer$1;
            }
        });
        writer.close();
        return file.getAbsolutePath();
    }
}

