/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import kafka.api.ApiUtils$;
import kafka.api.FetchRequest$;
import kafka.api.PartitionFetchInfo;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.common.TopicAndPartition;
import kafka.network.RequestChannel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u0005s!B\u0001\u0003\u0011\u00039\u0011\u0001\u0004$fi\u000eD'+Z9vKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!\u0001\u0004$fi\u000eD'+Z9vKN$8cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\f\n\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001dI\u0012B1A\u0005\ni\taA]1oI>lW#A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0005yq\u0011\u0001B;uS2L!\u0001I\u000f\u0003\rI\u000bg\u000eZ8n\u0011\u0019\u0011\u0013\u0002)A\u00057\u00059!/\u00198e_6\u0004\u0003b\u0002\u0013\n\u0005\u0004%\t!J\u0001\u000f\u0007V\u0014(/\u001a8u-\u0016\u00148/[8o+\u00051\u0003CA\u0007(\u0013\tAcBA\u0003TQ>\u0014H\u000f\u0003\u0004+\u0013\u0001\u0006IAJ\u0001\u0010\u0007V\u0014(/\u001a8u-\u0016\u00148/[8oA!9A&\u0003b\u0001\n\u0003i\u0013A\u0004#fM\u0006,H\u000e^'bq^\u000b\u0017\u000e^\u000b\u0002]A\u0011QbL\u0005\u0003a9\u00111!\u00138u\u0011\u0019\u0011\u0014\u0002)A\u0005]\u0005yA)\u001a4bk2$X*\u0019=XC&$\b\u0005C\u00045\u0013\t\u0007I\u0011A\u0017\u0002\u001f\u0011+g-Y;mi6KgNQ=uKNDaAN\u0005!\u0002\u0013q\u0013\u0001\u0005#fM\u0006,H\u000e^'j]\nKH/Z:!\u0011\u001dA\u0014B1A\u0005\u00025\nq\u0002R3gCVdG/T1y\u0005f$Xm\u001d\u0005\u0007u%\u0001\u000b\u0011\u0002\u0018\u0002!\u0011+g-Y;mi6\u000b\u0007PQ=uKN\u0004\u0003b\u0002\u001f\n\u0005\u0004%\t!L\u0001\u0015\t\u00164\u0017-\u001e7u\u0007>\u0014(/\u001a7bi&|g.\u00133\t\ryJ\u0001\u0015!\u0003/\u0003U!UMZ1vYR\u001cuN\u001d:fY\u0006$\u0018n\u001c8JI\u0002BQ\u0001Q\u0005\u0005\u0002\u0005\u000b\u0001B]3bI\u001a\u0013x.\u001c\u000b\u0004\u0005\n}\u0005C\u0001\u0005D\r\u0011Q!\u0001\u0011#\u0014\t\r+\u0005J\u0005\t\u0003\u0011\u0019K!a\u0012\u0002\u0003#I+\u0017/^3ti>\u0013(+Z:q_:\u001cX\r\u0005\u0002\u000e\u0013&\u0011!J\u0004\u0002\b!J|G-^2u\u0011!a5I!f\u0001\n\u0003)\u0013!\u0003<feNLwN\\%e\u0011!q5I!E!\u0002\u00131\u0013A\u0003<feNLwN\\%eA!A\u0001k\u0011BK\u0002\u0013\u0005Q&A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\t%\u000e\u0013\t\u0012)A\u0005]\u0005q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003\u0002\u0003+D\u0005+\u0007I\u0011A+\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012,\u0012A\u0016\t\u0003/js!!\u0004-\n\u0005es\u0011A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\b\t\u0011y\u001b%\u0011#Q\u0001\nY\u000b\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u0011\u0001\u001c%Q3A\u0005\u00025\n\u0011B]3qY&\u001c\u0017-\u00133\t\u0011\t\u001c%\u0011#Q\u0001\n9\n!B]3qY&\u001c\u0017-\u00133!\u0011!!7I!f\u0001\n\u0003i\u0013aB7bq^\u000b\u0017\u000e\u001e\u0005\tM\u000e\u0013\t\u0012)A\u0005]\u0005AQ.\u0019=XC&$\b\u0005\u0003\u0005i\u0007\nU\r\u0011\"\u0001.\u0003!i\u0017N\u001c\"zi\u0016\u001c\b\u0002\u00036D\u0005#\u0005\u000b\u0011\u0002\u0018\u0002\u00135LgNQ=uKN\u0004\u0003\u0002\u00037D\u0005+\u0007I\u0011A\u0017\u0002\u00115\f\u0007PQ=uKND\u0001B\\\"\u0003\u0012\u0003\u0006IAL\u0001\n[\u0006D()\u001f;fg\u0002B\u0001\u0002]\"\u0003\u0016\u0004%\t!]\u0001\fe\u0016\fX/Z:u\u0013:4w.F\u0001s!\r\u00198P \b\u0003ift!!\u001e=\u000e\u0003YT!a\u001e\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011B\u0001>\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001`?\u0003\u0007M+\u0017O\u0003\u0002{\u001dA1Qb`A\u0002\u0003\u001fI1!!\u0001\u000f\u0005\u0019!V\u000f\u001d7feA!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0011\taaY8n[>t\u0017\u0002BA\u0007\u0003\u000f\u0011\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\rA\u0011\u0011C\u0005\u0004\u0003'\u0011!A\u0005)beRLG/[8o\r\u0016$8\r[%oM>D\u0011\"a\u0006D\u0005#\u0005\u000b\u0011\u0002:\u0002\u0019I,\u0017/^3ti&sgm\u001c\u0011\t\rY\u0019E\u0011AA\u000e)E\u0011\u0015QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121\u0006\u0005\t\u0019\u0006e\u0001\u0013!a\u0001M!A\u0001+!\u0007\u0011\u0002\u0003\u0007a\u0006\u0003\u0005U\u00033\u0001\n\u00111\u0001W\u0011!\u0001\u0017\u0011\u0004I\u0001\u0002\u0004q\u0003\u0002\u00033\u0002\u001aA\u0005\t\u0019\u0001\u0018\t\u0011!\fI\u0002%AA\u00029B\u0001\u0002\\A\r!\u0003\u0005\rA\f\u0005\u0007a\u0006e\u0001\u0019\u0001:\u0006\r\u0005=2\tBA\u0019\u00059\u0001\u0016M\u001d;ji&|g.\u00138g_N\u0004Ba]>\u00024A)Qb \u0018\u0002\u0010!Q\u0011qG\"\t\u0006\u0004%I!!\u000f\u00023I,\u0017/^3ti&sgm\\$s_V\u0004X\r\u001a\"z)>\u0004\u0018nY\u000b\u0003\u0003w\u0001Ba]>\u0002>A)Qb ,\u0002@A!\u0011\u0011IA\u0017\u001b\u0005\u0019\u0005BCA#\u0007\"\u0005\t\u0015)\u0003\u0002<\u0005Q\"/Z9vKN$\u0018J\u001c4p\u000fJ|W\u000f]3e\u0005f$v\u000e]5dA!1ac\u0011C\u0001\u0003\u0013\"RBQA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0003B\u0002)\u0002H\u0001\u0007a\u0006\u0003\u0004U\u0003\u000f\u0002\rA\u0016\u0005\u0007I\u0006\u001d\u0003\u0019\u0001\u0018\t\r!\f9\u00051\u0001/\u0011\u0019a\u0017q\ta\u0001]!9\u0001/a\u0012A\u0002\u0005]\u0003cB,\u0002Z\u0005\r\u0011qB\u0005\u0004\u00037b&aA'ba\"B\u0011qIA0\u0003K\nI\u0007E\u0002\u000e\u0003CJ1!a\u0019\u000f\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003O\nQ\u0010\u00165fA=\u0014H-\u001a:!_\u001a\u0004\u0003/\u0019:uSRLwN\\:!S:\u0004\u0003M]3rk\u0016\u001cH/\u00138g_\u0002\u0004\u0013n\u001d\u0011sK2,g/\u00198uY\u0001\u001ax\u000e\t;iSN\u00043m\u001c8tiJ,8\r^8sA%\u001c\b\u0005Z3qe\u0016\u001c\u0017\r^3eA%t\u0007EZ1w_V\u0014\be\u001c4!i\",\u0007e\u001c8fAQD\u0017\r\u001e\u0011uC.,7\u000fI1!'\u0016\f\u0018EAA6\u0003!\u0001d&\r\u0019/c9\u0002\u0004B\u0002\fD\t\u0003\ty\u0007F\u0007C\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141\u0010\u0005\u0007!\u00065\u0004\u0019\u0001\u0018\t\rQ\u000bi\u00071\u0001W\u0011\u0019!\u0017Q\u000ea\u0001]!1\u0001.!\u001cA\u00029Ba\u0001\\A7\u0001\u0004q\u0003B\u00029\u0002n\u0001\u0007!\u000fC\u0004\u0002\u0000\r#\t!!!\u0002\u000f]\u0014\u0018\u000e^3U_R!\u00111QAE!\ri\u0011QQ\u0005\u0004\u0003\u000fs!\u0001B+oSRD\u0001\"a#\u0002~\u0001\u0007\u0011QR\u0001\u0007EV4g-\u001a:\u0011\t\u0005=\u0015\u0011T\u0007\u0003\u0003#SA!a%\u0002\u0016\u0006\u0019a.[8\u000b\u0005\u0005]\u0015\u0001\u00026bm\u0006LA!a'\u0002\u0012\nQ!)\u001f;f\u0005V4g-\u001a:\t\r\u0005}5\t\"\u0001.\u0003-\u0019\u0018N_3J]\nKH/Z:\t\u000f\u0005\r6\t\"\u0001\u0002&\u0006q\u0011n\u001d$s_64u\u000e\u001c7po\u0016\u0014XCAAT!\ri\u0011\u0011V\u0005\u0004\u0003Ws!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003_\u001bE\u0011AAS\u0003YI7O\u0012:p[>\u0013H-\u001b8bef\u001cuN\\:v[\u0016\u0014\bbBAZ\u0007\u0012\u0005\u0011QU\u0001\u0017SN4%o\\7M_^dUM^3m\u0007>t7/^7fe\"1\u0011qW\"\u0005\u00025\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bbBA^\u0007\u0012\u0005\u0013QX\u0001\ti>\u001cFO]5oOR\ta\u000bC\u0004\u0002B\u000e#\t%a1\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\t\u0003\u0007\u000b)-a4\u0002`\"A\u0011qYA`\u0001\u0004\tI-A\u0001f!\r\u0019\u00181Z\u0005\u0004\u0003\u001bl(!\u0003+ie><\u0018M\u00197f\u0011!\t\t.a0A\u0002\u0005M\u0017A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\u001c\u0003\u0002\u000f9,Go^8sW&!\u0011Q\\Al\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2D\u0001\"!9\u0002@\u0002\u0007\u00111]\u0001\be\u0016\fX/Z:u!\u0011\t)/a;\u000f\t\u0005U\u0017q]\u0005\u0005\u0003S\f9.\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u00055\u0018q\u001e\u0002\b%\u0016\fX/Z:u\u0015\u0011\tI/a6\t\u000f\u0005M8\t\"\u0011\u0002v\u0006AA-Z:de&\u0014W\rF\u0002W\u0003oD\u0001\"!?\u0002r\u0002\u0007\u0011qU\u0001\bI\u0016$\u0018-\u001b7t\u0011%\tipQA\u0001\n\u0003\ty0\u0001\u0003d_BLH#\u0005\"\u0003\u0002\t\r!Q\u0001B\u0004\u0005\u0013\u0011YA!\u0004\u0003\u0010!AA*a?\u0011\u0002\u0003\u0007a\u0005\u0003\u0005Q\u0003w\u0004\n\u00111\u0001/\u0011!!\u00161 I\u0001\u0002\u00041\u0006\u0002\u00031\u0002|B\u0005\t\u0019\u0001\u0018\t\u0011\u0011\fY\u0010%AA\u00029B\u0001\u0002[A~!\u0003\u0005\rA\f\u0005\tY\u0006m\b\u0013!a\u0001]!A\u0001/a?\u0011\u0002\u0003\u0007!\u000fC\u0005\u0003\u0014\r\u000b\n\u0011\"\u0001\u0003\u0016\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\fU\r1#\u0011D\u0016\u0003\u00057\u0001BA!\b\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#A\u0005v]\u000eDWmY6fI*\u0019!Q\u0005\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003*\t}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!QF\"\u0012\u0002\u0013\u0005!qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tDK\u0002/\u00053A\u0011B!\u000eD#\u0003%\tAa\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\b\u0016\u0004-\ne\u0001\"\u0003B\u001f\u0007F\u0005I\u0011\u0001B\u0018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQB\u0011B!\u0011D#\u0003%\tAa\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k!I!QI\"\u0012\u0002\u0013\u0005!qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0011%\u0011IeQI\u0001\n\u0003\u0011y#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\t\u0013\t53)%A\u0005\u0002\t=\u0013AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005#R3A\u001dB\r\u0011%\u0011)fQA\u0001\n\u0003\u00129&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00053\u0002BAa\u0017\u0003b5\u0011!Q\f\u0006\u0005\u0005?\n)*\u0001\u0003mC:<\u0017bA.\u0003^!A!QM\"\u0002\u0002\u0013\u0005Q&\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0003j\r\u000b\t\u0011\"\u0001\u0003l\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B7\u0005g\u00022!\u0004B8\u0013\r\u0011\tH\u0004\u0002\u0004\u0003:L\b\"\u0003B;\u0005O\n\t\u00111\u0001/\u0003\rAH%\r\u0005\n\u0005s\u001a\u0015\u0011!C!\u0005w\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005{\u0002bAa \u0003\u0006\n5TB\u0001BA\u0015\r\u0011\u0019ID\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BD\u0005\u0003\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005\u0017\u001b\u0015\u0011!C\u0001\u0005\u001b\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\u0013y\t\u0003\u0006\u0003v\t%\u0015\u0011!a\u0001\u0005[B\u0011Ba%D\u0003\u0003%\tE!&\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A\f\u0005\n\u00053\u001b\u0015\u0011!C!\u00057\u000ba!Z9vC2\u001cH\u0003BAT\u0005;C!B!\u001e\u0003\u0018\u0006\u0005\t\u0019\u0001B7\u0011\u001d\tYi\u0010a\u0001\u0003\u001bCqAa)\n\t\u0003\u0011)+A\u0004tQV4g\r\\3\u0015\u0007I\u00149\u000b\u0003\u0004q\u0005C\u0003\rA\u001d\u0005\b\u0005WKA\u0011\u0001BW\u00031\u0011\u0017\r^2i\u0005f$v\u000e]5d+\u0011\u0011yK!0\u0015\t\tE&\u0011\u001a\t\u0005gn\u0014\u0019\fE\u0003\u000e\u007fZ\u0013)\f\u0005\u0003tw\n]\u0006#B\u0007\u0000]\te\u0006\u0003\u0002B^\u0005{c\u0001\u0001\u0002\u0005\u0003@\n%&\u0019\u0001Ba\u0005\u0005!\u0016\u0003\u0002Bb\u0005[\u00022!\u0004Bc\u0013\r\u00119M\u0004\u0002\b\u001d>$\b.\u001b8h\u0011!\u0011YM!+A\u0002\t5\u0017!A:\u0011\tM\\(q\u001a\t\u0007\u001b}\f\u0019A!/\t\u0013\tM\u0017\"!A\u0005\u0002\nU\u0017!B1qa2LH#\u0005\"\u0003X\ne'1\u001cBo\u0005?\u0014\tOa9\u0003f\"AAJ!5\u0011\u0002\u0003\u0007a\u0005\u0003\u0005Q\u0005#\u0004\n\u00111\u0001/\u0011!!&\u0011\u001bI\u0001\u0002\u00041\u0006\u0002\u00031\u0003RB\u0005\t\u0019\u0001\u0018\t\u0011\u0011\u0014\t\u000e%AA\u00029B\u0001\u0002\u001bBi!\u0003\u0005\rA\f\u0005\tY\nE\u0007\u0013!a\u0001]!1\u0001O!5A\u0002ID\u0011B!;\n\u0003\u0003%\tIa;\u0002\u000fUt\u0017\r\u001d9msR!!Q\u001eB}!\u0015i!q\u001eBz\u0013\r\u0011\tP\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00175\u0011)P\n\u0018W]9rcF]\u0005\u0004\u0005ot!A\u0002+va2,\u0007\bC\u0005\u0003|\n\u001d\u0018\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010\n\u0019\t\u0013\t}\u0018\"%A\u0005\u0002\tU\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0004\u0004%\t\n\u0011\"\u0001\u00030\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB\u0011ba\u0002\n#\u0003%\tAa\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0019Y!CI\u0001\n\u0003\u0011y#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0007\u001fI\u0011\u0013!C\u0001\u0005_\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004\"CB\n\u0013E\u0005I\u0011\u0001B\u0018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m!I1qC\u0005\u0012\u0002\u0013\u0005!qF\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\t\u0013\rm\u0011\"%A\u0005\u0002\tU\u0011aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\t\u0013\r}\u0011\"%A\u0005\u0002\t=\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\r\r\u0012\"%A\u0005\u0002\t]\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\r\u001d\u0012\"%A\u0005\u0002\t=\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\r-\u0012\"%A\u0005\u0002\t=\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\t\u0013\r=\u0012\"%A\u0005\u0002\t=\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\t\u0013\rM\u0012\"%A\u0005\u0002\t=\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\t\u0013\r]\u0012\"!A\u0005\n\re\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u000f\u0011\t\tm3QH\u0005\u0005\u0007\u007f\u0011iF\u0001\u0004PE*,7\r\u001e")
public class FetchRequest
extends RequestOrResponse
implements Product,
Serializable {
    private final short versionId;
    private final int correlationId;
    private final String clientId;
    private final int replicaId;
    private final int maxWait;
    private final int minBytes;
    private final int maxBytes;
    private final Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> requestInfo;
    private Seq<Tuple2<String, Seq<Tuple2<Object, PartitionFetchInfo>>>> requestInfoGroupedByTopic;
    private volatile boolean bitmap$0;

    public static int apply$default$7() {
        return FetchRequest$.MODULE$.apply$default$7();
    }

    public static int apply$default$6() {
        return FetchRequest$.MODULE$.apply$default$6();
    }

    public static int apply$default$5() {
        return FetchRequest$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return FetchRequest$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return FetchRequest$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return FetchRequest$.MODULE$.apply$default$2();
    }

    public static short apply$default$1() {
        return FetchRequest$.MODULE$.apply$default$1();
    }

    public static int $lessinit$greater$default$7() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$2();
    }

    public static short $lessinit$greater$default$1() {
        return FetchRequest$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple8<Object, Object, String, Object, Object, Object, Object, Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>>>> unapply(FetchRequest fetchRequest) {
        return FetchRequest$.MODULE$.unapply(fetchRequest);
    }

    public static FetchRequest apply(short s, int n, String string, int n2, int n3, int n4, int n5, Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> seq) {
        return FetchRequest$.MODULE$.apply(s, n, string, n2, n3, n4, n5, seq);
    }

    public static <T> Seq<Tuple2<String, Seq<Tuple2<Object, T>>>> batchByTopic(Seq<Tuple2<TopicAndPartition, T>> seq) {
        return FetchRequest$.MODULE$.batchByTopic(seq);
    }

    public static Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> shuffle(Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> seq) {
        return FetchRequest$.MODULE$.shuffle(seq);
    }

    public static FetchRequest readFrom(ByteBuffer byteBuffer) {
        return FetchRequest$.MODULE$.readFrom(byteBuffer);
    }

    public static int DefaultCorrelationId() {
        return FetchRequest$.MODULE$.DefaultCorrelationId();
    }

    public static int DefaultMaxBytes() {
        return FetchRequest$.MODULE$.DefaultMaxBytes();
    }

    public static int DefaultMinBytes() {
        return FetchRequest$.MODULE$.DefaultMinBytes();
    }

    public static int DefaultMaxWait() {
        return FetchRequest$.MODULE$.DefaultMaxWait();
    }

    public static short CurrentVersion() {
        return FetchRequest$.MODULE$.CurrentVersion();
    }

    private Seq requestInfoGroupedByTopic$lzycompute() {
        FetchRequest fetchRequest = this;
        synchronized (fetchRequest) {
            if (!this.bitmap$0) {
                this.requestInfoGroupedByTopic = FetchRequest$.MODULE$.batchByTopic(this.requestInfo());
                this.bitmap$0 = true;
            }
            return this.requestInfoGroupedByTopic;
        }
    }

    public short versionId() {
        return this.versionId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> requestInfo() {
        return this.requestInfo;
    }

    private Seq<Tuple2<String, Seq<Tuple2<Object, PartitionFetchInfo>>>> requestInfoGroupedByTopic() {
        return this.bitmap$0 ? this.requestInfoGroupedByTopic : this.requestInfoGroupedByTopic$lzycompute();
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.putShort(this.versionId());
        buffer.putInt(this.correlationId());
        ApiUtils$.MODULE$.writeShortString(buffer, this.clientId());
        buffer.putInt(this.replicaId());
        buffer.putInt(this.maxWait());
        buffer.putInt(this.minBytes());
        Object object = this.versionId() >= 3 ? buffer.putInt(this.maxBytes()) : BoxedUnit.UNIT;
        buffer.putInt(this.requestInfoGroupedByTopic().size());
        this.requestInfoGroupedByTopic().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$2;

            public final void apply(Tuple2<String, Seq<Tuple2<Object, PartitionFetchInfo>>> x0$6) {
                Tuple2<String, Seq<Tuple2<Object, PartitionFetchInfo>>> tuple2 = x0$6;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Seq partitionFetchInfos = (Seq)tuple2._2();
                    ApiUtils$.MODULE$.writeShortString(this.buffer$2, topic);
                    this.buffer$2.putInt(partitionFetchInfos.size());
                    partitionFetchInfos.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeTo$1 $outer;

                        public final ByteBuffer apply(Tuple2<Object, PartitionFetchInfo> x0$7) {
                            Tuple2<Object, PartitionFetchInfo> tuple2 = x0$7;
                            if (tuple2 != null) {
                                int partition = tuple2._1$mcI$sp();
                                PartitionFetchInfo partitionFetchInfo = (PartitionFetchInfo)tuple2._2();
                                if (partitionFetchInfo != null) {
                                    long offset = partitionFetchInfo.offset();
                                    int fetchSize = partitionFetchInfo.fetchSize();
                                    this.$outer.buffer$2.putInt(partition);
                                    this.$outer.buffer$2.putLong(offset);
                                    ByteBuffer byteBuffer = this.$outer.buffer$2.putInt(fetchSize);
                                    return byteBuffer;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
    }

    @Override
    public int sizeInBytes() {
        return 6 + ApiUtils$.MODULE$.shortStringLength(this.clientId()) + 4 + 4 + 4 + (this.versionId() >= 3 ? 4 : 0) + 4 + BoxesRunTime.unboxToInt((Object)this.requestInfoGroupedByTopic().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int foldedTopics, Tuple2<String, Seq<Tuple2<Object, PartitionFetchInfo>>> currTopic) {
                Tuple2<String, Seq<Tuple2<Object, PartitionFetchInfo>>> tuple2 = currTopic;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String topic = (String)tuple2._1();
                    Seq partitionFetchInfos = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)topic, (Object)partitionFetchInfos);
                    String topic2 = (String)tuple23._1();
                    Seq partitionFetchInfos2 = (Seq)tuple23._2();
                    return foldedTopics + ApiUtils$.MODULE$.shortStringLength(topic2) + 4 + partitionFetchInfos2.size() * 16;
                }
                throw new MatchError(tuple2);
            }
        }));
    }

    public boolean isFromFollower() {
        return Request$.MODULE$.isValidBrokerId(this.replicaId());
    }

    public boolean isFromOrdinaryConsumer() {
        return this.replicaId() == Request$.MODULE$.OrdinaryConsumerId();
    }

    public boolean isFromLowLevelConsumer() {
        return this.replicaId() == Request$.MODULE$.DebuggingConsumerId();
    }

    public int numPartitions() {
        return this.requestInfo().size();
    }

    public String toString() {
        return this.describe(true);
    }

    @Override
    public void handleError(Throwable e, RequestChannel requestChannel, RequestChannel.Request request) {
        LinkedHashMap responseData = new LinkedHashMap();
        this.requestInfo().foreach((Function1)new Serializable(this, e, responseData){
            public static final long serialVersionUID = 0L;
            private final Throwable e$1;
            private final LinkedHashMap responseData$1;

            public final FetchResponse.PartitionData apply(Tuple2<TopicAndPartition, PartitionFetchInfo> x0$8) {
                TopicAndPartition topicAndPartition;
                Tuple2<TopicAndPartition, PartitionFetchInfo> tuple2 = x0$8;
                if (tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null) {
                    String topic = topicAndPartition.topic();
                    int partition = topicAndPartition.partition();
                    FetchResponse.PartitionData partitionData = this.responseData$1.put(new TopicPartition(topic, partition), new FetchResponse.PartitionData(Errors.forException((Throwable)this.e$1).code(), -1L, (Records)MemoryRecords.EMPTY));
                    return partitionData;
                }
                throw new MatchError(tuple2);
            }
            {
                this.e$1 = e$1;
                this.responseData$1 = responseData$1;
            }
        });
        FetchResponse errorResponse = new FetchResponse((int)this.versionId(), responseData, 0);
        requestChannel.sendResponse(new RequestChannel.Response(request, (AbstractResponse)errorResponse));
    }

    @Override
    public String describe(boolean details) {
        StringBuilder fetchRequest = new StringBuilder();
        fetchRequest.append(new StringBuilder().append((Object)"Name: ").append((Object)this.getClass().getSimpleName()).toString());
        fetchRequest.append(new StringBuilder().append((Object)"; Version: ").append((Object)BoxesRunTime.boxToShort((short)this.versionId())).toString());
        fetchRequest.append(new StringBuilder().append((Object)"; CorrelationId: ").append((Object)BoxesRunTime.boxToInteger((int)this.correlationId())).toString());
        fetchRequest.append(new StringBuilder().append((Object)"; ClientId: ").append((Object)this.clientId()).toString());
        fetchRequest.append(new StringBuilder().append((Object)"; ReplicaId: ").append((Object)BoxesRunTime.boxToInteger((int)this.replicaId())).toString());
        fetchRequest.append(new StringBuilder().append((Object)"; MaxWait: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxWait())).append((Object)" ms").toString());
        fetchRequest.append(new StringBuilder().append((Object)"; MinBytes: ").append((Object)BoxesRunTime.boxToInteger((int)this.minBytes())).append((Object)" bytes").toString());
        fetchRequest.append(new StringBuilder().append((Object)"; MaxBytes:").append((Object)BoxesRunTime.boxToInteger((int)this.maxBytes())).append((Object)" bytes").toString());
        Object object = details ? fetchRequest.append(new StringBuilder().append((Object)"; RequestInfo: ").append((Object)this.requestInfo().mkString(",")).toString()) : BoxedUnit.UNIT;
        return fetchRequest.toString();
    }

    public FetchRequest copy(short versionId, int correlationId, String clientId, int replicaId, int maxWait, int minBytes, int maxBytes, Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> requestInfo) {
        return new FetchRequest(versionId, correlationId, clientId, replicaId, maxWait, minBytes, maxBytes, requestInfo);
    }

    public short copy$default$1() {
        return this.versionId();
    }

    public int copy$default$2() {
        return this.correlationId();
    }

    public String copy$default$3() {
        return this.clientId();
    }

    public int copy$default$4() {
        return this.replicaId();
    }

    public int copy$default$5() {
        return this.maxWait();
    }

    public int copy$default$6() {
        return this.minBytes();
    }

    public int copy$default$7() {
        return this.maxBytes();
    }

    public Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> copy$default$8() {
        return this.requestInfo();
    }

    public String productPrefix() {
        return "FetchRequest";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 7: {
                object = this.requestInfo();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToInteger((int)this.maxBytes());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.minBytes());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.maxWait());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.replicaId());
                break;
            }
            case 2: {
                object = this.clientId();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.correlationId());
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToShort((short)this.versionId());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FetchRequest;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.versionId());
        n = Statics.mix((int)n, (int)this.correlationId());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clientId()));
        n = Statics.mix((int)n, (int)this.replicaId());
        n = Statics.mix((int)n, (int)this.maxWait());
        n = Statics.mix((int)n, (int)this.minBytes());
        n = Statics.mix((int)n, (int)this.maxBytes());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.requestInfo()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FetchRequest)) return false;
        boolean bl = true;
        if (!bl) return false;
        FetchRequest fetchRequest = (FetchRequest)x$1;
        if (this.versionId() != fetchRequest.versionId()) return false;
        if (this.correlationId() != fetchRequest.correlationId()) return false;
        String string = this.clientId();
        String string2 = fetchRequest.clientId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.replicaId() != fetchRequest.replicaId()) return false;
        if (this.maxWait() != fetchRequest.maxWait()) return false;
        if (this.minBytes() != fetchRequest.minBytes()) return false;
        if (this.maxBytes() != fetchRequest.maxBytes()) return false;
        Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> seq = this.requestInfo();
        Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> seq2 = fetchRequest.requestInfo();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!fetchRequest.canEqual(this)) return false;
        return true;
    }

    public FetchRequest(short versionId, int correlationId, String clientId, int replicaId, int maxWait, int minBytes, int maxBytes, Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> requestInfo) {
        this.versionId = versionId;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.replicaId = replicaId;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.requestInfo = requestInfo;
        super((Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)ApiKeys.FETCH.id)));
        Product.class.$init$((Product)this);
    }

    public FetchRequest(int correlationId, String clientId, int maxWait, int minBytes, int maxBytes, Map<TopicAndPartition, PartitionFetchInfo> requestInfo) {
        this(FetchRequest$.MODULE$.CurrentVersion(), correlationId, clientId, Request$.MODULE$.OrdinaryConsumerId(), maxWait, minBytes, maxBytes, FetchRequest$.MODULE$.shuffle((Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>>)requestInfo.toSeq()));
    }

    public FetchRequest(int correlationId, String clientId, int maxWait, int minBytes, int maxBytes, Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> requestInfo) {
        this(FetchRequest$.MODULE$.CurrentVersion(), correlationId, clientId, Request$.MODULE$.OrdinaryConsumerId(), maxWait, minBytes, maxBytes, requestInfo);
    }
}

