/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.internals.KeyAndJoinSide;

public class KeyAndJoinSideSerializer<K>
implements WrappingNullableSerializer<KeyAndJoinSide<K>, K, Void> {
    private Serializer<K> keySerializer;

    KeyAndJoinSideSerializer(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.keySerializer == null) {
            this.keySerializer = getter.keySerde().serializer();
        }
        WrappingNullableUtils.initNullableSerializer(this.keySerializer, getter);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.keySerializer.configure(configs, isKey);
    }

    public byte[] serialize(String topic, KeyAndJoinSide<K> data) {
        byte boolByte = (byte)(data.isLeftSide() ? 1 : 0);
        byte[] keyBytes = this.keySerializer.serialize(topic, data.getKey());
        return ByteBuffer.allocate(keyBytes.length + 1).put(boolByte).put(keyBytes).array();
    }

    public void close() {
        this.keySerializer.close();
    }
}

