/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;

@InterfaceStability.Evolving
public class RemotePartitionDeleteMetadata
extends RemoteLogMetadata {
    private final TopicIdPartition topicIdPartition;
    private final RemotePartitionDeleteState state;

    public RemotePartitionDeleteMetadata(TopicIdPartition topicIdPartition, RemotePartitionDeleteState state, long eventTimestampMs, int brokerId) {
        super(brokerId, eventTimestampMs);
        this.topicIdPartition = Objects.requireNonNull(topicIdPartition);
        this.state = Objects.requireNonNull(state);
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public RemotePartitionDeleteState state() {
        return this.state;
    }

    public String toString() {
        return "RemotePartitionDeleteMetadata{topicPartition=" + this.topicIdPartition + ", state=" + (Object)((Object)this.state) + ", eventTimestampMs=" + this.eventTimestampMs() + ", brokerId=" + this.brokerId() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemotePartitionDeleteMetadata that = (RemotePartitionDeleteMetadata)o;
        return Objects.equals(this.topicIdPartition, that.topicIdPartition) && this.state == that.state && this.eventTimestampMs() == that.eventTimestampMs() && this.brokerId() == that.brokerId();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicIdPartition, this.state, this.eventTimestampMs(), this.brokerId()});
    }
}

