/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Optional;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsDelta;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.server.common.MetadataVersion;

public final class MetadataDelta {
    private final MetadataImage image;
    private FeaturesDelta featuresDelta = null;
    private ClusterDelta clusterDelta = null;
    private TopicsDelta topicsDelta = null;
    private ConfigurationsDelta configsDelta = null;
    private ClientQuotasDelta clientQuotasDelta = null;
    private ProducerIdsDelta producerIdsDelta = null;
    private AclsDelta aclsDelta = null;

    public MetadataDelta(MetadataImage image) {
        this.image = image;
    }

    public MetadataImage image() {
        return this.image;
    }

    public FeaturesDelta featuresDelta() {
        return this.featuresDelta;
    }

    public FeaturesDelta getOrCreateFeaturesDelta() {
        if (this.featuresDelta == null) {
            this.featuresDelta = new FeaturesDelta(this.image.features());
        }
        return this.featuresDelta;
    }

    public ClusterDelta clusterDelta() {
        return this.clusterDelta;
    }

    public ClusterDelta getOrCreateClusterDelta() {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        return this.clusterDelta;
    }

    public TopicsDelta topicsDelta() {
        return this.topicsDelta;
    }

    public TopicsDelta getOrCreateTopicsDelta() {
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics());
        }
        return this.topicsDelta;
    }

    public ConfigurationsDelta configsDelta() {
        return this.configsDelta;
    }

    public ConfigurationsDelta getOrCreateConfigsDelta() {
        if (this.configsDelta == null) {
            this.configsDelta = new ConfigurationsDelta(this.image.configs());
        }
        return this.configsDelta;
    }

    public ClientQuotasDelta clientQuotasDelta() {
        return this.clientQuotasDelta;
    }

    public ClientQuotasDelta getOrCreateClientQuotasDelta() {
        if (this.clientQuotasDelta == null) {
            this.clientQuotasDelta = new ClientQuotasDelta(this.image.clientQuotas());
        }
        return this.clientQuotasDelta;
    }

    public ProducerIdsDelta producerIdsDelta() {
        return this.producerIdsDelta;
    }

    public ProducerIdsDelta getOrCreateProducerIdsDelta() {
        if (this.producerIdsDelta == null) {
            this.producerIdsDelta = new ProducerIdsDelta(this.image.producerIds());
        }
        return this.producerIdsDelta;
    }

    public AclsDelta aclsDelta() {
        return this.aclsDelta;
    }

    public AclsDelta getOrCreateAclsDelta() {
        if (this.aclsDelta == null) {
            this.aclsDelta = new AclsDelta(this.image.acls());
        }
        return this.aclsDelta;
    }

    public Optional<MetadataVersion> metadataVersionChanged() {
        if (this.featuresDelta == null) {
            return Optional.empty();
        }
        return this.featuresDelta.metadataVersionChange();
    }

    public void replay(ApiMessage record) {
        MetadataRecordType type = MetadataRecordType.fromId(record.apiKey());
        switch (type) {
            case REGISTER_BROKER_RECORD: {
                this.replay((RegisterBrokerRecord)record);
                break;
            }
            case UNREGISTER_BROKER_RECORD: {
                this.replay((UnregisterBrokerRecord)record);
                break;
            }
            case TOPIC_RECORD: {
                this.replay((TopicRecord)record);
                break;
            }
            case PARTITION_RECORD: {
                this.replay((PartitionRecord)record);
                break;
            }
            case CONFIG_RECORD: {
                this.replay((ConfigRecord)record);
                break;
            }
            case PARTITION_CHANGE_RECORD: {
                this.replay((PartitionChangeRecord)record);
                break;
            }
            case FENCE_BROKER_RECORD: {
                this.replay((FenceBrokerRecord)record);
                break;
            }
            case UNFENCE_BROKER_RECORD: {
                this.replay((UnfenceBrokerRecord)record);
                break;
            }
            case REMOVE_TOPIC_RECORD: {
                this.replay((RemoveTopicRecord)record);
                break;
            }
            case FEATURE_LEVEL_RECORD: {
                this.replay((FeatureLevelRecord)record);
                break;
            }
            case CLIENT_QUOTA_RECORD: {
                this.replay((ClientQuotaRecord)record);
                break;
            }
            case PRODUCER_IDS_RECORD: {
                this.replay((ProducerIdsRecord)record);
                break;
            }
            case BROKER_REGISTRATION_CHANGE_RECORD: {
                this.replay((BrokerRegistrationChangeRecord)record);
                break;
            }
            case ACCESS_CONTROL_ENTRY_RECORD: {
                this.replay((AccessControlEntryRecord)record);
                break;
            }
            case REMOVE_ACCESS_CONTROL_ENTRY_RECORD: {
                this.replay((RemoveAccessControlEntryRecord)record);
                break;
            }
            case NO_OP_RECORD: {
                break;
            }
            case ZK_MIGRATION_STATE_RECORD: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown metadata record type " + (Object)((Object)type));
            }
        }
    }

    public void replay(RegisterBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(UnregisterBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(TopicRecord record) {
        this.getOrCreateTopicsDelta().replay(record);
    }

    public void replay(PartitionRecord record) {
        this.getOrCreateTopicsDelta().replay(record);
    }

    public void replay(ConfigRecord record) {
        this.getOrCreateConfigsDelta().replay(record);
    }

    public void replay(PartitionChangeRecord record) {
        this.getOrCreateTopicsDelta().replay(record);
    }

    public void replay(FenceBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(UnfenceBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(RemoveTopicRecord record) {
        String topicName = this.getOrCreateTopicsDelta().replay(record);
        this.getOrCreateConfigsDelta().replay(record, topicName);
    }

    public void replay(FeatureLevelRecord record) {
        this.getOrCreateFeaturesDelta().replay(record);
        this.featuresDelta.metadataVersionChange().ifPresent(changedMetadataVersion -> {
            this.getOrCreateClusterDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateConfigsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateTopicsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateClientQuotasDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateProducerIdsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateAclsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
        });
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(ClientQuotaRecord record) {
        this.getOrCreateClientQuotasDelta().replay(record);
    }

    public void replay(ProducerIdsRecord record) {
        this.getOrCreateProducerIdsDelta().replay(record);
    }

    public void replay(AccessControlEntryRecord record) {
        this.getOrCreateAclsDelta().replay(record);
    }

    public void replay(RemoveAccessControlEntryRecord record) {
        this.getOrCreateAclsDelta().replay(record);
    }

    public void finishSnapshot() {
        this.getOrCreateFeaturesDelta().finishSnapshot();
        this.getOrCreateClusterDelta().finishSnapshot();
        this.getOrCreateTopicsDelta().finishSnapshot();
        this.getOrCreateConfigsDelta().finishSnapshot();
        this.getOrCreateClientQuotasDelta().finishSnapshot();
        this.getOrCreateProducerIdsDelta().finishSnapshot();
        this.getOrCreateAclsDelta().finishSnapshot();
    }

    public MetadataImage apply(MetadataProvenance provenance) {
        FeaturesImage newFeatures = this.featuresDelta == null ? this.image.features() : this.featuresDelta.apply();
        ClusterImage newCluster = this.clusterDelta == null ? this.image.cluster() : this.clusterDelta.apply();
        TopicsImage newTopics = this.topicsDelta == null ? this.image.topics() : this.topicsDelta.apply();
        ConfigurationsImage newConfigs = this.configsDelta == null ? this.image.configs() : this.configsDelta.apply();
        ClientQuotasImage newClientQuotas = this.clientQuotasDelta == null ? this.image.clientQuotas() : this.clientQuotasDelta.apply();
        ProducerIdsImage newProducerIds = this.producerIdsDelta == null ? this.image.producerIds() : this.producerIdsDelta.apply();
        AclsImage newAcls = this.aclsDelta == null ? this.image.acls() : this.aclsDelta.apply();
        return new MetadataImage(provenance, newFeatures, newCluster, newTopics, newConfigs, newClientQuotas, newProducerIds, newAcls);
    }

    public String toString() {
        return "MetadataDelta(featuresDelta=" + this.featuresDelta + ", clusterDelta=" + this.clusterDelta + ", topicsDelta=" + this.topicsDelta + ", configsDelta=" + this.configsDelta + ", clientQuotasDelta=" + this.clientQuotasDelta + ", producerIdsDelta=" + this.producerIdsDelta + ", aclsDelta=" + this.aclsDelta + ')';
    }

    public static class Builder {
        private MetadataImage image = MetadataImage.EMPTY;

        public Builder setImage(MetadataImage image) {
            this.image = image;
            return this;
        }

        public MetadataDelta build() {
            return new MetadataDelta(this.image);
        }
    }
}

