/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.FakeMetricsReporter;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.junit.Assert;
import org.junit.Test;

public class AbstractConfigTest {
    @Test
    public void testConfiguredInstances() {
        this.testValidInputs("");
        this.testValidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter");
        this.testValidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter, org.apache.kafka.common.metrics.FakeMetricsReporter");
        this.testInvalidInputs(",");
        this.testInvalidInputs("org.apache.kafka.clients.producer.unknown-metrics-reporter");
        this.testInvalidInputs("test1,test2");
        this.testInvalidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter,");
    }

    @Test
    public void testOriginalsWithPrefix() {
        Properties props = new Properties();
        props.put("foo.bar", "abc");
        props.put("setting", "def");
        TestConfig config = new TestConfig(props);
        Map originalsWithPrefix = config.originalsWithPrefix("foo.");
        Assert.assertTrue((boolean)config.unused().contains("foo.bar"));
        originalsWithPrefix.get("bar");
        Assert.assertFalse((boolean)config.unused().contains("foo.bar"));
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("bar", "abc");
        Assert.assertEquals(expected, (Object)originalsWithPrefix);
    }

    @Test
    public void testValuesWithPrefixOverride() {
        String prefix = "prefix.";
        Properties props = new Properties();
        props.put("sasl.mechanism", "PLAIN");
        props.put("prefix.sasl.mechanism", "GSSAPI");
        props.put("prefix.sasl.kerberos.kinit.cmd", "/usr/bin/kinit2");
        props.put("prefix.ssl.truststore.location", "my location");
        props.put("sasl.kerberos.service.name", "service name");
        props.put("ssl.keymanager.algorithm", "algorithm");
        TestSecurityConfig config = new TestSecurityConfig(props);
        Map valuesWithPrefixOverride = config.valuesWithPrefixOverride(prefix);
        Assert.assertTrue((boolean)config.unused().contains("prefix.sasl.mechanism"));
        Assert.assertTrue((boolean)config.unused().contains("sasl.mechanism"));
        Assert.assertEquals((Object)"GSSAPI", valuesWithPrefixOverride.get("sasl.mechanism"));
        Assert.assertFalse((boolean)config.unused().contains("sasl.mechanism"));
        Assert.assertFalse((boolean)config.unused().contains("prefix.sasl.mechanism"));
        Assert.assertTrue((boolean)config.unused().contains("prefix.sasl.kerberos.kinit.cmd"));
        Assert.assertFalse((boolean)config.unused().contains("sasl.kerberos.kinit.cmd"));
        Assert.assertEquals((Object)"/usr/bin/kinit2", valuesWithPrefixOverride.get("sasl.kerberos.kinit.cmd"));
        Assert.assertFalse((boolean)config.unused().contains("sasl.kerberos.kinit.cmd"));
        Assert.assertFalse((boolean)config.unused().contains("prefix.sasl.kerberos.kinit.cmd"));
        Assert.assertTrue((boolean)config.unused().contains("prefix.ssl.truststore.location"));
        Assert.assertFalse((boolean)config.unused().contains("ssl.truststore.location"));
        Assert.assertEquals((Object)"my location", valuesWithPrefixOverride.get("ssl.truststore.location"));
        Assert.assertFalse((boolean)config.unused().contains("ssl.truststore.location"));
        Assert.assertFalse((boolean)config.unused().contains("prefix.ssl.truststore.location"));
        Assert.assertTrue((boolean)config.unused().contains("ssl.keymanager.algorithm"));
        Assert.assertEquals((Object)"algorithm", valuesWithPrefixOverride.get("ssl.keymanager.algorithm"));
        Assert.assertFalse((boolean)config.unused().contains("ssl.keymanager.algorithm"));
        Assert.assertTrue((boolean)config.unused().contains("sasl.kerberos.service.name"));
        Assert.assertEquals((Object)"service name", valuesWithPrefixOverride.get("sasl.kerberos.service.name"));
        Assert.assertFalse((boolean)config.unused().contains("sasl.kerberos.service.name"));
        Assert.assertFalse((boolean)config.unused().contains("sasl.kerberos.min.time.before.relogin"));
        Assert.assertEquals((Object)60000L, valuesWithPrefixOverride.get("sasl.kerberos.min.time.before.relogin"));
        Assert.assertFalse((boolean)config.unused().contains("sasl.kerberos.min.time.before.relogin"));
        Assert.assertFalse((boolean)config.unused().contains("ssl.key.password"));
        Assert.assertNull(valuesWithPrefixOverride.get("ssl.key.password"));
        Assert.assertFalse((boolean)config.unused().contains("ssl.key.password"));
    }

    @Test
    public void testUnused() {
        Properties props = new Properties();
        String configValue = "org.apache.kafka.common.config.AbstractConfigTest$ConfiguredFakeMetricsReporter";
        props.put("metric.reporters", configValue);
        props.put("metric.extra_config", "my_value");
        TestConfig config = new TestConfig(props);
        Assert.assertTrue((String)"metric.extra_config should be marked unused before getConfiguredInstances is called", (boolean)config.unused().contains("metric.extra_config"));
        config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        Assert.assertTrue((String)"All defined configurations should be marked as used", (boolean)config.unused().isEmpty());
    }

    private void testValidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        }
        catch (ConfigException e) {
            Assert.fail((String)("No exceptions are expected here, valid props are :" + props));
        }
    }

    private void testInvalidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            Assert.fail((String)("Expected a config exception due to invalid props :" + props));
        }
        catch (KafkaException e) {
            // empty catch block
        }
    }

    @Test
    public void testClassConfigs() {
        class RestrictedClassLoader
        extends ClassLoader {
            public RestrictedClassLoader() {
                super(null);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(ClassTestConfig.DEFAULT_CLASS.getName()) || name.equals(ClassTestConfig.RESTRICTED_CLASS.getName())) {
                    return null;
                }
                return ClassTestConfig.class.getClassLoader().loadClass(name);
            }
        }
        RestrictedClassLoader restrictedClassLoader = new RestrictedClassLoader();
        ClassLoader defaultClassLoader = AbstractConfig.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(defaultClassLoader);
        ClassTestConfig testConfig = new ClassTestConfig();
        testConfig.checkInstances(ClassTestConfig.DEFAULT_CLASS, ClassTestConfig.DEFAULT_CLASS);
        Thread.currentThread().setContextClassLoader(restrictedClassLoader);
        testConfig = new ClassTestConfig();
        testConfig.checkInstances(ClassTestConfig.DEFAULT_CLASS, ClassTestConfig.DEFAULT_CLASS);
        Thread.currentThread().setContextClassLoader(defaultClassLoader);
        ClassTestConfig.testOverrides();
        Thread.currentThread().setContextClassLoader(null);
        ClassTestConfig.testOverrides();
        Thread.currentThread().setContextClassLoader(restrictedClassLoader);
        testConfig = new ClassTestConfig(ClassTestConfig.RESTRICTED_CLASS, Arrays.asList(ClassTestConfig.RESTRICTED_CLASS));
        testConfig.checkInstances(ClassTestConfig.RESTRICTED_CLASS, ClassTestConfig.RESTRICTED_CLASS);
        testConfig = new ClassTestConfig(ClassTestConfig.RESTRICTED_CLASS, Arrays.asList(ClassTestConfig.VISIBLE_CLASS, ClassTestConfig.RESTRICTED_CLASS));
        testConfig.checkInstances(ClassTestConfig.RESTRICTED_CLASS, ClassTestConfig.VISIBLE_CLASS, ClassTestConfig.RESTRICTED_CLASS);
        try {
            new ClassTestConfig(ClassTestConfig.RESTRICTED_CLASS.getName(), null);
            Assert.fail((String)"Config created with class property that cannot be loaded");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        try {
            testConfig = new ClassTestConfig(null, Arrays.asList(ClassTestConfig.VISIBLE_CLASS.getName(), ClassTestConfig.RESTRICTED_CLASS.getName()));
            testConfig.getConfiguredInstances("list.prop", MetricsReporter.class);
            Assert.fail((String)"Should have failed to load class");
        }
        catch (KafkaException e) {
            // empty catch block
        }
        try {
            testConfig = new ClassTestConfig(null, ClassTestConfig.VISIBLE_CLASS.getName() + "," + ClassTestConfig.RESTRICTED_CLASS.getName());
            testConfig.getConfiguredInstances("list.prop", MetricsReporter.class);
            Assert.fail((String)"Should have failed to load class");
        }
        catch (KafkaException e) {
            // empty catch block
        }
    }

    public static class FakeMetricsReporterConfig
    extends AbstractConfig {
        public static final String EXTRA_CONFIG = "metric.extra_config";
        private static final String EXTRA_CONFIG_DOC = "An extraneous configuration string.";
        private static final ConfigDef CONFIG = new ConfigDef().define("metric.extra_config", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "An extraneous configuration string.");

        public FakeMetricsReporterConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }
    }

    public static class ConfiguredFakeMetricsReporter
    extends FakeMetricsReporter {
        @Override
        public void configure(Map<String, ?> configs) {
            FakeMetricsReporterConfig config = new FakeMetricsReporterConfig(configs);
            config.getString("metric.extra_config");
        }
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters.");
        public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
        private static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters.";

        public TestConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }
    }

    private static class ClassTestConfig
    extends AbstractConfig {
        static final Class<?> DEFAULT_CLASS = FakeMetricsReporter.class;
        static final Class<?> VISIBLE_CLASS = JmxReporter.class;
        static final Class<?> RESTRICTED_CLASS = ConfiguredFakeMetricsReporter.class;
        private static final ConfigDef CONFIG = new ConfigDef().define("class.prop", ConfigDef.Type.CLASS, DEFAULT_CLASS, ConfigDef.Importance.HIGH, "docs").define("list.prop", ConfigDef.Type.LIST, Arrays.asList(DEFAULT_CLASS), ConfigDef.Importance.HIGH, "docs");

        public ClassTestConfig() {
            super(CONFIG, (Map)new Properties());
        }

        public ClassTestConfig(Object classPropOverride, Object listPropOverride) {
            super(CONFIG, ClassTestConfig.overrideProps(classPropOverride, listPropOverride));
        }

        void checkInstances(Class<?> expectedClassPropClass, Class<?> ... expectedListPropClasses) {
            Assert.assertEquals(expectedClassPropClass, ((MetricsReporter)this.getConfiguredInstance("class.prop", MetricsReporter.class)).getClass());
            List list = this.getConfiguredInstances("list.prop", MetricsReporter.class);
            for (int i = 0; i < list.size(); ++i) {
                Assert.assertEquals(expectedListPropClasses[i], list.get(i).getClass());
            }
        }

        static void testOverrides() {
            ClassTestConfig testConfig1 = new ClassTestConfig(RESTRICTED_CLASS, Arrays.asList(VISIBLE_CLASS, RESTRICTED_CLASS));
            testConfig1.checkInstances(RESTRICTED_CLASS, VISIBLE_CLASS, RESTRICTED_CLASS);
            ClassTestConfig testConfig2 = new ClassTestConfig(RESTRICTED_CLASS.getName(), Arrays.asList(VISIBLE_CLASS.getName(), RESTRICTED_CLASS.getName()));
            testConfig2.checkInstances(RESTRICTED_CLASS, VISIBLE_CLASS, RESTRICTED_CLASS);
            ClassTestConfig testConfig3 = new ClassTestConfig(RESTRICTED_CLASS.getName(), VISIBLE_CLASS.getName() + "," + RESTRICTED_CLASS.getName());
            testConfig3.checkInstances(RESTRICTED_CLASS, VISIBLE_CLASS, RESTRICTED_CLASS);
        }

        private static Map<String, Object> overrideProps(Object classProp, Object listProp) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (classProp != null) {
                props.put("class.prop", classProp);
            }
            if (listProp != null) {
                props.put("list.prop", listProp);
            }
            return props;
        }
    }
}

