/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.record;

import java.util.Arrays;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.base.record.RecordException;
import org.apache.jena.dboe.sys.SystemIndex;

public final class Record {
    public static final Record NO_REC = null;
    private final byte[] key;
    private final byte[] value;

    public Record(byte[] key, byte[] value) {
        this.key = key;
        this.value = value;
        if (SystemIndex.Checking && value != null && value.length == 0) {
            throw new RecordException("Zero length value");
        }
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean hasSeparateValue() {
        return this.value != null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Record)) {
            return false;
        }
        Record r = (Record)other;
        return Record.compareByKeyValue(this, r) == 0;
    }

    public String toString() {
        if (this.value == null) {
            return Record.str(this.key);
        }
        return Record.str(this.key) + ":" + Record.str(this.value);
    }

    public static boolean keyEQ(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x == 0;
    }

    public static boolean keyNE(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x != 0;
    }

    public static boolean keyLT(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x < 0;
    }

    public static boolean keyLE(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x <= 0;
    }

    public static boolean keyGE(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x >= 0;
    }

    public static boolean keyGT(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x > 0;
    }

    public static boolean equals(Record record1, Record record2) {
        int x = Record.compareByKeyValue(record1, record2);
        return x == 0;
    }

    public static String str(byte[] b) {
        StringBuilder str = new StringBuilder();
        for (byte aB : b) {
            str.append(String.format("%02x", aB));
        }
        return str.toString();
    }

    public static int compareByKey(Record record1, Record record2) {
        Record.checkKeyCompatible(record1, record2);
        return Bytes.compare((byte[])record1.key, (byte[])record2.key);
    }

    public static int compareByKeyValue(Record record1, Record record2) {
        Record.checkCompatible(record1, record2);
        int x = Bytes.compare((byte[])record1.key, (byte[])record2.key);
        if (x == 0 && record1.value != null) {
            x = Bytes.compare((byte[])record1.value, (byte[])record2.value);
        }
        return x;
    }

    static void checkCompatible(Record record1, Record record2) {
        if (!Record.compatible(record1, record2, true)) {
            throw new RecordException(String.format("Incompatible: %s, %s", record1, record2));
        }
    }

    static void checkKeyCompatible(Record record1, Record record2) {
        if (!Record.compatible(record1, record2, false)) {
            throw new RecordException(String.format("Incompatible: %s, %s", record1, record2));
        }
    }

    static boolean compatible(Record record1, Record record2, boolean checkValue) {
        if (record1.key.length != record2.key.length) {
            return false;
        }
        if (checkValue) {
            if (record1.value == null && record2.value == null) {
                return true;
            }
            if (record1.value == null) {
                return false;
            }
            if (record2.value == null) {
                return false;
            }
            if (record1.value.length != record2.value.length) {
                return false;
            }
        }
        return true;
    }
}

