/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Trie<T> {
    private TrieNode<T> root = new TrieNode<Object>(null);

    public void add(String key, T value) {
        if (value == null) {
            return;
        }
        TrieNode<T> n = this.moveToNode(key);
        n.setValue(value);
    }

    private TrieNode<T> moveToNode(String key) {
        TrieNode<T> current = this.root;
        if (key == null) {
            return current;
        }
        for (int i = 0; i < key.length(); ++i) {
            current = current.moveToChild(Character.valueOf(key.charAt(i)));
        }
        return current;
    }

    private TrieNode<T> find(String key) {
        TrieNode<T> current = this.root;
        if (key == null) {
            return current;
        }
        for (int i = 0; i < key.length() && (current = current.getChild(Character.valueOf(key.charAt(i)))) != null; ++i) {
        }
        return current;
    }

    public void remove(String key) {
        TrieNode<Object> n = this.find(key);
        if (n != null) {
            n.setValue(null);
        }
    }

    public void clear() {
        this.root = new TrieNode<Object>(null);
    }

    public boolean isEmpty() {
        return !this.root.hasValue() && ((TrieNode)this.root).singletonChild == null;
    }

    public boolean contains(String key) {
        return this.contains(key, true);
    }

    public boolean contains(String key, boolean requireValue) {
        TrieNode<T> n = this.find(key);
        if (n == null) {
            return false;
        }
        if (requireValue) {
            return n.hasValue();
        }
        return true;
    }

    public boolean contains(String key, T value) {
        TrieNode<T> n = this.find(key);
        if (n == null) {
            return false;
        }
        if (value == null && !n.hasValue()) {
            return true;
        }
        return value.equals(n.getValue());
    }

    public T get(String key) {
        TrieNode<T> n = this.find(key);
        if (n == null) {
            return null;
        }
        return n.getValue();
    }

    public List<T> prefixSearch(String prefix) {
        TrieNode<T> n = this.find(prefix);
        if (n == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(n.getValues());
    }

    public List<T> partialSearch(String key) {
        ArrayList<T> values = new ArrayList<T>();
        TrieNode<T> current = this.root;
        if (key == null) {
            if (current.hasValue()) {
                values.add(current.getValue());
            }
        } else {
            for (int i = 0; i < key.length(); ++i) {
                if (current.hasValue()) {
                    values.add(current.getValue());
                }
                if ((current = current.getChild(Character.valueOf(key.charAt(i)))) != null) continue;
                return Collections.unmodifiableList(values);
            }
            if (current.hasValue()) {
                values.add(current.getValue());
            }
        }
        return Collections.unmodifiableList(values);
    }

    public T shortestMatch(String key) {
        TrieNode<T> current = this.root;
        if (key == null) {
            return current.getValue();
        }
        for (int i = 0; i < key.length() && !current.hasValue(); ++i) {
            if ((current = current.getChild(Character.valueOf(key.charAt(i)))) != null) continue;
            return null;
        }
        return current.getValue();
    }

    public T longestMatch(String key) {
        T value = null;
        TrieNode<T> current = this.root;
        if (key == null) {
            return current.getValue();
        }
        for (int i = 0; i < key.length(); ++i) {
            if (current.hasValue()) {
                value = current.getValue();
            }
            if ((current = current.getChild(Character.valueOf(key.charAt(i)))) != null) continue;
            return value;
        }
        if (current.hasValue()) {
            return current.getValue();
        }
        return value;
    }

    private static class TrieNode<T> {
        private Map<Character, TrieNode<T>> children = null;
        private Character singletonChildChar = null;
        private TrieNode<T> singletonChild = null;
        private T value;

        public TrieNode(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public TrieNode<T> getChild(Character c) {
            if (this.children != null) {
                return this.children.get(c);
            }
            if (c.equals(this.singletonChildChar)) {
                return this.singletonChild;
            }
            return null;
        }

        public TrieNode<T> moveToChild(Character c) {
            TrieNode<Object> n = this.getChild(c);
            if (n == null) {
                n = new TrieNode<Object>(null);
                if (this.children != null) {
                    this.children.put(c, n);
                } else if (this.singletonChildChar != null) {
                    this.children = new HashMap<Character, TrieNode<T>>();
                    this.children.put(this.singletonChildChar, this.singletonChild);
                    this.children.put(c, n);
                } else {
                    this.singletonChildChar = c;
                    this.singletonChild = n;
                }
            }
            return n;
        }

        public List<T> getValues() {
            ArrayList<T> values = new ArrayList<T>();
            if (this.hasValue()) {
                values.add(this.value);
            }
            if (this.children != null) {
                for (TrieNode<T> child : this.children.values()) {
                    values.addAll(child.getValues());
                }
            } else if (this.singletonChild != null) {
                values.addAll(this.singletonChild.getValues());
            }
            return values;
        }
    }
}

