/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.CHPFormattedDiskPage;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.util.LittleEndian;

public class CHPBinTable {
    protected ArrayList _textRuns = new ArrayList();
    private TextPieceTable tpt;

    public CHPBinTable() {
    }

    public CHPBinTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        PlexOfCps binTable = new PlexOfCps(tableStream, offset, size, 4);
        this.tpt = tpt;
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            int pageNum = LittleEndian.getInt(node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, fcMin, tpt);
            int fkpSize = cfkp.size();
            for (int y = 0; y < fkpSize; ++y) {
                this._textRuns.add(cfkp.getCHPX(y));
            }
        }
    }

    public void adjustForDelete(int listIndex, int offset, int length) {
        int x;
        int size = this._textRuns.size();
        int endMark = offset + length;
        int endIndex = listIndex;
        CHPX chpx = (CHPX)this._textRuns.get(endIndex);
        while (chpx.getEnd() < endMark) {
            chpx = (CHPX)this._textRuns.get(++endIndex);
        }
        if (listIndex == endIndex) {
            chpx = (CHPX)this._textRuns.get(endIndex);
            chpx.setEnd(chpx.getEnd() - endMark + offset);
        } else {
            chpx = (CHPX)this._textRuns.get(listIndex);
            chpx.setEnd(offset);
            for (x = listIndex + 1; x < endIndex; ++x) {
                chpx = (CHPX)this._textRuns.get(x);
                chpx.setStart(offset);
                chpx.setEnd(offset);
            }
            chpx = (CHPX)this._textRuns.get(endIndex);
            chpx.setEnd(chpx.getEnd() - endMark + offset);
        }
        for (x = endIndex + 1; x < size; ++x) {
            chpx = (CHPX)this._textRuns.get(x);
            chpx.setStart(chpx.getStart() - length);
            chpx.setEnd(chpx.getEnd() - length);
        }
    }

    public void insert(int listIndex, int cpStart, SprmBuffer buf) {
        boolean needsToBeUnicode = this.tpt.isUnicodeAtCharOffset(cpStart);
        CHPX insertChpx = new CHPX(0, 0, buf, needsToBeUnicode);
        insertChpx.setStart(cpStart);
        insertChpx.setEnd(cpStart);
        if (listIndex == this._textRuns.size()) {
            this._textRuns.add(insertChpx);
        } else {
            CHPX chpx = (CHPX)this._textRuns.get(listIndex);
            if (chpx.getStart() < cpStart) {
                CHPX clone = new CHPX(0, 0, chpx.getSprmBuf(), needsToBeUnicode);
                clone.setStart(cpStart);
                clone.setEnd(chpx.getEnd());
                chpx.setEnd(cpStart);
                this._textRuns.add(listIndex + 1, insertChpx);
                this._textRuns.add(listIndex + 2, clone);
            } else {
                this._textRuns.add(listIndex, insertChpx);
            }
        }
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._textRuns.size();
        CHPX chpx = (CHPX)this._textRuns.get(listIndex);
        chpx.setEnd(chpx.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            chpx = (CHPX)this._textRuns.get(x);
            chpx.setStart(chpx.getStart() + length);
            chpx.setEnd(chpx.getEnd() + length);
        }
    }

    public List getTextRuns() {
        return this._textRuns;
    }

    public void writeTo(HWPFFileSystem sys, int fcMin) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        PlexOfCps binTable = new PlexOfCps(4);
        int docOffset = docStream.getOffset();
        int mod = docOffset % 512;
        if (mod != 0) {
            byte[] padding = new byte[512 - mod];
            docStream.write(padding);
        }
        docOffset = docStream.getOffset();
        int pageNum = docOffset / 512;
        int endingFc = ((PropertyNode)this._textRuns.get(this._textRuns.size() - 1)).getEnd();
        endingFc += fcMin;
        ArrayList overflow = this._textRuns;
        do {
            PropertyNode startingProp = (PropertyNode)overflow.get(0);
            int start = startingProp.getStart() + fcMin;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage();
            cfkp.fill(overflow);
            byte[] bufFkp = cfkp.toByteArray(fcMin);
            docStream.write(bufFkp);
            overflow = cfkp.getOverflow();
            int end = endingFc;
            if (overflow != null) {
                end = ((PropertyNode)overflow.get(0)).getStart() + fcMin;
            }
            byte[] intHolder = new byte[4];
            LittleEndian.putInt(intHolder, pageNum++);
            binTable.addProperty(new GenericPropertyNode(start, end, intHolder));
        } while (overflow != null);
        tableStream.write(binTable.toByteArray());
    }
}

