/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.model.AutoShape;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.util.LittleEndian;

public class Freeform
extends AutoShape {
    public static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    public static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    public static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    public static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    public static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    public static final byte[] SEGMENTINFO_CUBICTO2 = new byte[]{0, -77};
    public static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    public static final byte[] SEGMENTINFO_END = new byte[]{0, -128};

    protected Freeform(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public Freeform(Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(0, parent instanceof ShapeGroup);
    }

    public Freeform() {
        this(null);
    }

    public void setPath(GeneralPath path) {
        Rectangle2D bounds = path.getBounds2D();
        PathIterator it = path.getPathIterator(new AffineTransform());
        ArrayList<byte[]> segInfo = new ArrayList<byte[]>();
        ArrayList<Point2D.Double> pntInfo = new ArrayList<Point2D.Double>();
        boolean isClosed = false;
        while (!it.isDone()) {
            double[] vals = new double[6];
            int type = it.currentSegment(vals);
            switch (type) {
                case 0: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(SEGMENTINFO_MOVETO);
                    break;
                }
                case 1: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_ESCAPE);
                    break;
                }
                case 3: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    pntInfo.add(new Point2D.Double(vals[2], vals[3]));
                    pntInfo.add(new Point2D.Double(vals[4], vals[5]));
                    segInfo.add(SEGMENTINFO_CUBICTO);
                    segInfo.add(SEGMENTINFO_ESCAPE2);
                    break;
                }
                case 2: {
                    this.logger.log(5, "SEG_QUADTO is not supported");
                    break;
                }
                case 4: {
                    pntInfo.add((Point2D.Double)pntInfo.get(0));
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_ESCAPE);
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_CLOSE);
                    isClosed = true;
                }
            }
            it.next();
        }
        if (!isClosed) {
            segInfo.add(SEGMENTINFO_LINETO);
        }
        segInfo.add(new byte[]{0, -128});
        EscherOptRecord opt = (EscherOptRecord)Freeform.getEscherChild(this._escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = new EscherArrayProperty(16709, false, null);
        verticesProp.setNumberOfElementsInArray(pntInfo.size());
        verticesProp.setNumberOfElementsInMemory(pntInfo.size());
        verticesProp.setSizeOfElements(65520);
        for (int i = 0; i < pntInfo.size(); ++i) {
            Point2D.Double pnt = (Point2D.Double)pntInfo.get(i);
            byte[] data = new byte[4];
            LittleEndian.putShort(data, 0, (short)((pnt.getX() - bounds.getX()) * 576.0 / 72.0));
            LittleEndian.putShort(data, 2, (short)((pnt.getY() - bounds.getY()) * 576.0 / 72.0));
            verticesProp.setElement(i, data);
        }
        opt.addEscherProperty(verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(16710, false, null);
        segmentsProp.setNumberOfElementsInArray(segInfo.size());
        segmentsProp.setNumberOfElementsInMemory(segInfo.size());
        segmentsProp.setSizeOfElements(2);
        for (int i = 0; i < segInfo.size(); ++i) {
            byte[] seg = (byte[])segInfo.get(i);
            segmentsProp.setElement(i, seg);
        }
        opt.addEscherProperty(segmentsProp);
        opt.addEscherProperty(new EscherSimpleProperty(322, (int)(bounds.getWidth() * 576.0 / 72.0)));
        opt.addEscherProperty(new EscherSimpleProperty(323, (int)(bounds.getHeight() * 576.0 / 72.0)));
        opt.sortProperties();
        this.setAnchor(bounds);
    }

    public GeneralPath getPath() {
        EscherArrayProperty segmentsProp;
        EscherOptRecord opt = (EscherOptRecord)Freeform.getEscherChild(this._escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = (EscherArrayProperty)Freeform.getEscherProperty(opt, 16709);
        if (verticesProp == null) {
            verticesProp = (EscherArrayProperty)Freeform.getEscherProperty(opt, 325);
        }
        if ((segmentsProp = (EscherArrayProperty)Freeform.getEscherProperty(opt, 16710)) == null) {
            segmentsProp = (EscherArrayProperty)Freeform.getEscherProperty(opt, 326);
        }
        if (verticesProp == null) {
            this.logger.log(5, "Freeform is missing GEOMETRY__VERTICES ");
            return null;
        }
        if (segmentsProp == null) {
            this.logger.log(5, "Freeform is missing GEOMETRY__SEGMENTINFO ");
            return null;
        }
        GeneralPath path = new GeneralPath();
        int numPoints = verticesProp.getNumberOfElementsInArray();
        int numSegments = segmentsProp.getNumberOfElementsInArray();
        int j = 0;
        for (int i = 0; i < numSegments && j < numPoints; ++i) {
            byte[] pnext;
            byte[] elem = segmentsProp.getElement(i);
            if (Arrays.equals(elem, SEGMENTINFO_MOVETO)) {
                byte[] p = verticesProp.getElement(j++);
                short x = LittleEndian.getShort(p, 0);
                short y = LittleEndian.getShort(p, 2);
                path.moveTo((float)x * 72.0f / 576.0f, (float)y * 72.0f / 576.0f);
                continue;
            }
            if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2)) {
                ++i;
                byte[] p1 = verticesProp.getElement(j++);
                short x1 = LittleEndian.getShort(p1, 0);
                short y1 = LittleEndian.getShort(p1, 2);
                byte[] p2 = verticesProp.getElement(j++);
                short x2 = LittleEndian.getShort(p2, 0);
                short y2 = LittleEndian.getShort(p2, 2);
                byte[] p3 = verticesProp.getElement(j++);
                short x3 = LittleEndian.getShort(p3, 0);
                short y3 = LittleEndian.getShort(p3, 2);
                path.curveTo((float)x1 * 72.0f / 576.0f, (float)y1 * 72.0f / 576.0f, (float)x2 * 72.0f / 576.0f, (float)y2 * 72.0f / 576.0f, (float)x3 * 72.0f / 576.0f, (float)y3 * 72.0f / 576.0f);
                continue;
            }
            if (!Arrays.equals(elem, SEGMENTINFO_LINETO)) continue;
            if (Arrays.equals(pnext = segmentsProp.getElement(++i), SEGMENTINFO_ESCAPE)) {
                if (j + 1 >= numPoints) continue;
                byte[] p = verticesProp.getElement(j++);
                short x = LittleEndian.getShort(p, 0);
                short y = LittleEndian.getShort(p, 2);
                path.lineTo((float)x * 72.0f / 576.0f, (float)y * 72.0f / 576.0f);
                continue;
            }
            if (!Arrays.equals(pnext, SEGMENTINFO_CLOSE)) continue;
            path.closePath();
        }
        return path;
    }

    public java.awt.Shape getOutline() {
        GeneralPath path = this.getPath();
        Rectangle2D anchor = this.getAnchor2D();
        Rectangle2D bounds = path.getBounds2D();
        AffineTransform at = new AffineTransform();
        at.translate(anchor.getX(), anchor.getY());
        at.scale(anchor.getWidth() / bounds.getWidth(), anchor.getHeight() / bounds.getHeight());
        return at.createTransformedShape(path);
    }
}

