/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.HierarchyConstraint;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;

public class DescendantNodeConstraint
extends HierarchyConstraint {
    public DescendantNodeConstraint(DescendantNodeImpl constraint, SelectorImpl selector) {
        super(constraint.getPath(), selector);
    }

    public boolean evaluate(ScoreNode[] row, Name[] selectorNames, EvaluationContext context) throws IOException {
        NodeId baseId = this.getBaseNodeId(context);
        if (baseId == null) {
            return false;
        }
        ScoreNode sn = row[this.getSelectorIndex(selectorNames)];
        if (sn == null) {
            return false;
        }
        NodeId id = sn.getNodeId();
        SessionImpl session = context.getSession();
        try {
            NodeImpl parent = session.getNodeById(id);
            while (!(parent = (NodeImpl)parent.getParent()).getId().equals(baseId)) {
            }
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

