/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.XASession;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.jca.AnonymousConnection;
import org.apache.jackrabbit.jca.JCAConnectionManager;
import org.apache.jackrabbit.jca.JCAConnectionRequestInfo;
import org.apache.jackrabbit.jca.JCAManagedConnection;
import org.apache.jackrabbit.jca.JCARepositoryHandle;
import org.apache.jackrabbit.jca.JCARepositoryManager;

public final class JCAManagedConnectionFactory
implements ManagedConnectionFactory {
    private String homeDir;
    private String configFile;
    private Boolean bindSessionToTransaction = Boolean.TRUE;
    private transient RepositoryImpl repository;
    private transient PrintWriter logWriter;

    public String getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(new JCAConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        this.createRepository();
        JCARepositoryHandle handle = new JCARepositoryHandle(this, cm);
        this.log("Created repository handle (" + handle + ")");
        return handle;
    }

    private XASession openSession(JCAConnectionRequestInfo cri) throws ResourceException {
        this.createRepository();
        Credentials creds = cri.getCredentials();
        String workspace = cri.getWorkspace();
        try {
            XASession session = (XASession)this.getRepository().login(creds, workspace);
            this.log("Created session (" + session + ")");
            return session;
        }
        catch (RepositoryException e) {
            this.log("Failed to create session", e);
            ResourceException exception = new ResourceException("Failed to create session: " + e.getMessage());
            exception.setLinkedException((Exception)((Object)e));
            throw exception;
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            return new AnonymousConnection();
        }
        return this.createManagedConnection((JCAConnectionRequestInfo)cri);
    }

    private ManagedConnection createManagedConnection(JCAConnectionRequestInfo cri) throws ResourceException {
        return new JCAManagedConnection(this, cri, this.openSession(cri));
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            JCAConnectionRequestInfo otherCri;
            JCAManagedConnection mc;
            Object next = i.next();
            if (!(next instanceof JCAManagedConnection) || !this.equals((mc = (JCAManagedConnection)next).getManagedConnectionFactory()) || !this.equals(cri, otherCri = mc.getConnectionRequestInfo())) continue;
            return mc;
        }
        return null;
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, Throwable exception) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
            if (exception != null) {
                exception.printStackTrace(this.logWriter);
            }
        }
    }

    public int hashCode() {
        int result = this.homeDir != null ? this.homeDir.hashCode() : 0;
        result = 37 * result + (this.configFile != null ? this.configFile.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JCAManagedConnectionFactory) {
            return this.equals((JCAManagedConnectionFactory)o);
        }
        return false;
    }

    private boolean equals(JCAManagedConnectionFactory o) {
        return this.equals(this.homeDir, o.homeDir) && this.equals(this.configFile, o.configFile);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private void createRepository() throws ResourceException {
        if (this.repository == null) {
            if (this.homeDir == null || this.homeDir.equals("")) {
                throw new ResourceException("Property 'homeDir' not set");
            }
            if (this.configFile == null || this.configFile.equals("")) {
                throw new ResourceException("Property 'configFile' not set");
            }
            try {
                JCARepositoryManager mgr = JCARepositoryManager.getInstance();
                this.repository = mgr.createRepository(this.homeDir, this.configFile);
                this.log("Created repository (" + this.repository + ")");
            }
            catch (RepositoryException e) {
                this.log("Failed to create repository", e);
                ResourceException exception = new ResourceException("Failed to create session: " + e.getMessage());
                exception.setLinkedException((Exception)((Object)e));
                throw exception;
            }
        }
    }

    protected void finalize() {
        JCARepositoryManager mgr = JCARepositoryManager.getInstance();
        mgr.autoShutdownRepository(this.homeDir, this.configFile);
    }

    public Boolean getBindSessionToTransaction() {
        return this.bindSessionToTransaction;
    }

    public void setBindSessionToTransaction(Boolean bindSessionToTransaction) {
        this.bindSessionToTransaction = bindSessionToTransaction;
    }
}

