/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.List;
import org.apache.hive.service.cli.Type;
import org.apache.hive.service.cli.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.cli.thrift.TTypeDesc;
import org.apache.hive.service.cli.thrift.TTypeEntry;

public class TypeDescriptor {
    private final Type type;
    private String typeName = null;

    public TypeDescriptor(Type type) {
        this.type = type;
    }

    public TypeDescriptor(TTypeDesc tTypeDesc) {
        List<TTypeEntry> tTypeEntries = tTypeDesc.getTypes();
        TPrimitiveTypeEntry top = tTypeEntries.get(0).getPrimitiveEntry();
        this.type = Type.getType(top.getType());
    }

    public TypeDescriptor(String typeName) {
        this.type = Type.getType(typeName);
        if (this.type.isComplexType()) {
            this.typeName = typeName;
        }
    }

    public Type getType() {
        return this.type;
    }

    public TTypeDesc toTTypeDesc() {
        TTypeEntry entry = TTypeEntry.primitiveEntry(new TPrimitiveTypeEntry(this.type.toTType()));
        TTypeDesc desc = new TTypeDesc();
        desc.addToTypes(entry);
        return desc;
    }

    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return this.type.getName();
    }
}

