/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@UDFType(deterministic=true)
@Description(name="translate", value="_FUNC_(input, from, to) - translates the input string by replacing the characters present in the from string with the corresponding characters in the to string", extended="_FUNC_(string input, string from, string to) is an equivalent function to translate in PostGreSQL. It works on a character by character basis on the input string (first parameter). A character in the input is checked for presence in the from string (second parameter). If a match happens, the character from to string (third parameter) which appears at the same index as the character in from string is obtained. This character is emitted in the output string  instead of the original character from the input string. If the to string is shorter than the from string, there may not be a character present at the same index in the to string. In such a case, nothing is emitted for the original character and it's deleted from the output string.\nFor example,\n\n_FUNC_('abcdef', 'adc', '19') returns '1b9ef' replacing 'a' with '1', 'd' with '9' and removing 'c' from the input string\n\n_FUNC_('a b c d', ' ', '') return 'abcd' removing all spaces from the input string\n\nIf the same character is present multiple times in the input string, the first occurence of the character is the one that's considered for matching. However, it is not recommended to have the same character more than once in the from string since it's not required and adds to confusion.\n\nFor example,\n\n_FUNC_('abcdef', 'ada', '192') returns '1bc9ef' replaces 'a' with '1' and 'd' with '9' ignoring the second occurence of 'a' in the from string mapping it to '2'")
public class GenericUDFTranslate
extends GenericUDF {
    private Map<Integer, Integer> replacementMap = new HashMap<Integer, Integer>();
    private Set<Integer> deletionSet = new HashSet<Integer>();
    private Text result = new Text();
    private Text lastFrom = null;
    private Text lastTo = null;
    private ObjectInspectorConverters.Converter[] converters;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length != 3) {
            throw new UDFArgumentLengthException("_FUNC_ expects exactly 3 arguments");
        }
        for (i = 0; i < arguments.length; ++i) {
            if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(i, "A string argument was expected but an argument of type " + arguments[i].getTypeName() + " was given.");
            }
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
            if (primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.STRING || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VOID) continue;
            throw new UDFArgumentTypeException(i, "A string argument was expected but an argument of type " + arguments[i].getTypeName() + " was given.");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 3);
        if (arguments[0].get() == null || arguments[1].get() == null || arguments[2].get() == null) {
            return null;
        }
        Text input = (Text)this.converters[0].convert(arguments[0].get());
        Text from = (Text)this.converters[1].convert(arguments[1].get());
        Text to = (Text)this.converters[2].convert(arguments[2].get());
        this.populateMappingsIfNecessary(from, to);
        String resultString = this.processInput(input);
        this.result.set(resultString);
        return this.result;
    }

    private void populateMappingsIfNecessary(Text from, Text to) {
        if (this.lastFrom == null || this.lastTo == null || !from.equals((Object)this.lastFrom) || !to.equals((Object)this.lastTo)) {
            this.populateMappings(from, to);
            if (this.lastFrom == null) {
                this.lastFrom = new Text();
            }
            if (this.lastTo == null) {
                this.lastTo = new Text();
            }
            this.lastFrom.set(from);
            this.lastTo.set(to);
        }
    }

    private void populateMappings(Text from, Text to) {
        this.replacementMap.clear();
        this.deletionSet.clear();
        ByteBuffer fromBytes = ByteBuffer.wrap(from.getBytes(), 0, from.getLength());
        ByteBuffer toBytes = ByteBuffer.wrap(to.getBytes(), 0, to.getLength());
        while (fromBytes.hasRemaining()) {
            int fromCodePoint = Text.bytesToCodePoint((ByteBuffer)fromBytes);
            if (toBytes.hasRemaining()) {
                int toCodePoint = Text.bytesToCodePoint((ByteBuffer)toBytes);
                if (this.replacementMap.containsKey(fromCodePoint) || this.deletionSet.contains(fromCodePoint)) continue;
                this.replacementMap.put(fromCodePoint, toCodePoint);
                continue;
            }
            if (this.replacementMap.containsKey(fromCodePoint) || this.deletionSet.contains(fromCodePoint)) continue;
            this.deletionSet.add(fromCodePoint);
        }
    }

    private String processInput(Text input) {
        StringBuilder resultBuilder = new StringBuilder();
        ByteBuffer inputBytes = ByteBuffer.wrap(input.getBytes(), 0, input.getLength());
        while (inputBytes.hasRemaining()) {
            int inputCodePoint = Text.bytesToCodePoint((ByteBuffer)inputBytes);
            if (this.deletionSet.contains(inputCodePoint)) continue;
            Integer replacementCodePoint = this.replacementMap.get(inputCodePoint);
            char[] charArray = Character.toChars(replacementCodePoint != null ? replacementCodePoint : inputCodePoint);
            resultBuilder.append(charArray);
        }
        String resultString = resultBuilder.toString();
        return resultString;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 3);
        return "translate(" + children[0] + ", " + children[1] + ", " + children[2] + ")";
    }
}

