/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingInferenceOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.CommonJoinResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.IndexWhereResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.MapJoinResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.SkewJoinResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class PhysicalOptimizer {
    private PhysicalContext pctx;
    private List<PhysicalPlanResolver> resolvers;

    public PhysicalOptimizer(PhysicalContext pctx, HiveConf hiveConf) {
        this.pctx = pctx;
        this.initialize(hiveConf);
    }

    private void initialize(HiveConf hiveConf) {
        this.resolvers = new ArrayList<PhysicalPlanResolver>();
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVESKEWJOIN)) {
            this.resolvers.add(new SkewJoinResolver());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN)) {
            this.resolvers.add(new CommonJoinResolver());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER)) {
            this.resolvers.add(new IndexWhereResolver());
        }
        this.resolvers.add(new MapJoinResolver());
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES)) {
            this.resolvers.add(new MetadataOnlyOptimizer());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT)) {
            this.resolvers.add(new BucketingSortingInferenceOptimizer());
        }
    }

    public PhysicalContext optimize() throws SemanticException {
        for (PhysicalPlanResolver r : this.resolvers) {
            this.pctx = r.resolve(this.pctx);
        }
        return this.pctx;
    }
}

