/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.BooleanColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DecimalColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DoubleColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.IntegerColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.StringColumnStatistics;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

class ColumnStatisticsImpl
implements ColumnStatistics {
    private long count = 0L;

    ColumnStatisticsImpl(OrcProto.ColumnStatistics stats) {
        if (stats.hasNumberOfValues()) {
            this.count = stats.getNumberOfValues();
        }
    }

    ColumnStatisticsImpl() {
    }

    void increment() {
        ++this.count;
    }

    void updateBoolean(boolean value) {
        throw new UnsupportedOperationException("Can't update boolean");
    }

    void updateInteger(long value) {
        throw new UnsupportedOperationException("Can't update integer");
    }

    void updateDouble(double value) {
        throw new UnsupportedOperationException("Can't update double");
    }

    void updateString(String value) {
        throw new UnsupportedOperationException("Can't update string");
    }

    void updateDecimal(HiveDecimal value) {
        throw new UnsupportedOperationException("Can't update decimal");
    }

    void merge(ColumnStatisticsImpl stats) {
        this.count += stats.count;
    }

    void reset() {
        this.count = 0L;
    }

    @Override
    public long getNumberOfValues() {
        return this.count;
    }

    public String toString() {
        return "count: " + this.count;
    }

    OrcProto.ColumnStatistics.Builder serialize() {
        OrcProto.ColumnStatistics.Builder builder = OrcProto.ColumnStatistics.newBuilder();
        builder.setNumberOfValues(this.count);
        return builder;
    }

    static ColumnStatisticsImpl create(ObjectInspector inspector) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return new BooleanStatisticsImpl();
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return new IntegerStatisticsImpl();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new DoubleStatisticsImpl();
                    }
                    case STRING: {
                        return new StringStatisticsImpl();
                    }
                    case DECIMAL: {
                        return new DecimalStatisticsImpl();
                    }
                }
                return new ColumnStatisticsImpl();
            }
        }
        return new ColumnStatisticsImpl();
    }

    static ColumnStatisticsImpl deserialize(OrcProto.ColumnStatistics stats) {
        if (stats.hasBucketStatistics()) {
            return new BooleanStatisticsImpl(stats);
        }
        if (stats.hasIntStatistics()) {
            return new IntegerStatisticsImpl(stats);
        }
        if (stats.hasDoubleStatistics()) {
            return new DoubleStatisticsImpl(stats);
        }
        if (stats.hasStringStatistics()) {
            return new StringStatisticsImpl(stats);
        }
        if (stats.hasDecimalStatistics()) {
            return new DecimalStatisticsImpl(stats);
        }
        return new ColumnStatisticsImpl(stats);
    }

    private static final class DecimalStatisticsImpl
    extends ColumnStatisticsImpl
    implements DecimalColumnStatistics {
        private HiveDecimal minimum = null;
        private HiveDecimal maximum = null;
        private HiveDecimal sum = HiveDecimal.ZERO;

        DecimalStatisticsImpl() {
        }

        DecimalStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.DecimalStatistics dec = stats.getDecimalStatistics();
            if (dec.hasMaximum()) {
                this.maximum = new HiveDecimal(dec.getMaximum());
            }
            if (dec.hasMinimum()) {
                this.minimum = new HiveDecimal(dec.getMinimum());
            }
            this.sum = dec.hasSum() ? new HiveDecimal(dec.getSum()) : null;
        }

        @Override
        void reset() {
            super.reset();
            this.minimum = null;
            this.maximum = null;
            this.sum = HiveDecimal.ZERO;
        }

        @Override
        void updateDecimal(HiveDecimal value) {
            if (this.minimum == null) {
                this.minimum = value;
                this.maximum = value;
            } else if (this.minimum.compareTo(value) > 0) {
                this.minimum = value;
            } else if (this.maximum.compareTo(value) < 0) {
                this.maximum = value;
            }
            if (this.sum != null) {
                try {
                    this.sum = this.sum.add(value);
                }
                catch (NumberFormatException nfe) {
                    this.sum = null;
                }
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            DecimalStatisticsImpl dec = (DecimalStatisticsImpl)other;
            if (this.minimum == null) {
                this.minimum = dec.minimum;
                this.maximum = dec.maximum;
                this.sum = dec.sum;
            } else if (dec.minimum != null) {
                if (this.minimum.compareTo(dec.minimum) > 0) {
                    this.minimum = dec.minimum;
                } else if (this.maximum.compareTo(dec.maximum) < 0) {
                    this.maximum = dec.maximum;
                }
                this.sum = this.sum == null || dec.sum == null ? null : this.sum.add(dec.sum);
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.DecimalStatistics.Builder dec = OrcProto.DecimalStatistics.newBuilder();
            if (this.getNumberOfValues() != 0L) {
                dec.setMinimum(this.minimum.toString());
                dec.setMaximum(this.maximum.toString());
            }
            if (this.sum != null) {
                dec.setSum(this.sum.toString());
            }
            result.setDecimalStatistics(dec);
            return result;
        }

        @Override
        public HiveDecimal getMinimum() {
            return this.minimum;
        }

        @Override
        public HiveDecimal getMaximum() {
            return this.maximum;
        }

        @Override
        public HiveDecimal getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
                if (this.sum != null) {
                    buf.append(" sum: ");
                    buf.append(this.sum);
                }
            }
            return buf.toString();
        }
    }

    private static final class StringStatisticsImpl
    extends ColumnStatisticsImpl
    implements StringColumnStatistics {
        private String minimum = null;
        private String maximum = null;

        StringStatisticsImpl() {
        }

        StringStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.StringStatistics str = stats.getStringStatistics();
            if (str.hasMaximum()) {
                this.maximum = str.getMaximum();
            }
            if (str.hasMinimum()) {
                this.minimum = str.getMinimum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.minimum = null;
            this.maximum = null;
        }

        @Override
        void updateString(String value) {
            if (this.minimum == null) {
                this.minimum = value;
                this.maximum = value;
            } else if (this.minimum.compareTo(value) > 0) {
                this.minimum = value;
            } else if (this.maximum.compareTo(value) < 0) {
                this.maximum = value;
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            StringStatisticsImpl str = (StringStatisticsImpl)other;
            if (this.minimum == null) {
                this.minimum = str.minimum;
                this.maximum = str.maximum;
            } else if (str.minimum != null) {
                if (this.minimum.compareTo(str.minimum) > 0) {
                    this.minimum = str.minimum;
                } else if (this.maximum.compareTo(str.maximum) < 0) {
                    this.maximum = str.maximum;
                }
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.StringStatistics.Builder str = OrcProto.StringStatistics.newBuilder();
            if (this.getNumberOfValues() != 0L) {
                str.setMinimum(this.minimum);
                str.setMaximum(this.maximum);
            }
            result.setStringStatistics(str);
            return result;
        }

        @Override
        public String getMinimum() {
            return this.minimum;
        }

        @Override
        public String getMaximum() {
            return this.maximum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
            }
            return buf.toString();
        }
    }

    private static final class DoubleStatisticsImpl
    extends ColumnStatisticsImpl
    implements DoubleColumnStatistics {
        private boolean hasMinimum = false;
        private double minimum = Double.MAX_VALUE;
        private double maximum = Double.MIN_VALUE;
        private double sum = 0.0;

        DoubleStatisticsImpl() {
        }

        DoubleStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.DoubleStatistics dbl = stats.getDoubleStatistics();
            if (dbl.hasMinimum()) {
                this.hasMinimum = true;
                this.minimum = dbl.getMinimum();
            }
            if (dbl.hasMaximum()) {
                this.maximum = dbl.getMaximum();
            }
            if (dbl.hasSum()) {
                this.sum = dbl.getSum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.hasMinimum = false;
            this.minimum = Double.MAX_VALUE;
            this.maximum = Double.MIN_VALUE;
            this.sum = 0.0;
        }

        @Override
        void updateDouble(double value) {
            if (!this.hasMinimum) {
                this.hasMinimum = true;
                this.minimum = value;
                this.maximum = value;
            } else if (value < this.minimum) {
                this.minimum = value;
            } else if (value > this.maximum) {
                this.maximum = value;
            }
            this.sum += value;
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            DoubleStatisticsImpl dbl = (DoubleStatisticsImpl)other;
            if (!this.hasMinimum) {
                this.hasMinimum = dbl.hasMinimum;
                this.minimum = dbl.minimum;
                this.maximum = dbl.maximum;
            } else if (dbl.hasMinimum) {
                if (dbl.minimum < this.minimum) {
                    this.minimum = dbl.minimum;
                }
                if (dbl.maximum > this.maximum) {
                    this.maximum = dbl.maximum;
                }
            }
            this.sum += dbl.sum;
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder builder = super.serialize();
            OrcProto.DoubleStatistics.Builder dbl = OrcProto.DoubleStatistics.newBuilder();
            if (this.hasMinimum) {
                dbl.setMinimum(this.minimum);
                dbl.setMaximum(this.maximum);
            }
            dbl.setSum(this.sum);
            builder.setDoubleStatistics(dbl);
            return builder;
        }

        @Override
        public double getMinimum() {
            return this.minimum;
        }

        @Override
        public double getMaximum() {
            return this.maximum;
        }

        @Override
        public double getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.hasMinimum) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
            }
            buf.append(" sum: ");
            buf.append(this.sum);
            return buf.toString();
        }
    }

    private static final class IntegerStatisticsImpl
    extends ColumnStatisticsImpl
    implements IntegerColumnStatistics {
        private long minimum = Long.MAX_VALUE;
        private long maximum = Long.MIN_VALUE;
        private long sum = 0L;
        private boolean hasMinimum = false;
        private boolean overflow = false;

        IntegerStatisticsImpl() {
        }

        IntegerStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.IntegerStatistics intStat = stats.getIntStatistics();
            if (intStat.hasMinimum()) {
                this.hasMinimum = true;
                this.minimum = intStat.getMinimum();
            }
            if (intStat.hasMaximum()) {
                this.maximum = intStat.getMaximum();
            }
            if (intStat.hasSum()) {
                this.sum = intStat.getSum();
            } else {
                this.overflow = true;
            }
        }

        @Override
        void reset() {
            super.reset();
            this.hasMinimum = false;
            this.minimum = Long.MAX_VALUE;
            this.maximum = Long.MIN_VALUE;
            this.sum = 0L;
            this.overflow = false;
        }

        @Override
        void updateInteger(long value) {
            if (!this.hasMinimum) {
                this.hasMinimum = true;
                this.minimum = value;
                this.maximum = value;
            } else if (value < this.minimum) {
                this.minimum = value;
            } else if (value > this.maximum) {
                this.maximum = value;
            }
            if (!this.overflow) {
                boolean wasPositive = this.sum >= 0L;
                this.sum += value;
                if (value >= 0L == wasPositive) {
                    this.overflow = this.sum >= 0L != wasPositive;
                }
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            IntegerStatisticsImpl otherInt = (IntegerStatisticsImpl)other;
            if (!this.hasMinimum) {
                this.hasMinimum = otherInt.hasMinimum;
                this.minimum = otherInt.minimum;
                this.maximum = otherInt.maximum;
            } else if (otherInt.hasMinimum) {
                if (otherInt.minimum < this.minimum) {
                    this.minimum = otherInt.minimum;
                }
                if (otherInt.maximum > this.maximum) {
                    this.maximum = otherInt.maximum;
                }
            }
            super.merge(other);
            this.overflow |= otherInt.overflow;
            if (!this.overflow) {
                boolean wasPositive = this.sum >= 0L;
                this.sum += otherInt.sum;
                if (otherInt.sum >= 0L == wasPositive) {
                    this.overflow = this.sum >= 0L != wasPositive;
                }
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder builder = super.serialize();
            OrcProto.IntegerStatistics.Builder intb = OrcProto.IntegerStatistics.newBuilder();
            if (this.hasMinimum) {
                intb.setMinimum(this.minimum);
                intb.setMaximum(this.maximum);
            }
            if (!this.overflow) {
                intb.setSum(this.sum);
            }
            builder.setIntStatistics(intb);
            return builder;
        }

        @Override
        public long getMinimum() {
            return this.minimum;
        }

        @Override
        public long getMaximum() {
            return this.maximum;
        }

        @Override
        public boolean isSumDefined() {
            return !this.overflow;
        }

        @Override
        public long getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.hasMinimum) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
            }
            if (!this.overflow) {
                buf.append(" sum: ");
                buf.append(this.sum);
            }
            return buf.toString();
        }
    }

    private static final class BooleanStatisticsImpl
    extends ColumnStatisticsImpl
    implements BooleanColumnStatistics {
        private long trueCount = 0L;

        BooleanStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.BucketStatistics bkt = stats.getBucketStatistics();
            this.trueCount = bkt.getCount(0);
        }

        BooleanStatisticsImpl() {
        }

        @Override
        void reset() {
            super.reset();
            this.trueCount = 0L;
        }

        @Override
        void updateBoolean(boolean value) {
            if (value) {
                ++this.trueCount;
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            BooleanStatisticsImpl bkt = (BooleanStatisticsImpl)other;
            this.trueCount += bkt.trueCount;
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder builder = super.serialize();
            OrcProto.BucketStatistics.Builder bucket = OrcProto.BucketStatistics.newBuilder();
            bucket.addCount(this.trueCount);
            builder.setBucketStatistics(bucket);
            return builder;
        }

        @Override
        public long getFalseCount() {
            return this.getNumberOfValues() - this.trueCount;
        }

        @Override
        public long getTrueCount() {
            return this.trueCount;
        }

        @Override
        public String toString() {
            return super.toString() + " true: " + this.trueCount;
        }
    }
}

