/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.RandomWriter;
import org.apache.hadoop.examples.Sort;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestMiniMRDFSSort
extends TestCase {
    private static final Path SORT_INPUT_PATH = new Path("/sort/input");
    private static final Path SORT_OUTPUT_PATH = new Path("/sort/output");
    private static final int NUM_HADOOP_SLAVES = 3;
    private static final int RW_BYTES_PER_MAP = 0x300000;
    private static final int RW_MAPS_PER_HOST = 2;
    private static MiniMRCluster mrCluster = null;
    private static MiniDFSCluster dfsCluster = null;
    private static FileSystem dfs = null;

    public static Test suite() {
        TestSetup setup = new TestSetup((Test)new TestSuite(TestMiniMRDFSSort.class)){

            protected void setUp() throws Exception {
                Configuration conf = new Configuration();
                dfsCluster = new MiniDFSCluster(conf, 3, true, null);
                dfs = dfsCluster.getFileSystem();
                mrCluster = new MiniMRCluster(3, dfs.getUri().toString(), 1);
            }

            protected void tearDown() throws Exception {
                if (dfsCluster != null) {
                    dfsCluster.shutdown();
                }
                if (mrCluster != null) {
                    mrCluster.shutdown();
                }
            }
        };
        return setup;
    }

    private static void runRandomWriter(JobConf job, Path sortInput) throws Exception {
        job.setInt("test.randomwrite.bytes_per_map", 0x300000);
        job.setInt("test.randomwriter.maps_per_host", 2);
        String[] rwArgs = new String[]{sortInput.toString()};
        TestMiniMRDFSSort.assertEquals((int)ToolRunner.run((Configuration)job, (Tool)new RandomWriter(), (String[])rwArgs), (int)0);
    }

    private static void runSort(JobConf job, Path sortInput, Path sortOutput) throws Exception {
        job.setInt("mapred.job.reuse.jvm.num.tasks", -1);
        job.setInt("io.sort.mb", 1);
        job.setNumMapTasks(12);
        String[] sortArgs = new String[]{sortInput.toString(), sortOutput.toString()};
        Sort sort = new Sort();
        TestMiniMRDFSSort.assertEquals((int)ToolRunner.run((Configuration)job, (Tool)sort, (String[])sortArgs), (int)0);
        Counters counters = sort.getResult().getCounters();
        long mapInput = counters.findCounter((Enum)Task.Counter.MAP_INPUT_BYTES).getValue();
        long hdfsRead = counters.findCounter("FileSystemCounters", "HDFS_BYTES_READ").getValue();
        TestMiniMRDFSSort.assertTrue((String)("map input = " + mapInput + ", hdfs read = " + hdfsRead), ((double)hdfsRead < (double)mapInput * 1.1 && hdfsRead > mapInput ? 1 : 0) != 0);
    }

    private static void runSortValidator(JobConf job, Path sortInput, Path sortOutput) throws Exception {
        String[] svArgs = new String[]{"-sortInput", sortInput.toString(), "-sortOutput", sortOutput.toString()};
        TestMiniMRDFSSort.assertEquals((int)ToolRunner.run((Configuration)job, (Tool)new SortValidator(), (String[])svArgs), (int)0);
    }

    private static void runJvmReuseTest(JobConf job, boolean reuse) throws IOException {
        job.setInt("mapred.job.reuse.jvm.num.tasks", reuse ? -1 : 1);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{SORT_INPUT_PATH});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setOutputFormat(NullOutputFormat.class);
        job.setMapperClass(ReuseDetector.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumMapTasks(24);
        job.setNumReduceTasks(0);
        RunningJob result = JobClient.runJob((JobConf)job);
        long uses = result.getCounters().findCounter("jvm", "use").getValue();
        int maps = job.getNumMapTasks();
        if (reuse) {
            TestMiniMRDFSSort.assertTrue((String)("maps = " + maps + ", uses = " + uses), ((long)maps < uses ? 1 : 0) != 0);
        } else {
            TestMiniMRDFSSort.assertEquals((String)"uses should be number of maps", (long)job.getNumMapTasks(), (long)uses);
        }
    }

    public void testMapReduceSort() throws Exception {
        TestMiniMRDFSSort.runRandomWriter(mrCluster.createJobConf(), SORT_INPUT_PATH);
        TestMiniMRDFSSort.runSort(mrCluster.createJobConf(), SORT_INPUT_PATH, SORT_OUTPUT_PATH);
        TestMiniMRDFSSort.runSortValidator(mrCluster.createJobConf(), SORT_INPUT_PATH, SORT_OUTPUT_PATH);
    }

    public void testJvmReuse() throws Exception {
        TestMiniMRDFSSort.runJvmReuseTest(mrCluster.createJobConf(), true);
    }

    public void testNoJvmReuse() throws Exception {
        TestMiniMRDFSSort.runJvmReuseTest(mrCluster.createJobConf(), false);
    }

    private static class ReuseDetector
    extends MapReduceBase
    implements Mapper<BytesWritable, BytesWritable, Text, Text> {
        static int instances = 0;
        Reporter reporter = null;

        private ReuseDetector() {
        }

        public void map(BytesWritable key, BytesWritable value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            this.reporter = reporter;
        }

        public void close() throws IOException {
            this.reporter.incrCounter("jvm", "use", (long)(++instances));
        }
    }
}

