/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class TestQuota
extends TestCase {
    private void runCommand(DFSAdmin admin, boolean expectError, String ... args) throws Exception {
        this.runCommand(admin, args, expectError);
    }

    private void runCommand(DFSAdmin admin, String[] args, boolean expectEror) throws Exception {
        int val = admin.run(args);
        if (expectEror) {
            TestQuota.assertEquals((int)val, (int)-1);
        } else {
            TestQuota.assertTrue((val >= 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuotaCommands() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.block.size", "512");
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fs = cluster.getFileSystem();
        TestQuota.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSAdmin admin = new DFSAdmin(conf);
        try {
            FSDataOutputStream fout;
            int fileLen = 1024;
            int replication = 5;
            long spaceQuota = 9600L;
            Path parent = new Path("/test");
            TestQuota.assertTrue((boolean)dfs.mkdirs(parent));
            String[] args = new String[]{"-setQuota", "3", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", "2t", parent.toString());
            TestQuota.assertEquals((long)0x20000000000L, (long)dfs.getContentSummary(parent).getSpaceQuota());
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(9600L), parent.toString());
            Path childDir0 = new Path(parent, "data0");
            TestQuota.assertTrue((boolean)dfs.mkdirs(childDir0));
            Path childFile0 = new Path(parent, "datafile0");
            DFSTestUtil.createFile(fs, childFile0, 1024L, (short)5, 0L);
            ContentSummary c = dfs.getContentSummary(parent);
            TestQuota.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            TestQuota.assertEquals((long)c.getQuota(), (long)3L);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)5120L);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)9600L);
            c = dfs.getContentSummary(childDir0);
            TestQuota.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)1L);
            TestQuota.assertEquals((long)c.getQuota(), (long)-1L);
            c = dfs.getContentSummary(parent);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)5120L);
            Path childDir1 = new Path(parent, "data1");
            boolean hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.mkdirs(childDir1));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            Path childFile1 = new Path(parent, "datafile1");
            hasException = false;
            try {
                fout = dfs.create(childFile1);
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            this.runCommand(admin, new String[]{"-clrQuota", parent.toString()}, false);
            c = dfs.getContentSummary(parent);
            TestQuota.assertEquals((long)c.getQuota(), (long)-1L);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)9600L);
            this.runCommand(admin, new String[]{"-clrQuota", childDir0.toString()}, false);
            c = dfs.getContentSummary(childDir0);
            TestQuota.assertEquals((long)c.getQuota(), (long)-1L);
            fout = dfs.create(childFile1, (short)5);
            hasException = false;
            try {
                fout.write(new byte[1024]);
                fout.close();
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
                IOUtils.closeStream((Closeable)fout);
            }
            TestQuota.assertTrue((boolean)hasException);
            dfs.delete(childFile1, false);
            this.runCommand(admin, false, "-clrSpaceQuota", parent.toString());
            c = dfs.getContentSummary(parent);
            TestQuota.assertEquals((long)c.getQuota(), (long)-1L);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)-1L);
            DFSTestUtil.createFile((FileSystem)dfs, childFile1, 1024L, (short)5, 0L);
            args = new String[]{"-setQuota", "1", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(1024), args[2]);
            args = new String[]{"-setQuota", "1", childDir0.toString()};
            this.runCommand(admin, args, false);
            hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.mkdirs(new Path(childDir0, "in")));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            c = dfs.getContentSummary(childDir0);
            TestQuota.assertEquals((long)(c.getDirectoryCount() + c.getFileCount()), (long)1L);
            TestQuota.assertEquals((long)c.getQuota(), (long)1L);
            Path nonExistentPath = new Path("/test1");
            TestQuota.assertFalse((boolean)dfs.exists(nonExistentPath));
            args = new String[]{"-setQuota", "1", nonExistentPath.toString()};
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", "1g", nonExistentPath.toString());
            TestQuota.assertTrue((boolean)dfs.isFile(childFile0));
            args[1] = childFile0.toString();
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", "1t", args[1]);
            args[0] = "-clrQuota";
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-clrSpaceQuota", args[1]);
            args[1] = nonExistentPath.toString();
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-clrSpaceQuota", args[1]);
            args = new String[]{"-setQuota", "0", parent.toString()};
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", "0", args[2]);
            args[1] = "-1";
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
            args[1] = String.valueOf(Long.MIN_VALUE);
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
            args[1] = "33aa1.5";
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
            this.runCommand(admin, true, "-setSpaceQuota", "8796093023231m", args[2]);
            UnixUserGroupInformation.saveToConf((Configuration)conf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)new UnixUserGroupInformation(new String[]{"userxx\n", "groupyy\n"}));
            DFSAdmin userAdmin = new DFSAdmin(conf);
            args[1] = "100";
            this.runCommand(userAdmin, args, true);
            this.runCommand(userAdmin, true, "-setSpaceQuota", "1g", args[2]);
            args = new String[]{"-clrQuota", parent.toString()};
            this.runCommand(userAdmin, args, true);
            this.runCommand(userAdmin, true, "-clrSpaceQuota", args[1]);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamespaceCommands() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fs = cluster.getFileSystem();
        TestQuota.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            TestQuota.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/qdir1/qdir20/nqdir30")));
            Path quotaDir1 = new Path("/nqdir0/qdir1");
            dfs.setQuota(quotaDir1, 6L, Long.MAX_VALUE);
            ContentSummary c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)3L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
            Path quotaDir2 = new Path("/nqdir0/qdir1/qdir20");
            dfs.setQuota(quotaDir2, 7L, Long.MAX_VALUE);
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)2L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            Path quotaDir3 = new Path("/nqdir0/qdir1/qdir21");
            TestQuota.assertTrue((boolean)dfs.mkdirs(quotaDir3));
            dfs.setQuota(quotaDir3, 2L, Long.MAX_VALUE);
            c = dfs.getContentSummary(quotaDir3);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)1L);
            TestQuota.assertEquals((long)c.getQuota(), (long)2L);
            Path tempPath = new Path(quotaDir3, "nqdir32");
            TestQuota.assertTrue((boolean)dfs.mkdirs(tempPath));
            c = dfs.getContentSummary(quotaDir3);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)2L);
            TestQuota.assertEquals((long)c.getQuota(), (long)2L);
            tempPath = new Path(quotaDir3, "nqdir33");
            boolean hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.mkdirs(tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            c = dfs.getContentSummary(quotaDir3);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)2L);
            TestQuota.assertEquals((long)c.getQuota(), (long)2L);
            tempPath = new Path(quotaDir2, "nqdir31");
            TestQuota.assertTrue((boolean)dfs.mkdirs(tempPath));
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)3L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)6L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
            tempPath = new Path(quotaDir2, "nqdir33");
            hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.mkdirs(tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            tempPath = new Path(quotaDir2, "nqdir30");
            dfs.rename(new Path(quotaDir3, "nqdir32"), tempPath);
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)4L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)6L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
            hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.rename(tempPath, quotaDir3));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            TestQuota.assertTrue((boolean)dfs.exists(tempPath));
            TestQuota.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir30")));
            hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.rename(tempPath, new Path(quotaDir3, "nqdir32")));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            TestQuota.assertTrue((boolean)dfs.exists(tempPath));
            TestQuota.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir32")));
            TestQuota.assertTrue((boolean)dfs.rename(tempPath, new Path("/nqdir0")));
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)2L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)4L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
            TestQuota.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/nqdir30/nqdir33")));
            hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.rename(new Path("/nqdir0/nqdir30"), tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            TestQuota.assertTrue((boolean)dfs.rename(quotaDir3, quotaDir2));
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)4L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)3L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            tempPath = new Path(quotaDir2, "qdir21");
            c = dfs.getContentSummary(tempPath);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)1L);
            TestQuota.assertEquals((long)c.getQuota(), (long)2L);
            dfs.delete(tempPath, true);
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)2L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)3L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
            TestQuota.assertTrue((boolean)dfs.rename(new Path("/nqdir0/nqdir30"), quotaDir2));
            c = dfs.getContentSummary(quotaDir2);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)5L);
            TestQuota.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getDirectoryCount(), (long)6L);
            TestQuota.assertEquals((long)c.getQuota(), (long)6L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSpaceCommands() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.block.size", "512");
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fs = cluster.getFileSystem();
        TestQuota.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            int fileLen = 1024;
            short replication = 3;
            int fileSpace = fileLen * replication;
            TestQuota.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/qdir1/qdir20/nqdir30")));
            Path quotaDir1 = new Path("/nqdir0/qdir1");
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(4 * fileSpace));
            ContentSummary c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
            Path quotaDir20 = new Path("/nqdir0/qdir1/qdir20");
            dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(6 * fileSpace));
            c = dfs.getContentSummary(quotaDir20);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)(6 * fileSpace));
            Path quotaDir21 = new Path("/nqdir0/qdir1/qdir21");
            TestQuota.assertTrue((boolean)dfs.mkdirs(quotaDir21));
            dfs.setQuota(quotaDir21, Long.MAX_VALUE, (long)(2 * fileSpace));
            c = dfs.getContentSummary(quotaDir21);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
            Path tempPath = new Path(quotaDir21, "nqdir32");
            TestQuota.assertTrue((boolean)dfs.mkdirs(tempPath));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(tempPath, "fileDir/file1"), fileLen, replication, 0L);
            c = dfs.getContentSummary(quotaDir21);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            boolean hasException = false;
            try {
                DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir21, "nqdir33/file2"), 2 * fileLen, replication, 0L);
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            TestQuota.assertTrue((boolean)dfs.delete(new Path(quotaDir21, "nqdir33"), true));
            c = dfs.getContentSummary(quotaDir21);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
            c = dfs.getContentSummary(quotaDir20);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            Path dstPath = new Path(quotaDir20, "nqdir30");
            Path srcPath = new Path(quotaDir21, "nqdir32");
            TestQuota.assertTrue((boolean)dfs.rename(srcPath, dstPath));
            c = dfs.getContentSummary(quotaDir20);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            c = dfs.getContentSummary(quotaDir21);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            Path file2 = new Path(dstPath, "fileDir/file2");
            int file2Len = 2 * fileLen;
            DFSTestUtil.createFile((FileSystem)dfs, file2, file2Len, replication, 0L);
            c = dfs.getContentSummary(quotaDir20);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = dfs.getContentSummary(quotaDir21);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            hasException = false;
            try {
                TestQuota.assertFalse((boolean)dfs.rename(dstPath, srcPath));
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            TestQuota.assertFalse((boolean)dfs.exists(srcPath));
            TestQuota.assertTrue((boolean)dfs.exists(dstPath));
            c = dfs.getContentSummary(quotaDir20);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = dfs.getContentSummary(quotaDir21);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            c = dfs.getContentSummary(quotaDir1);
            TestQuota.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
            c = dfs.getContentSummary(dstPath);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            FSDataOutputStream out = dfs.append(file2);
            out.write(new byte[fileLen]);
            out.close();
            file2Len += fileLen;
            c = dfs.getContentSummary(dstPath);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(4 * fileSpace));
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(5 * fileSpace));
            out = dfs.append(file2);
            hasException = false;
            try {
                out.write(new byte[fileLen + 1024]);
                out.flush();
                out.close();
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
                IOUtils.closeStream((Closeable)out);
            }
            TestQuota.assertTrue((boolean)hasException);
            file2Len += fileLen;
            c = dfs.getContentSummary(dstPath);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace));
            dfs.setReplication(file2, (short)(replication - 1));
            c = dfs.getContentSummary(dstPath);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace - file2Len));
            hasException = false;
            try {
                dfs.setReplication(file2, (short)(replication + 1));
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            TestQuota.assertTrue((boolean)hasException);
            c = dfs.getContentSummary(dstPath);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace - file2Len));
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(10 * fileSpace));
            dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(10 * fileSpace));
            dfs.setReplication(file2, (short)(replication + 1));
            c = dfs.getContentSummary(dstPath);
            TestQuota.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace + file2Len));
        }
        finally {
            cluster.shutdown();
        }
    }
}

