/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestViewFileSystemHdfs
extends ViewFileSystemBaseTest {
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static Path defaultWorkingDirectory2;
    private static Configuration CONF;
    private static FileSystem fHdfs;
    private static FileSystem fHdfs2;
    private FileSystem fsTarget2;
    Path targetTestRoot2;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper("/tmp/TestViewFileSystemHdfs");
    }

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem(0);
        fHdfs2 = cluster.getFileSystem(1);
        fHdfs.getConf().set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        fHdfs2.getConf().set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        defaultWorkingDirectory = fHdfs.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        defaultWorkingDirectory2 = fHdfs2.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fHdfs.mkdirs(defaultWorkingDirectory);
        fHdfs2.mkdirs(defaultWorkingDirectory2);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        cluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.fsTarget2 = fHdfs2;
        this.targetTestRoot2 = new FileSystemTestHelper().getAbsoluteTestRootPath(this.fsTarget2);
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    void setupMountPoints() {
        super.setupMountPoints();
        ConfigUtil.addLink((Configuration)this.conf, (String)"/mountOnNn2", (URI)new Path(this.targetTestRoot2, "mountOnNn2").toUri());
    }

    int getExpectedDirPaths() {
        return 8;
    }

    int getExpectedMountPoints() {
        return 9;
    }

    int getExpectedDelegationTokenCount() {
        return 2;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 2;
    }

    static {
        CONF = new Configuration();
    }
}

