/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.plugins.event.internal.EventCollector;
import org.apache.felix.webconsole.plugins.event.internal.EventInfo;
import org.apache.felix.webconsole.plugins.event.internal.PropertiesEditorSupport;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class PluginServlet
extends HttpServlet {
    private static final String ACTION_POST = "post";
    private static final String ACTION_SEND = "send";
    private static final String ACTION_CLEAR = "clear";
    private static final String PARAMETER_ACTION = "action";
    private final EventCollector collector = new EventCollector(null);
    private volatile boolean configAdminAvailable = false;
    private EventAdmin eventAdmin;
    private final String TEMPLATE = this.readTemplateFile(((Object)((Object)this)).getClass(), "/res/events.html");

    private final String readTemplateFile(Class clazz, String templateFile) {
        InputStream templateStream = ((Object)((Object)this)).getClass().getResourceAsStream(templateFile);
        if (templateStream != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            try {
                int len = 0;
                while ((len = templateStream.read(data)) > 0) {
                    baos.write(data, 0, len);
                }
                String string = baos.toString("UTF-8");
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("readTemplateFile: Error loading " + templateFile + ": " + e);
            }
            finally {
                try {
                    templateStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.log("readTemplateFile: File '" + templateFile + "' not found through class " + clazz);
        return "";
    }

    private static final Event newEvent(HttpServletRequest request) {
        String topic = request.getParameter("topic");
        return new Event(topic, (Dictionary)PropertiesEditorSupport.convertProperties(request));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter(PARAMETER_ACTION);
        if (ACTION_POST.equals(action)) {
            Event event = PluginServlet.newEvent(req);
            this.eventAdmin.postEvent(event);
        } else if (ACTION_SEND.equals(action)) {
            Event event = PluginServlet.newEvent(req);
            this.eventAdmin.sendEvent(event);
        } else if (ACTION_CLEAR.equals(action)) {
            this.collector.clear();
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter());
    }

    private void renderJSON(PrintWriter pw) throws IOException {
        List events = this.collector.getEvents();
        StringBuffer statusLine = new StringBuffer();
        statusLine.append(events.size());
        statusLine.append(" Event");
        if (events.size() != 1) {
            statusLine.append('s');
        }
        statusLine.append(" received");
        if (!events.isEmpty()) {
            statusLine.append(" since ");
            Date d = new Date();
            d.setTime(((EventInfo)events.get((int)0)).received);
            statusLine.append(d);
        }
        statusLine.append(". (Event admin: ");
        if (this.eventAdmin == null) {
            statusLine.append("un");
        }
        statusLine.append("available; Config admin: ");
        if (!this.configAdminAvailable) {
            statusLine.append("un");
        }
        statusLine.append("available)");
        long startTime = this.collector.getStartTime();
        long endTime = events.size() == 0 ? startTime : ((EventInfo)events.get((int)(events.size() - 1))).received;
        float scale = endTime == startTime ? 100.0f : 100.0f / (float)(endTime - startTime);
        pw.write("{");
        this.jsonKey(pw, "status");
        this.jsonValue(pw, statusLine.toString());
        pw.write(44);
        this.jsonKey(pw, "data");
        pw.write(91);
        for (int index = events.size() - 1; index >= 0; --index) {
            this.eventJson(pw, (EventInfo)events.get(index), index, startTime, scale);
            if (index <= 0) continue;
            pw.write(44);
        }
        pw.write(93);
        pw.write("}");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw);
            return;
        }
        this.renderContent(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.print(this.TEMPLATE);
    }

    public URL getResource(String path) {
        if (path.startsWith("/events/res/ui/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(7));
        }
        return null;
    }

    private void jsonValue(PrintWriter pw, String v) throws IOException {
        if (v == null || v.length() == 0) {
            pw.write("\"\"");
            return;
        }
        pw.write(34);
        int previousChar = 0;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    pw.write(92);
                    pw.write(c);
                    break;
                }
                case '/': {
                    if (previousChar == 60) {
                        pw.write(92);
                    }
                    pw.write(c);
                    break;
                }
                case '\b': {
                    pw.write("\\b");
                    break;
                }
                case '\t': {
                    pw.write("\\t");
                    break;
                }
                case '\n': {
                    pw.write("\\n");
                    break;
                }
                case '\f': {
                    pw.write("\\f");
                    break;
                }
                case '\r': {
                    pw.write("\\r");
                    break;
                }
                default: {
                    if (c < ' ') {
                        String hexValue = "000" + Integer.toHexString(c);
                        pw.write("\\u");
                        pw.write(hexValue.substring(hexValue.length() - 4));
                        break;
                    }
                    pw.write(c);
                }
            }
            previousChar = c;
        }
        pw.write(34);
    }

    private void jsonValue(PrintWriter pw, long l) {
        pw.write(Long.toString(l));
    }

    private void jsonKey(PrintWriter pw, String key) throws IOException {
        this.jsonValue(pw, key);
        pw.write(58);
    }

    private void eventJson(PrintWriter jw, EventInfo info, int index, long start, float scale) throws IOException {
        long msec = info.received - start;
        int percent = Math.max((int)((float)msec * scale), 2);
        jw.write("{");
        this.jsonKey(jw, "id");
        this.jsonValue(jw, String.valueOf(index));
        jw.write(44);
        this.jsonKey(jw, "offset");
        this.jsonValue(jw, msec);
        jw.write(44);
        this.jsonKey(jw, "width");
        this.jsonValue(jw, percent);
        jw.write(44);
        this.jsonKey(jw, "category");
        this.jsonValue(jw, info.category);
        jw.write(44);
        this.jsonKey(jw, "received");
        this.jsonValue(jw, info.received);
        jw.write(44);
        this.jsonKey(jw, "topic");
        this.jsonValue(jw, info.topic);
        if (info.info != null) {
            jw.write(44);
            this.jsonKey(jw, "info");
            this.jsonValue(jw, info.info);
        }
        jw.write(44);
        this.jsonKey(jw, "properties");
        jw.write("{");
        if (info.properties != null && info.properties.size() > 0) {
            Iterator i = info.properties.entrySet().iterator();
            boolean first = true;
            while (i.hasNext()) {
                Map.Entry current = i.next();
                if (!first) {
                    jw.write(44);
                }
                first = false;
                this.jsonKey(jw, current.getKey().toString());
                Object value = current.getValue();
                if (value.getClass().isArray()) {
                    StringBuffer b = new StringBuffer("[");
                    int arrayLength = Array.getLength(value);
                    for (int m = 0; m < arrayLength; ++m) {
                        if (m > 0) {
                            b.append(", ");
                        }
                        b.append(Array.get(value, m).toString());
                    }
                    b.append(']');
                    this.jsonValue(jw, b.toString());
                    continue;
                }
                this.jsonValue(jw, value.toString());
            }
        }
        jw.write("}");
        jw.write("}");
    }

    public void updateConfiguration(Dictionary dict) {
        this.collector.updateConfiguration(dict);
    }

    public EventCollector getCollector() {
        return this.collector;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setConfigAdminAvailable(boolean flag) {
        this.configAdminAvailable = flag;
    }
}

