/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.apache.directory.shared.ldap.message.ArrayNamingEnumeration;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class LockableAttributesImpl
implements Attributes {
    static final transient long serialVersionUID = 1L;
    private Map keyMap = new HashMap();

    public LockableAttributesImpl() {
    }

    public LockableAttributesImpl(boolean ignoreCase) {
    }

    public LockableAttributesImpl(String id, Object value) {
        this.put(id, value);
    }

    public LockableAttributesImpl(String id, Object value, boolean ignoreCase) {
        this.put(id, value);
    }

    public boolean isCaseIgnored() {
        return true;
    }

    public int size() {
        return this.keyMap.size();
    }

    public Attribute get(String attrId) {
        if (attrId != null) {
            String key = this.idToLowerCase(attrId);
            Holder holder = (Holder)this.keyMap.get(key);
            return holder != null ? holder.attribute : null;
        }
        return null;
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(new AttributeIterator(this));
    }

    public NamingEnumeration getIDs() {
        Object[] ids = new String[this.keyMap.size()];
        Iterator values = this.keyMap.values().iterator();
        int i = 0;
        while (values.hasNext()) {
            ids[i++] = ((Holder)values.next()).upId;
        }
        return new ArrayNamingEnumeration(ids);
    }

    public Attribute put(String attrId, Object val) {
        LockableAttributeImpl attr = new LockableAttributeImpl(attrId);
        attr.add(val);
        String key = this.idToLowerCase(attrId);
        this.keyMap.put(key, new Holder(attrId, attr));
        return attr;
    }

    public Attribute put(Attribute attr) {
        String id = attr.getID();
        String key = this.idToLowerCase(id);
        Attribute old = null;
        Attribute newAttr = attr;
        old = this.keyMap.containsKey(key) ? ((Holder)this.keyMap.remove(key)).attribute : attr;
        if (attr instanceof LockableAttributeImpl) {
            newAttr = attr;
        } else if (attr instanceof BasicAttribute) {
            newAttr = new LockableAttributeImpl(id);
            try {
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    newAttr.add(AttributeUtils.cloneValue(values.next()));
                }
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        this.keyMap.put(key, new Holder(id, newAttr));
        return old;
    }

    public Attribute remove(String attrId) {
        String key = this.idToLowerCase(attrId);
        if (this.keyMap.containsKey(key)) {
            Holder holder = (Holder)this.keyMap.remove(key);
            if (holder != null) {
                return holder.attribute;
            }
            return null;
        }
        return null;
    }

    private String idToLowerCase(String id) {
        String key = null;
        key = "+".equals(id) || "*".equals(id) ? id : StringTools.toLowerCase(id);
        return key;
    }

    public Object clone() {
        try {
            LockableAttributesImpl clone = (LockableAttributesImpl)super.clone();
            clone.keyMap = new HashMap(this.keyMap.size());
            Iterator keys = this.keyMap.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Holder holder = (Holder)this.keyMap.get(key);
                clone.keyMap.put(key, holder.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator attrs = this.keyMap.values().iterator();
        while (attrs.hasNext()) {
            Holder holder = (Holder)attrs.next();
            Attribute attr = holder.attribute;
            buf.append(holder.upId);
            buf.append(": ");
            buf.append(attr);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LockableAttributesImpl)) {
            return false;
        }
        Attributes attrs = (Attributes)obj;
        if (attrs.size() != this.size()) {
            return false;
        }
        if (attrs.isCaseIgnored() != this.isCaseIgnored()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> list = attrs.getAll();
        while (list.hasMoreElements()) {
            Attribute attr = (Attribute)list.nextElement();
            Attribute myAttr = this.get(attr.getID());
            if (myAttr == null) {
                return false;
            }
            if (myAttr.equals(attr)) continue;
            return false;
        }
        return true;
    }

    public class AttributeIterator
    implements Iterator {
        private Iterator iterator;

        private AttributeIterator(LockableAttributesImpl attributes) {
            this.iterator = attributes.keyMap.values().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return ((Holder)this.iterator.next()).attribute;
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private class Holder
    implements Serializable,
    Cloneable {
        static final transient long serialVersionUID = 1L;
        private String upId;
        private Attribute attribute;

        private Holder(String upId, Attribute attribute) {
            this.upId = upId;
            this.attribute = attribute;
        }

        public Object clone() throws CloneNotSupportedException {
            Holder clone = (Holder)super.clone();
            clone.upId = this.upId;
            if (this.attribute instanceof BasicAttribute) {
                clone.attribute = new LockableAttributeImpl(this.attribute.getID());
                try {
                    NamingEnumeration<?> values = this.attribute.getAll();
                    while (values.hasMoreElements()) {
                        Object value = values.nextElement();
                        if (value instanceof byte[]) {
                            byte[] oldValue = (byte[])value;
                            byte[] newValue = new byte[oldValue.length];
                            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
                            clone.attribute.add(newValue);
                            continue;
                        }
                        clone.attribute.add(value);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            clone.attribute = (Attribute)this.attribute.clone();
            return clone;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.upId).append(": ");
            sb.append(this.attribute).append('\n');
            return sb.toString();
        }
    }
}

