/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.messages.AuthenticationReply;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class BuildReply
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)((Object)session.getAttribute(this.getContextKey()));
        KdcRequest request = authContext.getRequest();
        Ticket ticket = authContext.getTicket();
        AuthenticationReply reply = new AuthenticationReply();
        reply.setClientPrincipal(request.getClientPrincipal());
        reply.setTicket(ticket);
        reply.setKey(ticket.getSessionKey());
        reply.setLastRequest(new LastRequest());
        reply.setNonce(request.getNonce());
        reply.setFlags(ticket.getFlags());
        reply.setAuthTime(ticket.getAuthTime());
        reply.setStartTime(ticket.getStartTime());
        reply.setEndTime(ticket.getEndTime());
        if (ticket.getFlags().get(8)) {
            reply.setRenewTill(ticket.getRenewTill());
        }
        reply.setServerPrincipal(ticket.getServerPrincipal());
        reply.setClientAddresses(ticket.getClientAddresses());
        authContext.setReply((KerberosMessage)reply);
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

