/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.protocol.KerberosProtocolHandler;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosServer {
    private static final Logger log = LoggerFactory.getLogger((Class)KerberosServer.class);
    private KdcConfiguration config;
    private IoAcceptor acceptor;
    private PrincipalStore store;
    private IoHandler handler;

    public KerberosServer(KdcConfiguration config, IoAcceptor acceptor, IoServiceConfig serviceConfig, PrincipalStore store) {
        this.config = config;
        this.acceptor = acceptor;
        this.store = store;
        String name = config.getName();
        int port = config.getPort();
        try {
            this.handler = new KerberosProtocolHandler(new KdcConfiguration(), this.store);
            acceptor.bind((SocketAddress)new InetSocketAddress(port), this.handler, serviceConfig);
            log.debug(name + " listening on port " + port);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public boolean isDifferent(Dictionary newConfig) {
        return this.config.isDifferent(newConfig);
    }

    public void destroy() {
        this.acceptor.unbind((SocketAddress)new InetSocketAddress(this.config.getPort()));
        this.acceptor = null;
        this.handler = null;
        log.debug(this.config.getName() + " has stopped listening on port " + this.config.getPort());
    }
}

