/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import org.apache.directory.api.i18n.I18n;

public class BitString {
    public static final BitString EMPTY_STRING = new BitString(1);
    private int nbUnusedBits;
    private byte[] bytes;
    private int nbBytes;
    private int nbBits;

    public BitString(int length) {
        if (length <= 0) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00000_NULL_OR_NEG_LENGTH_NOT_ALLOWED, (Object[])new Object[0]));
        }
        this.nbBits = length;
        this.nbBytes = length / 8;
        if (length % 8 != 0) {
            ++this.nbBytes;
        }
        this.nbUnusedBits = 8 - length % 8 & 7;
        this.bytes = new byte[this.nbBytes];
    }

    public BitString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.nbBits = -1;
            return;
        }
        this.setData(bytes);
    }

    public void setData(byte[] data) {
        if (data == null || data.length == 0) {
            this.nbBits = -1;
            return;
        }
        this.nbUnusedBits = data[0] & 7;
        this.nbBytes = data.length - 1;
        this.nbBits = this.nbBytes * 8 - this.nbUnusedBits;
        this.bytes = new byte[this.nbBytes];
        for (int i = 0; i < this.nbBytes; ++i) {
            this.bytes[i] = data[i + 1];
        }
    }

    public byte[] getData() {
        byte[] copy = new byte[this.bytes.length + 1];
        System.arraycopy(this.bytes, 0, copy, 1, this.bytes.length);
        copy[0] = (byte)this.nbUnusedBits;
        return copy;
    }

    public byte getUnusedBits() {
        return (byte)this.nbUnusedBits;
    }

    public void setBit(int pos) {
        if (pos < 0 || pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00001_BIT_NUMBER_OUT_OF_BOUND, (Object[])new Object[0]));
        }
        int posBytes = pos >>> 3;
        int bitNumber = 7 - pos % 8;
        byte mask = (byte)(1 << bitNumber);
        int n = posBytes;
        this.bytes[n] = (byte)(this.bytes[n] | mask);
    }

    public void clearBit(int pos) {
        if (pos < 0 || pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00001_BIT_NUMBER_OUT_OF_BOUND, (Object[])new Object[0]));
        }
        int posBytes = pos >>> 3;
        int bitNumber = 7 - pos % 8;
        byte mask = (byte)(1 << bitNumber);
        int n = posBytes;
        this.bytes[n] = (byte)(this.bytes[n] & ~mask);
    }

    public boolean getBit(int pos) {
        if (pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00002_CANNOT_FIND_BIT, (Object[])new Object[]{pos, this.nbBits}));
        }
        int posBytes = pos >>> 3;
        int bitNumber = 7 - pos % 8;
        byte mask = (byte)(1 << bitNumber);
        int res = this.bytes[posBytes] & mask;
        return res != 0;
    }

    public int size() {
        return this.nbBits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nbBits; ++i) {
            if (this.getBit(i)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

