/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.message.Message;

public class Servlet3ContinuationProvider
implements ContinuationProvider {
    HttpServletRequest req;
    HttpServletResponse resp;
    Message inMessage;
    Servlet3Continuation continuation;

    public Servlet3ContinuationProvider(HttpServletRequest req, HttpServletResponse resp, Message inMessage) {
        this.inMessage = inMessage;
        this.req = req;
        this.resp = resp;
    }

    public Continuation getContinuation() {
        if (this.inMessage.getExchange().isOneWay()) {
            return null;
        }
        if (this.continuation == null) {
            this.continuation = new Servlet3Continuation();
        }
        return this.continuation;
    }

    public class Servlet3Continuation
    implements Continuation,
    AsyncListener {
        final AsyncContext context;
        volatile boolean isNew;
        volatile boolean isResumed;
        volatile boolean isPending;
        volatile Object obj;
        private ContinuationCallback callback;

        public Servlet3Continuation() {
            boolean bl = this.isNew = Servlet3ContinuationProvider.this.req.getAttribute("cxf.continuation.message") == null;
            if (this.isNew) {
                Servlet3ContinuationProvider.this.req.setAttribute("cxf.continuation.message", (Object)Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage());
                this.callback = (ContinuationCallback)Servlet3ContinuationProvider.this.inMessage.getExchange().get(ContinuationCallback.class);
                this.context = Servlet3ContinuationProvider.this.req.startAsync((ServletRequest)Servlet3ContinuationProvider.this.req, (ServletResponse)Servlet3ContinuationProvider.this.resp);
                Servlet3ContinuationProvider.this.req.setAttribute("cxf.async.context", (Object)this.context);
                this.context.addListener((AsyncListener)this);
            } else {
                this.context = (AsyncContext)Servlet3ContinuationProvider.this.req.getAttribute("cxf.async.context");
            }
        }

        public boolean suspend(long timeout) {
            if (this.isPending) {
                return false;
            }
            this.context.setTimeout(timeout);
            this.isNew = false;
            Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage().getInterceptorChain().suspend();
            this.isPending = true;
            return true;
        }

        public void redispatch() {
            this.context.dispatch();
        }

        public void resume() {
            this.isResumed = true;
            this.isPending = false;
            this.redispatch();
        }

        public void reset() {
            this.context.complete();
            this.obj = null;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean isPending() {
            return this.isPending;
        }

        public boolean isResumed() {
            return this.isResumed;
        }

        public Object getObject() {
            return this.obj;
        }

        public void setObject(Object o) {
            this.obj = o;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage().remove((Object)"cxf.continuation.message");
            this.isPending = false;
            if (this.callback != null) {
                this.callback.onComplete();
            }
        }

        public void onError(AsyncEvent event) throws IOException {
            if (this.callback != null) {
                this.callback.onError(event.getThrowable());
            }
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.isPending = false;
            this.redispatch();
        }
    }
}

