/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;

public class JPATypedQueryVisitor<T>
extends AbstractSearchConditionVisitor<T> {
    private EntityManager em;
    private Class<T> tClass;
    private Root<T> root;
    private CriteriaBuilder builder;
    private CriteriaQuery<T> cq;
    private Stack<List<Predicate>> predStack = new Stack();
    private boolean criteriaFinalized;

    public JPATypedQueryVisitor(EntityManager em, Class<T> tClass) {
        this(em, tClass, null);
    }

    public JPATypedQueryVisitor(EntityManager em, Class<T> tClass, Map<String, String> fieldMap) {
        super(fieldMap);
        this.em = em;
        this.tClass = tClass;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        if (this.builder == null) {
            this.builder = this.em.getCriteriaBuilder();
            this.cq = this.builder.createQuery(this.tClass);
            this.root = this.cq.from(this.tClass);
            this.predStack.push(new ArrayList());
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                this.predStack.peek().add(this.buildPredicate(sc.getConditionType(), statement.getProperty(), statement.getValue()));
            }
        } else {
            this.predStack.push(new ArrayList());
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            List<Predicate> predsList = this.predStack.pop();
            Predicate[] preds = predsList.toArray(new Predicate[predsList.size()]);
            Predicate newPred = sc instanceof OrSearchCondition ? this.builder.or(preds) : this.builder.and(preds);
            this.predStack.peek().add(newPred);
        }
    }

    public TypedQuery<T> getQuery() {
        return this.em.createQuery(this.getCriteriaQuery());
    }

    public CriteriaQuery<T> getCriteriaQuery() {
        if (!this.criteriaFinalized) {
            List<Predicate> predsList = this.predStack.pop();
            this.cq.where(predsList.toArray(new Predicate[predsList.size()]));
            this.criteriaFinalized = true;
        }
        return this.cq;
    }

    private Predicate buildPredicate(ConditionType ct, String name, Object value) {
        Class<?> clazz = value.getClass();
        name = super.getRealPropertyName(name);
        Path<T> path = this.getPath((Path<?>)this.root, name);
        Predicate pred = null;
        switch (ct) {
            case GREATER_THAN: {
                pred = this.builder.greaterThan(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
            case EQUALS: {
                if (clazz.equals(String.class)) {
                    pred = this.builder.like(path.as(String.class), "%" + (String)value + "%");
                    break;
                }
                pred = this.builder.equal(path.as(clazz), clazz.cast(value));
                break;
            }
            case NOT_EQUALS: {
                pred = this.builder.notEqual(path.as(clazz), clazz.cast(value));
                break;
            }
            case LESS_THAN: {
                pred = this.builder.lessThan(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
            case LESS_OR_EQUALS: {
                pred = this.builder.lessThanOrEqualTo(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
            case GREATER_OR_EQUALS: {
                pred = this.builder.greaterThanOrEqualTo(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
        }
        return pred;
    }

    private Path<?> getPath(Path<?> element, String name) {
        if (name.contains(".")) {
            String pre = name.substring(0, name.indexOf(46));
            String post = name.substring(name.indexOf(46) + 1);
            Path newPath = element.get(pre);
            return this.getPath(newPath, post);
        }
        return element.get(name);
    }
}

