/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;

public final class ManagementConsole {
    private static MBeanServerConnection mbsc;
    private static final String DEFAULT_JMXSERVICE_URL = "service:jmx:rmi:///jndi/rmi://localhost:9913/jmxrmi";
    private static final Logger LOG;
    String jmxServerURL;
    String portName;
    String serviceName;
    String operationName;

    ManagementConsole() {
    }

    public void getManagedObjectAttributes(ObjectName name) throws Exception {
        if (mbsc == null) {
            LOG.log(Level.SEVERE, "NO_MBEAN_SERVER");
            return;
        }
        MBeanInfo info = mbsc.getMBeanInfo(name);
        MBeanAttributeInfo[] attrs = info.getAttributes();
        if (attrs == null) {
            return;
        }
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].isReadable()) continue;
            try {
                Object o = mbsc.getAttribute(name, attrs[i].getName());
                System.out.println("\t\t" + attrs[i].getName() + " = " + o);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void connectToMBserver() throws IOException {
        this.jmxServerURL = this.jmxServerURL == null ? DEFAULT_JMXSERVICE_URL : this.jmxServerURL;
        JMXServiceURL url = new JMXServiceURL(this.jmxServerURL);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        mbsc = jmxc.getMBeanServerConnection();
    }

    void listAllManagedEndpoint() {
        try {
            ObjectName queryEndpointName = new ObjectName("org.apache.cxf:type=Bus.Service.Endpoint,*");
            Set endpointNames = CastUtils.cast(mbsc.queryNames(queryEndpointName, null));
            System.out.println("The endpoints are : ");
            for (ObjectName oName : endpointNames) {
                System.out.println(oName);
                this.getManagedObjectAttributes(oName);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "FAIL_TO_LIST_ENDPOINTS", new Object[]{e});
        }
    }

    ObjectName getEndpointObjectName() throws MalformedObjectNameException, NullPointerException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("org.apache.cxf").append(":type=Bus.Service.Endpoint,");
        buffer.append("service=\"" + this.serviceName + "\",");
        buffer.append("port=\"" + this.portName + "\",*");
        return new ObjectName(buffer.toString());
    }

    private void invokeEndpoint(String operation) {
        ObjectName endpointName = null;
        try {
            ObjectName queryEndpointName = this.getEndpointObjectName();
            Set endpointNames = CastUtils.cast(mbsc.queryNames(queryEndpointName, null));
            Iterator it = endpointNames.iterator();
            if (it.hasNext()) {
                endpointName = (ObjectName)it.next();
                mbsc.invoke(endpointName, operation, new Object[0], new String[0]);
                System.out.println("invoke endpoint " + endpointName + " operation " + operation + " succeed!");
            }
        }
        catch (Exception e) {
            if (null == endpointName) {
                LOG.log(Level.SEVERE, "FAIL_TO_CREATE_ENDPOINT_OBEJCTNAME", new Object[]{e});
            }
            LOG.log(Level.SEVERE, "FAIL_TO_INVOKE_MANAGED_OBJECT_OPERATION", new Object[]{endpointName, operation, e.toString()});
        }
    }

    void startEndpoint() {
        this.invokeEndpoint("start");
    }

    void stopEndpoint() {
        this.invokeEndpoint("stop");
    }

    void restartEndpoint() {
        this.invokeEndpoint("stop");
        this.invokeEndpoint("start");
    }

    boolean parserArguments(String[] args) {
        this.portName = "";
        this.serviceName = "";
        this.operationName = "";
        boolean result = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("--port".equals(arg) || "-p".equals(arg)) {
                    this.portName = args[++i];
                    continue;
                }
                if ("--service".equals(arg) || "-s".equals(arg)) {
                    this.serviceName = args[++i];
                    continue;
                }
                if ("--jmx".equals(arg) || "-j".equals(arg)) {
                    this.jmxServerURL = args[++i];
                    continue;
                }
                if (!"--operation".equals(arg) && !"-o".equals(arg)) continue;
                this.operationName = args[++i];
                result = true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return result;
    }

    private static void printUsage() {
        System.out.println("Management Console for CXF Managed Endpoints");
        System.out.println("You can start and stop the endpoints which export as JMX managed objects");
        System.out.println("Usage: -o list ");
        System.out.println("       -o {start|stop|restart} -p PORTQNAME -s SERVICEQNAME ");
        System.out.println("Valid options:");
        System.out.println(" -o [--operation] {list|start|stop|restart}  call the managed endpoint operation");
        System.out.println("                          list: show all the managed endpoints' objectNames and");
        System.out.println("                                attributes");
        System.out.println("                          start: start the endpoint with the -p and -s arguments");
        System.out.println("                          stop: stop the endpoint with the -p and -s arguments");
        System.out.println("                          restart: restart the endpoint with the -p and -s arguments");
        System.out.println(" -p [--port] arg          ARG: the port Qname of the managed endpoint");
        System.out.println(" -s [--service] arg       ARG: the service Qname of the managed endpoint");
        System.out.println(" -j [--jmx] arg           ARG: the JMXServerURL for connecting to the mbean server");
        System.out.println("                           if not using this option, the JMXServerURL will be set as");
        System.out.println("                           \"service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi\"");
    }

    public void doManagement() {
        try {
            this.connectToMBserver();
            if ("list".equalsIgnoreCase(this.operationName)) {
                this.listAllManagedEndpoint();
                return;
            }
            if ("start".equalsIgnoreCase(this.operationName)) {
                this.startEndpoint();
                return;
            }
            if ("stop".equalsIgnoreCase(this.operationName)) {
                this.stopEndpoint();
                return;
            }
            if ("restart".equalsIgnoreCase(this.operationName)) {
                this.restartEndpoint();
                return;
            }
            ManagementConsole.printUsage();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "FAIL_TO_CONNECT_TO_MBEAN_SERVER", new Object[]{this.jmxServerURL});
        }
    }

    public static void main(String[] args) {
        ManagementConsole mc = new ManagementConsole();
        if (mc.parserArguments(args)) {
            mc.doManagement();
        } else {
            ManagementConsole.printUsage();
        }
    }

    static {
        LOG = LogUtils.getL7dLogger(ManagementConsole.class);
    }
}

